/*
 * KOTETU
 * The Admin. Server
 *
 * The program controls (eg. up, down and configuration) proxy server.
 *
 *          by k-chinen@is.aist-nara.ac.jp, 1999
 *
 * $Id$
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sched.h>
#include <pthread.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <signal.h>
#include <setjmp.h>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <errno.h>


#include "range.h"
#include "msg.h"
#include "sigs.h"
#include "socket.h"
#include "sim_stat.h"
#include "misc.h"

#include "img/plate01.jpg.c"


#define DEFAULT_ADMIN_PORT  (10001)

#ifndef STRDUP
#define STRDUP(x)   strdup(x)
#endif
#ifndef FREE
#define FREE(x)     free(x)
#endif



#define STAT_INTERVAL   (1000)
#define STAT_REPORT     (10)
#define STAT_LEN        (1024)



int
parse_simple_request(char *buf, char *me, char *ur, char *ve)
{
    register char *p, *q;
    register int c;

    p = buf;
    q = me;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' ')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';
    if(*p=='\0')
        return -1;

    p++;
    q = ur;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' ')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';
    if(*p=='\0')
        return -1;

    p++;
    q = ve;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' '|| *p=='\r' || *p=='\n')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';
    if(*p=='\0')
        return -1;

    return 0;
}





static int adm_serv_port=DEFAULT_ADMIN_PORT;
static char bin_path[L_BUF];
static char proxy_configname[L_BUF];

static time_t current_time;
static pid_t proxy_pid = -1, resolver_pid = -1;
static time_t last_access=0, last_boot=0;

static int listen_fd = -1;

char req[L_BUF];
char rep[L_BUF];


int
thru_request(int ifd)
{
    int chk;
    int nw, nr;
    off_t nwrite, nread;
    fd_set mask, rfds;
    char buf[L_BUF];
    struct timeval timeout;

    Trace("thru_request:\n");

    nread = 0L;
    nwrite = 0L;

    FD_ZERO(&mask);
    FD_SET(ifd, &mask);

    while(1) {
        rfds = mask;
        timeout.tv_sec = 3;
        timeout.tv_usec = 0;

try_select:
        chk = select(ifd+1, &rfds, NULL, NULL, &timeout);
        if(chk<0) {
            if(errno==EINTR)
                goto try_select;
        }
        if(chk==0) {
            break;
        }

        if(FD_ISSET(ifd, &rfds)) {
try_read:
            nr = read(ifd, buf, L_BUF);
            if(nr<0) {
                if(errno==EINTR)
                    goto try_read;
            }
            if(nr==0) {
                break;
            }

            buf[nr] = '\0';
            strcat(req, buf);

            nread += nr;

            dump_stringchunk("readed ", buf);
            dump_stringchunk("request", req);
        }
        else {
            break;
        }
    }

    dump_stringchunk("request", req);

    return 0;
}

int
send_root(int ofd)
{
    int nwrite;
    char *prefix="HTTP/1.0 200\r\n\
Content-Type: text/html\r\n\
Pragma: no-cache\r\n\
Cache-Control: no-cache\r\n\
\r\n\
<html>\r\n\
<title>KOTETU Admin Server Root Page</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n";
    char *postfix="</html>\r\n";
    char tmp[L_BUF];
    int nw;

    nwrite = 0;

    nw = fdprintf(ofd, prefix);
    if(nw>0) nwrite+=nw;

    nw = fdprintf(ofd, "<img src=\"/plate01.jpg\">\r\n");
    nw = fdprintf(ofd, "<h1>KOTETU Admin Server Root Page</h1>\r\n\r\n");
    if(nw>0) nwrite+=nw;

    if(proxy_pid == -1) {
        nw = fdprintf(ofd ,"<p>proxy is not active</p>\r\n\
<ul>\r\n\
 <li> <a href=\"/up\">start proxy</a>\r\n\
 <li> <a href=\"/config\">change configuration</a>\r\n\
</ul>\r\n\
\r\n");
        if(nw>0) nwrite+=nw;
    }
    else {
        nw = fdprintf(ofd,"<p>proxy pid %d (launched %d sec; %s),\r\n\
    hostname resolver pid %d</p>\r\n",
            proxy_pid, current_time - last_boot,
            display_sec(current_time - last_boot),
            resolver_pid);
        if(nw>0) nwrite+=nw;

        nw = fdprintf(ofd, "\r\n\
\r\n\
<ul>\r\n\
 <li> <a href=\"http://www.self-report.cache/\">show proxy status</a>\r\n\
 <li> <a href=\"/down\">stop proxy </a>\r\n\
 <li> <a href=\"/up\">start proxy again</a>\r\n\
 <li> <a href=\"/config\">change configuration</a>\r\n\
</ul>\r\n\
\r\n");
        if(nw>0) nwrite+=nw;

    }

    nw = fdprintf(ofd, "\r\n\
\r\n\
<ul>\r\n\
 <li> <a href=\"/self\">show this admin. server configuration</a>\r\n\
</ul>\r\n\
\r\n");
    if(nw>0) nwrite+=nw;


    nw = fdprintf(ofd, "\r\n\
<hr noshade>\r\n\
KOTETU\r\n\
\r\n");
    if(nw>0) nwrite+=nw;


    Trace("send_root: write %d byte(s) as control panel\n", nwrite);

    return 0;
}

int
send_self(int ofd)
{
    char *prefix="HTTP/1.0 200\r\n\
Content-Type: text/html\r\n\
\r\n\
<html>\r\n\
<title>KOTETU Admin Server Configuration</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n";
    char *postfix="</html>\r\n";
    char tmp[L_BUF];
    int nw;
    int nwrite;

    nwrite = 0;

    nw = fdprintf(ofd, prefix);
    if(nw>0) nwrite+=nw;

    nw = fdprintf(ofd,
        "<h1>KOTETU Admin Server Current Configuration</h1>\r\n");
    if(nw>0) nwrite+=nw;

    nw = fdprintf(ofd, "<table>\r\n\
<tr><th bgcolor=\"#ccffcc\">name<th bgcolor=\"#ccffcc\">value\r\n");
    if(nw>0) nwrite+=nw;

    nw = fdprintf(ofd, "<tr><td>%s<td align=\"right\">%d\r\n",
            "port", adm_serv_port);
    if(nw>0) nwrite+=nw;

    nw = fdprintf(ofd, "<tr><td>%s<td align=\"right\">%s\r\n",
            "configuration filename", proxy_configname);
    if(nw>0) nwrite+=nw;

    nw = fdprintf(ofd, "</table>\r\n\r\n");
    if(nw>0) nwrite+=nw;


    Trace("send_self: write %d byte(s) as control panel\n", nwrite);

    return 0;
}



int
send_up(int ofd)
{
    char *prefix="<html>\r\n<title>Up KOTETU</title>\r\n<body bgcolor=\"#ffffff\">\r\n";
    char *postfix="<hr noshade>\r\n</html>\r\n";
    char tmp[L_BUF];
    char path[L_BUF];
    pid_t cpid;

    write(ofd, prefix, strlen(prefix));

    sprintf(tmp, "<p><b>pid (proxy %d; resolver %d)</b></p>",
        proxy_pid, resolver_pid);
    write(ofd, tmp, strlen(tmp));

    /*
     *
     */
    sprintf(tmp, "<p>proxy server start...");
    write(ofd, tmp, strlen(tmp));

    sprintf(path, "%s%s", bin_path, "kotetuserv");
    if((cpid=fork())==0) {
#if 0
        close(listen_fd);
        listen_fd = -1;
        shutdown(ofd, 2);
        close(ofd);
        ofd = -1;
#endif

        execl(path, "kotetuserv", "-t", "-f", proxy_configname, NULL);

        exit(36);
    }
    if(cpid<0) {
        Error("cannot exec() when upping proxy.");
    }
    else {
        proxy_pid = cpid;
    }
    sprintf(tmp, "<b>pid %d</b></p>", proxy_pid);
    write(ofd, tmp, strlen(tmp));


    /*
     *
     */
    sprintf(tmp, "<p>hostname resolver start...");
    write(ofd, tmp, strlen(tmp));

    sprintf(path, "%s%s", bin_path, "hres");
    if((cpid=fork())==0) {
#if 0
        close(listen_fd);
        listen_fd = -1;
        shutdown(ofd, 2);
        close(ofd);
        ofd = -1;
#endif

        execl(path, "hres", "dummy-arguments", NULL);

        exit(36);
    }
    if(cpid<0) {
        Error("cannot exec() when upping resolver.");
    }
    else {
        resolver_pid = cpid;
    }
    sprintf(tmp, "<b>pid %d</b></p>", resolver_pid);
    write(ofd, tmp, strlen(tmp));


    write(ofd, postfix, strlen(postfix));

    return 0;
}

int
send_down(int ofd)
{
    char *prefix="<html>\r\n<title>Down KOTETU</title>\r\n<body bgcolor=\"#ffffff\">\r\n";
    char *postfix="<hr noshade>\r\n</html>\r\n";
    char tmp[L_BUF];

    write(ofd, prefix, strlen(prefix));

    sprintf(tmp, "<p><b>pid (proxy %d; resolver %d)</b></p>",
        proxy_pid, resolver_pid);
    write(ofd, tmp, strlen(tmp));

    /*
     *
     */
    if(proxy_pid==-1) {
        sprintf(tmp, "<p>Proxy is not active.</p>");
        write(ofd, tmp, strlen(tmp));
        goto down_resolver;
    }
    if(! kill(proxy_pid, SIGHUP)) {
        proxy_pid = -1;
    }
    else {
        Error("fail proxy killing");
    }

down_resolver:
    /*
     *
     */
    if(resolver_pid==-1) {
        sprintf(tmp, "<p>Resolvers are not active.</p>");
        write(ofd, tmp, strlen(tmp));
        goto footer;
    }
    if(! kill(resolver_pid, SIGHUP)) {
        resolver_pid = -1;
    }
    else {
        Error("fail hostname resolver killing");
    }

footer:
    write(ofd, postfix, strlen(postfix));

    return 0;
}


int
send_config(int ofd)
{
    int chk;
    char *prefix="<html>\r\n<title>KOTETU configuration</title>\r\n<body bgcolor=\"#ffffff\">\r\n";
    char *postfix="<hr noshade>\r\n</html>\r\n";
    char tmp[L_BUF];

    fdprintf(ofd, prefix);

    fdprintf(ofd, "<h1>Configuration</h1>\n");

    SetGlobalDefaults();
    chk = ReadConfigFile(proxy_configname);
    if(chk) {
        fdprintf(ofd, "not found configuration file\n");
    }

    print_configration_FORM(ofd);

    fdprintf(ofd, postfix);

    return 0;
}

int
apply_config(int ifd)
{
    int chk;
    int nw, nr;
    off_t nwrite, nread;
    fd_set mask, rfds;
    char buf[L_BUF];
    struct timeval timeout;
    char line[L_BUF];
    char *cpos;
    char pair[L_BUF];
    char *name, *value;
    register char *p, *q;

    FILE *tmpfp=NULL;
    char *tmpfilename;
    time_t now;
    struct tm *tm;

    Trace("apply_config:\n");

    nread = 0L;
    nwrite = 0L;

    FD_ZERO(&mask);
    FD_SET(ifd, &mask);

    while(1) {
        rfds = mask;
        timeout.tv_sec = 1;
        timeout.tv_usec = 0;

try_select:
        chk = select(ifd+1, &rfds, NULL, NULL, &timeout);
        if(chk<0) {
            if(errno==EINTR)
                goto try_select;
        }
        if(chk==0) {
            break;
        }

        if(FD_ISSET(ifd, &rfds)) {
try_read:
            nr = read(ifd, buf, L_BUF);
            if(nr<0) {
                if(errno==EINTR)
                    goto try_read;
            }
            if(nr==0) {
                break;
            }

            buf[nr] = '\0';
            strcat(req, buf);

            nread += nr;

#if 0
            dump_stringchunk("readed ", buf);
            dump_stringchunk("request", req);
#endif
        }
        else {
            break;
        }
    }

#if 0
    fdprintf(ifd, "HTTP/1.0 200 Ok\r\n\
Content-Type: text/html\r\n\
\r\n\
<html>\r\n\
<body bgcolor=\"#ffffff\">\r\n\
<h1>Sorry, It is dummy page</h1>\r\n\
</html>\r\n\
");
#endif


#if 0
    dump_stringchunk("request", req);
#endif

    cpos = req;
    while((cpos = sgets(req, cpos, line, L_BUF))!=NULL) {
        if(line[0]=='\0') {
            break;
        }
        if(line[0]=='\r' || line[0]=='\n') {
            break;
        }
#if 0
        fprintf(stderr, "header: %s", line);
#endif
    }

    tmpfilename = tempnam(bin_path , "tmpfalcon");
    Trace("temporary filename '%s'\n", tmpfilename);

    tmpfp = fopen(tmpfilename, "wb");
    if(tmpfp==NULL) {
        goto fail;
    }

    now = time(NULL);
    tm = gmtime(&now);
    sprintf(line, "%4d/%02d/%02d %d:%02d:%02d",
        tm->tm_year, tm->tm_mon+1, tm->tm_mday,
        tm->tm_hour, tm->tm_min, tm->tm_sec);
    fprintf(tmpfp, "###\n### generated by form\n### At %s\n###\n", line);

    while((cpos = sgets(req, cpos, line, L_BUF))!=NULL) {
        if(line[0]=='\0') {
            break;
        }
        if(line[0]=='\r' || line[0]=='\n') {
            break;
        }
#if 0
        fprintf(stderr, "body:   %s", line);
#endif

        Chop_CRLF(line);

        p = line;
        while(*p) {
            q = pair;
            while(*p && *p!='&') {
                *q++ = *p++;
            }
            *q = '\0';

#if 0
            fprintf(stderr, "    pair '%s'\n", pair);
#endif

            q = pair;
            while(*q && *q!='=') {
                q++;
            }
            if(*q=='=') {
                *q++ = '\0';
                value = (char*)STRDUP(q);
            }
            else {
                value = (char*)STRDUP("");
            }
            name = (char*)STRDUP(pair);

#if 0
            fprintf(stderr, "        name  '%s'\n", name);
            fprintf(stderr, "        value '%s'\n", value);
#endif

            if(strcmp(name, "send")!=0) {
                fprintf(tmpfp, "#\n%s %s\n", name, value);
            }
            FREE(name);
            FREE(value);

            if(*p!='&') {
                break;
            }
            p++;
        }
    }

    fclose(tmpfp);
    tmpfp = NULL;

    chk = rename(tmpfilename, proxy_configname);
    if(chk) {
        unlink(tmpfilename);
        goto fail;
    }


    fdprintf(ifd, "HTTP/1.0 200 Ok\r\n\
Content-Type: text/html\r\n\
\r\n\
<html>\r\n\
<body bgcolor=\"#ffffff\">\r\n\
<h1>Okay. configration file was updated.</h1>\r\n\
</html>\r\n\
");

    return 0;


fail:
    if(tmpfp!=NULL) {
        fclose(tmpfp);
    }

    fdprintf(ifd, "HTTP/1.0 200 Ok\r\n\
Content-Type: text/html\r\n\
\r\n\
<html>\r\n\
<body bgcolor=\"#ffffff\">\r\n\
<h1>Sorry, error was happen. Please try once more.</h1>\r\n\
</html>\r\n\
");

    return 1;
}

#if 0
/* send binary image */
int
send_image(int ofd, char *ctypestr, int len, char *img)
{
    char *header_format="HTTP/1.0 200\r\n\
Content-Type: %s\r\n\
Content-Length: %d\r\n\
\r\n";
    int nwrite;
    char *pos;
    char *last;
    int width;


    fdprintf(ofd, header_format, ctypestr, len);

    pos = img;
    last = img + len;
    while(pos<last) {
        if(pos+512<last) {
            width = 512;
        }
        else {
            width = last - pos;
        }
        write(ofd, pos, width);
        pos += width;
    }


}

#endif

sim_rec proc_stat;
long proc_stat_count[KB(1)];


main_loop()
{
    int chk;
    char tmp_req[L_BUF];
    char method[L_BUF], url[L_URL], version[L_URL];
    struct hostent *hp;
    char *addrstr;
    int nread, nwrite;
    int cfd;
    struct sockaddr_in from;
    struct in_addr target_addr;
    int from_len;
    struct timeval before, after;
    int c;

    long cv;



    /* boot listener */
    listen_fd = TCP_bind_port(adm_serv_port, -1);
    if( listen_fd < 0 ) {
        fprintf(stderr,
"Specified port is unavilable.  The port was not permitted or already used.\n\
Please check port number and processes.\n");
        exit(4);
    }

    sim_stat_alloc_new(&proc_stat, "retrieval time [msec]",
        KB(1), proc_stat_count);


    while(1) {
        if(proc_stat.count>STAT_INTERVAL) {
            sim_stat_reset(&proc_stat);
        }

        from_len = sizeof(from);
try_accept:
        cfd = accept(listen_fd, (struct sockaddr*)&from, &from_len);
        if(cfd<0) {
            if(errno==EINTR)
                goto try_accept;
            Error("errno %d", errno);
            continue;
        }

/*
        before = time(NULL);
*/
        gettimeofday(&before, NULL);
        nread = nwrite = -1;

        memset(req, 0, L_BUF);
        memset(rep, 0, L_BUF);

        memset(tmp_req, 0, L_BUF);

try_read:
        nread = read(cfd, tmp_req, L_BUF);
#if 0
        fprintf(stderr, "read [%s] %d bytes\n", tmp_req, nread);
#endif
        if(nread<0) {
            if(errno==EINTR) {
                goto try_read;
            }
            Error("cannot read request");

            goto done;
        }
        tmp_req[nread] = '\0';

        strcat(req, tmp_req);

#if 0
        dump_stringchunk("request ", tmp_req);
#endif

#if 0
        /* chop CR or LF */
        {
            register char *p;
            p = tmp_req;
            while(*p) {
                if(*p=='\r' || *p=='\n' || *p==' ' || *p=='\t') {
                    *p='\0';
                    break;
                }
                p++;
            }
        }
#endif


#if 0
        dump_stringchunk("request ", tmp_req);
#endif
        c = parse_simple_request(tmp_req,  method, url, version);
        if(c) {
            Error("ignore request");
            goto ignore_request;
        }

        current_time = time(NULL);

#if 0
        Trace(
"method  %s\n\
url     '%s'\n\
version %s\n",
            method, url, version);
#endif

/* PROC-START */
        if(strcmp(method, "POST")==0) {
            if(strcmp(url, "/config")==0) {
                apply_config(cfd);
                goto done;
            }
            else {
                thru_request(cfd);
                goto done;
            }
        }
        if(strcmp(method, "GET")==0) {
            if(strcmp(url, "/")==0) {
                send_root(cfd);
                goto done;
            }
            if(strcmp(url, "/up")==0) {
                send_up(cfd);
                last_boot = current_time;
                goto done;
            }
            if(strcmp(url, "/down")==0) {
                send_down(cfd);
                goto done;
            }
            if(strcmp(url, "/config")==0) {
                send_config(cfd);
                goto done;
            }
            if(strcmp(url, "/self")==0) {
                send_self(cfd);
                goto done;
            }

            if(strcmp(url, "/plate01.jpg")==0) {
#if 0
                send_image(cfd, "image/jpeg", LE_plate01_jpg, IM_plate01_jpg);
#endif
                HTTP_send_image(cfd, "image/jpeg", LE_plate01_jpg, IM_plate01_jpg);
            }
        }


/* PROC-END */

#if 0
        send_ignore(cfd);
#endif

        sprintf(rep, "HTTP/1.0 403\r\n\
\r\n\
<html>\r\n\
<body bgcolor=\"#ffffff\">\r\n\
<h1>Requested object is not found</h1>\r\n\
<p>\r\n\
Please access <a href=\"/\">root page</a>.\r\n\
</html>\r\n");
        nwrite = write(cfd, rep, strlen(rep));

        goto done;


ignore_request:
        sprintf(rep, "HTTP/1.0 400\r\n\
\r\n\
<html>\r\n\
<body bgcolor=\"#ffffff\">\r\n\
<h1>Ignore Request</h1>\r\n\
<p>\r\n\
Please access <a href=\"/\">root page</a>.\r\n\
</html>\r\n");
        nwrite = write(cfd, rep, strlen(rep));

        goto done;


done:
        last_access = current_time;

        shutdown(cfd, 2);
        close(cfd);

        gettimeofday(&after, NULL);

        cv = ((after.tv_sec%3600)*1000+after.tv_usec/1000)
                -((before.tv_sec%3600)*1000+before.tv_usec/1000) ;

        fprintf(stderr, "takes %d msec\n", cv);


        sim_stat_add_value(&proc_stat, cv);


#if 0
        if(proc_stat.count%STAT_REPORT==0) {
            sim_stat_show(&proc_stat, stderr);
        }
        else {
            sim_stat_show_short(&proc_stat, stderr);
        }
#endif


    }

}

inline static void report_die(pid_t pid)
{
    int i, h;

    if(pid==proxy_pid) {
        Trace("proxy(pid %d) was die.\n", proxy_pid);
        proxy_pid = -1;
    }
    if(pid==resolver_pid) {
        Trace("resolver(pid %d) was die.\n", resolver_pid);
        proxy_pid = -1;
    }
}




/*
 * TrapChildDie - Trap child's die. Check child is what.
 *
 */

RETSIGTYPE TrapChildDie()
{
    pid_t pid;

#ifdef HAVE_WAIT3
    /***
     *** use wait3()
     ***/

#ifdef HAVE_SYS_WAIT_H      /* like POSIX */
    int status;
#else
    union wait status;
#endif
    int i, h;

    while((pid = wait3(&status, WNOHANG | WUNTRACED,
        (struct rusage*)NULL)) > 0 ) {

        report_die(pid);
    }

#else /* HAVE_WAIT3 */



#ifdef HAVE_WAITPID
    /***
     *** use waitpid()
     ***/

#ifdef HAVE_SYS_WAIT_H      /* like POSIX */
    while((pid = waitpid((pid_t)-1, (int*) NULL, WNOHANG | WUNTRACED)) > 0 ) {
        report_die(pid);
    }
#else
    while((pid = wait(-1, (union wait*) NULL, WNOHANG | WUNTRACED)) > 0 ) {
        report_die(pid);
    }
#endif

#else   /* HAVE_WAITPID */
    /***
     *** use wait()
     ***/

#ifdef HAVE_SYS_WAIT_H      /* like POSIX */
    while((pid = wait((int*) NULL)) >= 0 ) {
        report_die(pid);
    }
#else
    while((pid = wait((union wait*) NULL)) >= 0 ) {
        report_die(pid);
    }
#endif


#endif  /* HAVE_WAITPID */

#endif /* HAVE_WAIT3 */
}


void
usage()
{
    fprintf(stdout,
"kotetuadm: KOTETU administrator program\n\
        by k-chinen@is.aist-nara.ac.jp, 1999\n\
\n\
usage: kotetuadm [options]\n\
\n\
option:\n\
    -h          print this message\n\
    -p num      service network port [current %d]\n\
    -f path     filename of proxy configuration [current '%s']\n\
\n\
note:\n\
    Please access this program via WWW client (a.k.a. browser).\n\
            http://localhost:%d/\n\
\n\
\n\
    Anyway, This program playground is '%s'.\n\
    The program will seek related programs and files on the directory.\n\
\n", adm_serv_port, proxy_configname, adm_serv_port, bin_path);

}


int
main(int argc, char **argv)
{
    int flag;
    extern int optind;
    extern char *optarg;


    TraceOn();

    SetSignalHandler(SIGCHLD,   TrapChildDie);       /* generally */

#if 0
    fprintf(stderr, "arg0 '%s'\n", argv[0]);
#endif
    {
        register char *p, *q;
        p = argv[0];
        q = bin_path;
        while(*q++ = *p++)
            ;
        p = bin_path;
        while(q>p) {
            if(*q=='/') {
                *(q+1) = '\0';
                break;
            }
            q--;
        }
        if(q==p) {
            *q = '\0';
        }
    }
#if 0
    fprintf(stderr, "bin_path '%s'\n", bin_path);
#endif

    strcpy(proxy_configname, "kotetu.conf");


    while((flag = getopt(argc, argv, "hp:f"))!=EOF) {
        switch(flag) {
        case 'h':
            usage();
            exit(0);
            break;

        case 'p':
            adm_serv_port = atoi(optarg);
            break;

        case 'f':
            strcpy(proxy_configname, optarg);
            break;

        default:
            usage();
            exit(4);

        }
    }

    main_loop();

}

