/*
 *  KOTETU: Procedures around Arguments
 *      by k-chinen@is.aist-nara.ac.jp, 1995
 *
 *  $Id: args.c,v 1.1 1995/11/04 16:26:05 k-chinen Exp k-chinen $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif


#include "wcol.h"
#include "args.h"


#define MAX_VALUE 16


static arg_t *new_arg()
{
    arg_t *ret;

    ret = (arg_t*) MALLOC(sizeof(arg_t));
    if(ret!=NULL) {
        ret->name = NULL;
        ret->vals = NULL;
        ret->next = NULL;
    }

    return ret;
}


int ShowArgs(arg_t *head)
{
    int c;
    char **val;

    c = 0;
    Trace("head %#x\n", head);
    while(head) {
        Trace("%3d: %c '%s' -> (", c, head->next==0 ? 'E':'-', head->name);
        val = head->vals;
        if(val) {
            while(*val) {
                Trace(" \"%s\"", *val);
                val++;
            }
        }
        Trace(" )\n");

        head = head->next;
        c++;
    }
    Trace("; %d args\n\n", c);

    return 0;
}


static FILE *fp=NULL;

/*
 *  ReadArgsFromFile - Read arguments from file
 *
 *  return:
 *      -1  error
 *      >=0 success (number of arguments)
 */
int ReadArgsFromFile(char *fname, arg_t **ret_args)
{
    arg_t **c;
    char pline[STRING_SIZE], line[STRING_SIZE], tmp[STRING_SIZE];
    register char *p, *q;
    char *v[MAX_VALUE];
    int i, vn, num=0;
    int ignoreline=0;
    int lno;

    if(fname==NULL || *fname=='\0') {
        Trace("ReadArgFile: no specified configure file\n");
        return -1;
    }

    if(fp!=NULL) {
        fclose(fp);
    }

    if((fp=fopen(fname, "r"))==NULL) {
        Error("ReadArgFile: cannot open file '%s'", fname);
        return -1;
    }

#if 0
                    Trace(";   address=%#x\n",   ret_args);
    if(ret_args)    Trace(";  *address=%#x\n",  *ret_args);
    if(*ret_args)   Trace("; **address=%#x\n", **ret_args);
#endif

    c = ret_args;

    /*
     * line  - (logical) line
     * pline - physical line
     */
    lno = 0;
    line[0] = '\0';
    while(fgets(pline, STRING_SIZE, fp)!=NULL) {
        lno++;

        /* chop linefeed or newline in line*/
        p = pline;
        q = NULL;
        while(*p&&*p!='\r'&&*p!='\n')
            q = p++;
        *p = '\0';

#if 0
        Trace(";0;%d; %s\n", lno, pline);
#endif

        if(q && *q=='\\') {
            *q = '\0';
            if(ignoreline==0 && strlen(line)+strlen(pline)+1<STRING_SIZE) {
                strcat(line, pline);
            }
            else {
                ignoreline = 1;
                line[0] = '\0';
            }
            continue;
        }

        ignoreline = 0;
        strcat(line, pline);

#if 0
        Trace(";1;%d; %s\n", lno, line);
#endif

        /* skip whites */
        p = line;
        while(*p=='\t'||*p==' ')
            p++;


        if(*p=='\0'||*p=='#') {
            line[0] = '\0';
            continue;
        }



        /*
         * Read a argument
         */
        num++;

#if 0
        Trace(";2;%d; %s\n", lno, p);
#endif

#if 0
                        Trace("\t  c %#x\n", c);
        if(c)           Trace("\t *c %#x\n", *c);
        if(*c)          Trace("\t**c %#x\n", **c);
#endif

        *c = new_arg();
        if(*ret_args==NULL)
            *ret_args = *c;

#if 0
                        Trace("\t  c %#x\n", c);
        if(c)           Trace("\t *c %#x\n", *c);
        if(*c)          Trace("\t**c %#x\n", **c);
                        Trace(";   address=%#x\n",   ret_args);
        if(ret_args)    Trace(";  *address=%#x\n",  *ret_args);
        if(*ret_args)   Trace("; **address=%#x\n", **ret_args);
#endif

        /*
         * Parse Args
         */
        /* name */
        q = tmp;
        while(isalnum(*p)) {
            *q++ = *p++;
        }
        *q = '\0';
        if(STRDUP((*c)->name, tmp)==NULL) {
            return -1;
        }

        /* values */
        vn = 0;
        while(*p && vn < MAX_VALUE) {
            while(*p==' '||*p=='\t')
                p++;

            q = tmp;
            if(*p=='"') {
                p++;
                while(*p && ((*p=='"' && *(p-1)=='\\') || *p!='"' )) {
                    *q++ = *p++;
                }
                if(*p=='"')
                    p++;
            }
            else {
                while(*p && *p!='\t' && *p!=' ') {
                    *q++ = *p++;
                }
            }
            *q = '\0';

            if(STRDUP(v[vn],tmp)==NULL) {
                return -1;
            }

            vn++;
        }

#if 0
        if(((*c)->vals = (char**)MALLOC(sizeof(char*)*(vn+1)))!=NULL) {
#endif
        if(((*c)->vals = (char**)alloc_str(vn))!=NULL) {
            for(i=0;i<vn;i++) {
                (*c)->vals[i] = v[i];
            }
        }
        (*c)->vals[vn] = NULL;

#if 0
        Trace("\taddress=%#x\n", *c);
        Trace("\tname='%s'\n", (*c)->name);
        for(i=0;i<vn;i++) {
            Trace("\t\tvalue[%d]='%s'\n", i, (*c)->vals[i]);
        }
#endif

        c = &(*c)->next;
        line[0] = '\0';
    }

    fclose(fp);

    return num;
}


static void FreeArg(arg_t *a)
{
    char **p;

    if(a->next!=NULL) {
        FreeArg(a->next);
        FREE(a->next);
    }

    FREE(a->name);
    p = a->vals;
    while(*p!=NULL) {
        FREE(*p);
        p++;
    }
    FREE(a->vals);
}

void FreeArgs(arg_t *args)
{
    FreeArg(args);
    FREE(args);
}

#ifdef TEST_ARG
main()
{
    arg_t *args;

    TraceOn();

    if(args)
        Trace("*** address %#x, * %#x, ** %#x\n", &args, args, *args);
    else
        Trace("*** address %#x, * %#x\n", &args, args);
    ReadArgsFromFile("sample.conf", &args);
    if(args)
        Trace("*** address %#x, * %#x, ** %#x\n", &args, args, *args);
    else
        Trace("*** address %#x, * %#x\n", &args, args);
    ShowArgs(args);
}
#endif




