/*
 *
 */
#ifndef CACHE_H
#define CACHE_H

#define K(x)    (x*1024)
#define M(x)    (x*1024*1024)
#define G(x)    (x*1024*1024*1024)

#define dK(x)   (x/1024)
#define mK(x)   (x%1024)
#define dM(x)   (x/(1024*1024))
#define mM(x)   (x%(1024*1024))
#define dG(x)   (x/(1024*1024*1024))
#define mG(x)   (x%(1024*1024*1024))


typedef struct _line_cntl_rec {
    int type;
    int oid;
    int lhash;
/*
    unsigned char name[K(4)];
*/
    unsigned char name[L_URL];
    int owner;
    int hot;
    int count;
    int cracked;
    int totallength;
    int length;
    int size;
    time_t lmd;                     /* last modified */
    time_t expire;                  /* expire */

    struct _line_cntl_rec* next;
} line_cntl_rec;

typedef struct {
    line_cntl_rec cntl;
    unsigned char *body;
} line_rec;


typedef struct {
    int type;
    pthread_mutex_t mutex;
    line_cntl_rec *last_pos;
} block_cntl_rec;


#define TYPE_EMPTY_LINE     0x0000
#define TYPE_NORMAL_LINE    0x0001
#define TYPE_SLAVE_LINE     0x0002
#define TYPE_BLOCK_CONTROL  0x0100

/*
 * the size of received data was tend to MTU.
 * To opitimize performance, the program allocates byte chunk more than MTU.
 *
 * the most of origanization network is ethernet.
 * so, it was reasonable that use traditional ethenet's MTU (1460).
 *
 */
#ifndef TYPICAL_MTU
#define TYPICAL_MTU         (1460)
#endif

#ifndef MAX_LINE_PER_OBJ
#define MAX_LINE_PER_OBJ    (32)
#endif
#ifndef MAX_LINE_PER_WRITE
#define MAX_LINE_PER_WRITE  (16)
#endif


extern off_t cachetotal;
extern off_t lfu_area_size;
extern off_t htrie_area_size;

extern unsigned char *_htrie_slot;
extern int     nline;
extern int     nblock;
extern int     linesize;
extern int     datasize;

extern pthread_mutex_t lfu_mutex;
extern unsigned char *_lfu_slot;
extern int     ldatasize;
extern int     lnslot;


extern int cache_alloc_area(off_t rq_size,
                int rq_m, off_t rq_jsize, off_t rq_bsize, int rq_dsize);

#ifdef NO_MEMORY_CHECK
extern void* cache_block_pos(int);
#else
#define cache_block_pos(fh) ((void*)&_htrie_slot[nline*linesize*fh])
#endif

#endif
