/*
 * system configuration checking program with sysconf()
 *      by k-chinen@is.aist-nara.ac.jp, 1999
 *
 * $Id$
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

char *DEL = " \t";

void
usage(char *name)
{
    fprintf(stdout,
"chk_sysconf: System configuration checking program with sysconf().\n\
\n\
This program reads system configuration parameters from specified file\n\
and apply these parameters to sysconf().\n\
\n\
example:\n\
    %% %s /usr/include/sys/unistd.h\n\
\n", name);

    exit(1);

}

int
main(int argc, char **argv)
{
    FILE *fp;
    char *fname;
    char line[10240];
    int i;
    char *token;
    char *name;
    char *v;
    int  sv, r;

    if(argc==1) {
        usage(argv[0]);
    }

    for(i=1;i<argc;i++) {
        if(strcmp("-h", argv[i])==0) {
            usage(argv[0]);
        }

        fname = argv[i];
        fp = fopen(fname, "r");
        if(fp==NULL) {
            continue;
        }

        while(fgets(line, 10240, fp)!=NULL) {
/*
fprintf(stdout, "> %s", line);
*/
            token = strtok(line, DEL);
            if(token && strcmp(token, "#define")==0) {
                name = strtok(NULL, DEL);
                if(name && strncmp(name, "CTL_", 4)==0) {
                    v = strtok(NULL, DEL);
                    if(v) {
                        sv = atoi(v);
/*
fprintf(stdout, "name '%s' v '%s' sv %d", name, v, sv);
*/
                        r = sysconf(sv);
                        if(r == -1) {
fprintf(stdout, "%-40s not implemented (%d)\n", name, errno);
                        }
                        else {
fprintf(stdout, "%-40s implemented [%12d]\n", name, r);
                        }
                    }
                }
            }
        }

        fclose(fp);
    }
}


