/*
 *  KOTETU:   dates procedures
 *      by  k-chinen@is.aist-nara.ac.jp, 1994-1996, 1999, 2000
 *          mikio-n@is.aist-nara.ac.jp, 1999
 *
 * $Id: date.c,v 1.1 1996/11/24 14:49:14 k-chinen Exp k-chinen $
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#define _DEBUG_DATE

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <errno.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include "wcol.h"

#ifdef KOTETU_SUB_TIME
#undef KOTETU_SUB_TIME
#endif

#define KOTETU_SUB_TIME(x,y) \
        ( (x.tv_sec  - y.tv_sec )*1000 + (x.tv_usec - y.tv_usec)/1000 )


#ifdef HAVE_MKTIME
#define MKTIME(x)   mktime(x)
#else
#define MKTIME(x)   _mktime(x)
#endif



static int
_parse_month(char *m)
{
    if(strcasecmp_first_all(m,'J',"Jan"))
        return  0;
    if(strcasecmp_first_all(m,'F',"Feb"))
        return  1;
    if(strcasecmp_first_all(m,'M',"Mar"))
        return  2;
    if(strcasecmp_first_all(m,'A',"Apr"))
        return  3;
    if(strcasecmp_first_all(m,'M',"May"))
        return  4;
    if(strcasecmp_first_all(m,'J',"Jun"))
        return  5;
    if(strcasecmp_first_all(m,'J',"Jul"))
        return  6;
    if(strcasecmp_first_all(m,'A',"Aug"))
        return  7;
    if(strcasecmp_first_all(m,'S',"Sep"))
        return  8;
    if(strcasecmp_first_all(m,'O',"Oct"))
        return  9;
    if(strcasecmp_first_all(m,'N',"Nov"))
        return 10;
    if(strcasecmp_first_all(m,'D',"Dec"))
        return 11;
    return -1;
}

static int
_parse_wkday(char *m)
{
    if(strcasecmp_first_all(m,'S',"Sun"))
        return 0;
    if(strcasecmp_first_all(m,'M',"Mon"))
        return 1;
    if(strcasecmp_first_all(m,'T',"Tue"))
        return 2;
    if(strcasecmp_first_all(m,'W',"Wed"))
        return 3;
    if(strcasecmp_first_all(m,'T',"Thu"))
        return 4;
    if(strcasecmp_first_all(m,'F',"Fri"))
        return 5;
    if(strcasecmp_first_all(m,'S',"Sat"))
        return 6;
    return -1;
}

static time_t
wcol_mktime(struct tm *TM)
{
    return mktime(TM);

#if 0

    /*
     * for unbelievable system which not have mktime().
     */
#if 0
    /* very dirty */
    ret = sec + min*60 + hour*60*60
            + day*60*60*24 + mon*60*60*24*31 + year*60*60*24*31*12;
#else
    /* very very dirty (for save last one bit) */
    ret = sec/2 + min*30 + hour*30*60
            + day*30*60*24 + mon*30*60*24*31 + year*30*60*24*31*12;
#endif

#endif

}

/*
 * parse_date - parse date (rfc1123, rfc850 and asctime() styles)
 *
 *  rfc1123         wkday, dd month yyyy hh:mm:ss "GMT"
 *  rfc850          weekday, dd-month-yy hh:mm:ss "GMT"
 *  asctime         wkday month day hh:mm:ss yyyy
 *
 * input:
 *      string
 * output:
 *      UTC (a.k.a GMT) with time_t
 */

time_t
parse_date(char *line)
{
    struct tm TM;
    time_t ret;
    char _wkday[10];
    char _month[10];
    int  _year;
    int year, mon, day;
    int hour, min, sec;
    char *p, *q;
    int c;
    char tz[5] = "NULL";

#ifdef DEBUG_DATE
    Trace("parse_date: <%s>\n", line);
#endif

    p = line;
    /* skip whites */
    while(*p==' '||*p=='\t') {
        p++;
    }
#ifdef DEBUG_DATE
    Trace("parse_date: remove whites <%s>\n", line);
#endif

    /* store 'wkday' or 'weekday', and shift to next field */
    c = 0;
    q = _wkday;
    while(*p && (*p!=' ' && *p!=',') && c<10) {
        *q++ = *p++;
        c++;
    }
    *q = '\0';

#ifdef DEBUG_DATE
    Trace("parse_date: weekday '%s'(%d) -> ", _wkday, c);
    _wkday[3] = '\0';
    Trace("%d\n", _parse_wkday(_wkday));
    Trace("parse_date: current '%s'\n", p);
#endif

    if(*p==',') {   /* rfc1123 or rfc850 */
        p++;
        while(*p==' ')
            p++;

        if(isdigit(*p)) {
            q = p;

            /* seek '-' */
            while(*q && isdigit(*q))
                q++;
            if(*q==' ')
                goto rfc1123_date;
            else
            if(*q=='-')
                goto rfc850_date;
        }
    }

    /* otherwise, asctime */

asctime_date:
#ifdef DEBUG_DATE
    Trace("parse_date: asctime date ");
#endif
           /* month XX XX:XX:XX XXXX */
    while(*p == ' ') {
    p++;
    }
    if(sscanf(p,"%c%c%c %d %d:%d:%d %d",
        &_month[0],&_month[1],&_month[2], &day, &hour,&min,&sec, &_year)
            != 8) {
        return -1;
    }

    _month[3] = '\0';
    mon = _parse_month(_month);
    year = _year - 1900;
    goto out;

rfc1123_date:
#ifdef DEBUG_DATE
    Trace("parse_date: rfc1123 date ");
#endif

           /* XX month XXXX XX:XX:XX TZ*/
    if(sscanf(p,"%d %c%c%c %d %d:%d:%d %s",
        &day, &_month[0],&_month[1],&_month[2], &_year, &hour,&min,&sec,&tz)
            != 9) {
        return -1;
    }
    _month[3] = '\0';
    mon = _parse_month(_month);
    if(_year >= 1900)
    year = _year - 1900;
    goto out;

rfc850_date:
#ifdef DEBUG_DATE
    Trace("parse_date: rfc850 date ");
#endif

           /* XX-month-XX XX:XX:XX */
    if(sscanf(p,"%d-%c%c%c-%d %d:%d:%d %s",
        &day, &_month[0],&_month[1],&_month[2], &year, &hour,&min,&sec, &tz)
            != 9) {
        return -1;
    }
    _month[3] = '\0';
    mon = _parse_month(_month);
    goto out;


out:

#ifdef DEBUG_DATE
    Trace(" -><%d %d %d %d %d %d %s %s>",
        year, mon, day, hour, min, sec, _wkday, tz);
#endif

    TM.tm_year = year;
    TM.tm_mon  = mon;
    TM.tm_mday = day;
    TM.tm_hour = hour;
    TM.tm_min  = min;
    TM.tm_sec  = sec;
    TM.tm_isdst= 0;

    /* reject ignore month */
    if(mon < 0) {
        return -1;
    }

    ret = MKTIME(&TM);
#ifdef DEBUG_DATE
    Trace(" ->%d (errno=%d)\n", ret, errno);
#endif
    if ((strncmp(tz, "GMT", 3) == 0)) {
/*
        ret += 3600*9;
*/
    }
    else if ((strncmp(tz, "JST", 3) == 0)) {
        ret -= 3600*9;
    }
    else if ((strncmp(tz, "NULL", 4) == 0)) {
/*
        ret += 3600*9;
*/
    }
    else {
    ret = -1;
    }
#ifdef DEBUG_DATE
    Trace("parse_date: <%s> %d\n", line, ret);
#endif
    return ret;
}


#ifdef TEST_DATE

/***
If you want test routines in this file, compile this file with -DTEST_DATE .

% cc -DHAVE_CONFIG -DHAVE_MKTIME -DTEST_DATE date.c

Example:

% ./a.out "Sat, 15 Apr 2000 01:18:10 JST" "Fri, 14 Apr 2000 16:18:10 GMT"
Sat, 15 Apr 2000 01:18:10 JST -> 955696690
Fri, 14 Apr 2000 16:18:10 GMT -> 955696690

 ***/

void
main(int argc, char **argv)
{
	int i;
	time_t ep;

	argv++;
	for(i=1;i<argc;i++) {
		ep = parse_date(*argv);
		fprintf(stdout, "%s -> %d\n", *argv, ep);
		argv++;
	}
}
#endif

