/*
 *  KOTETU: hostname resolution procedures.
 *      by k-chinen@is.aist-nara.ac.jp, 1994, 1995
 *
 *  $Id: hname.c,v 1.1 1996/10/29 10:18:20 k-chinen Exp k-chinen $
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>

#include "wcol.h"


/*
 * addr_byname - find address structure by name
 *
 * return:
 *      1   error
 *      0   success
 */
int addr_byname(char *hostname, int portno, struct sockaddr_in *addr)
{
    struct hostent  *hp;

#if 0
    Trace("addr_byname: host-'%s'\n", hostname);
#endif

    if(hostname[0]=='\0') {
        return 1;
    }
    if((hp=gethostbyname(hostname)) == NULL ) {
        Trace("addr_byname: not found host-'%s'\n", hostname);
        return 1;
    }

    memset(addr, 0, sizeof(addr));
    addr->sin_family = hp->h_addrtype;
    addr->sin_port = htons(portno);
    memcpy(&(addr->sin_addr.s_addr), hp->h_addr, hp->h_length);

#if 0
    Trace("addr_byname: found host-'%s'\n", hostname);
#endif

    return 0;
}


/*
 * addr_bynumber - find address structure by digit number for IP address
 *
 * return:
 *      1   error
 *      0   success
 */
int addr_bynumber(char *hostname, int portno, struct sockaddr_in *addr)
{
    /* support only digit */
    if(hostname[0]=='\0' || !isdigit(hostname[0])) {
        Trace("addr_bynumber: ignore digit address-'%s'\n", hostname);
        return 1;
    }

    memset(addr, 0, sizeof(addr));
    addr->sin_family = AF_INET;
    addr->sin_port = htons(portno);
    addr->sin_addr.s_addr = inet_addr(hostname);

    return 0;
}


/*
 * find_addr - find address structure by string
 *
 * return:
 *      1   error
 *      0   success
 */
int find_addr(char *hostname, int portno, struct sockaddr_in *addr)
{
    /* support only digit */
    if(hostname[0]=='\0') {
        return 1;
    }

#if 0
    if(fetch_hostname_cache(hostnamem, addr)) {
        return 0;
    }
#endif

    if(isdigit(hostname[0])) {
        return addr_bynumber(hostname, portno, addr);
    }
    else {
        return addr_byname(hostname, portno, addr);
    }
}


