/*
 * code-name 'KOTETU'
 *
 * proxy_main.c : main body for proxy server.
 *
 *      by k-chinen@is.aist-nara.ac.jp, 1999
 *
 * $Id$
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif
#ifdef HAVE_POLL_H
#include <poll.h>
#include <sys/poll.h>
#endif
#ifdef HAVE_SELECT_H
#include <sys/select.h>
#endif

#include <strings.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <errno.h>


#include "wcol.h"
#include "socket.h"
#include "misc.h"

#include "cache.h"
#include "sim_stat.h"



#include "http.h"

#include "sess.h"

char *MSG_M_[]={
  "UNKNOW",
  "HEAD",
  "GET",
  "POST",
  "OPTION",
  "PUT",
  "DELETE",
  "TRACE",
};


int
HTTP_find_header_term(char *line, int limit)
{
    register char *p, *q;
    register int c;

    c = 0;
    p = line;
    q = NULL;
    while(*p && c<limit) {
        if(*p=='\n') {
            if(*(p+1)=='\n') {      /* LF LF */
                p++;
                goto find;
            }
            if(*(p+1)=='\r') {      /* LF CR (LF) */
                p += 2;
                goto find;
            }
        }
next:
        p++;
        c++;
    }
    goto fail;

find:
    return p-line;

fail:
    return -1;
}


int
HTTP_parse_version(char *vstr, int *ma, int *mi)
{
    register char *p, *q;
    int c;
    char tmp[L_URL];

    if(vstr==NULL || *vstr=='\0') {
        return -1;
    }
#if 0
Trace("HTTP_parse_version: vstr '%s'\n", vstr);
#endif

    p = vstr;
    if(*p!='H') goto fail;
    p++;
    if(*p!='T') goto fail;
    p++;
    if(*p!='T') goto fail;
    p++;
    if(*p!='P') goto fail;
    p++;
    if(*p!='/') goto fail;
    p++;

    q = tmp;
    c = 0;
    while(c<L_URL && *p>='0' && *p<='9') {
        *q++ = *p++;
        c++;
    }
    *ma = atoi(tmp);

    if(*p!='.') {
        goto fail;
    }

    p++;

    q = tmp;
    c = 0;
    while(c<L_URL && *p>='0' && *p<='9') {
        *q++ = *p++;
        c++;
    }
    *mi = atoi(tmp);

done:
#if 0
Trace("  got <%d.%d>\n", *ma, *mi);
#endif

    return *ma;

fail:
Trace("HTTP_parse_version: vstr '%s' -> <%d.%d>\n", vstr, *ma, *mi);
    *ma = -1;
    *mi = -1;
    return -1;
}

int
HTTP_parse_simple_request(char *buf, int *rmethod, char *ur, char *ve)
{
    register char *p, *q;
    register int c;
    char me[L_URL];

    p = buf;
    q = me;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' '||*p=='\t'||*p=='\r'||*p=='\n')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';
    if(*p=='\0')
        return -1;

    if(strcasecmp_first_all(me, 'G', "GET")) {
        *rmethod = M_GET;
    }
    else
    if(strcasecmp_first_all(me, 'H', "HEAD")) {
        *rmethod = M_HEAD;
    }
    else
    if(strcasecmp_first_all(me, 'P', "PUT")) {
        *rmethod = M_PUT;
    }
    else
    if(strcasecmp_first_all(me, 'P', "POST")) {
        *rmethod = M_POST;
    }
    else
    if(strcasecmp_first_all(me, 'T', "TRACE")) {
        *rmethod = M_TRACE;
    }
    else
    if(strcasecmp_first_all(me, 'O', "OPTION")) {
        *rmethod = M_OPTION;
    }
    else {
        *rmethod = M_UNKNOW;
    }

    p++;

    q = ur;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' '||*p=='\t'||*p=='\r'||*p=='\n')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';

    if(c>=L_URL) {
        return -2;              /* URL buffer overrun */
    }

    if(*p=='\0') {              /* line is end */
        if(q==ur) {             /* URL is empty */
            return -1;
        }
        else {
            strcpy(ve, "HTTP/0.9");
            return 0;
        }
    }

    p++;
    q = ve;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' '|| *p=='\r' || *p=='\n')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';
    if(*p=='\0')
        return -1;

    return 0;
}

int
HTTP_parse_cachefields(char *buf, int len, int *xcachable, int *xreload)
{
    register char *p, *q, *r;
    int cachable, reload;
    char token[STRING_SIZE];

    p = buf;
    r = buf + len;
    cachable = *xcachable;
    reload  = *xreload;

    while(p<r) {
        while(p<r && *p!='\n') {
            p++;
        }
        p++;
#if 0
        dump_stringsegment("field line", p, r-p);
#endif
        if(*p=='P' || *p=='p') {
#if 0
            Trace("found 'P' or 'p'\n");
#endif

            if(strncasecmp(p, "pragma:", 7)==0) {
#if 0
                Trace("found 'Pragma'\n");
#endif

                while(p<r && (*p!=' ' && *p!='\t')) {
                    p++;
                }
                while(p<r && (*p==' ' || *p=='\t')) {
                    p++;
                }
                if(p<r && strncasecmp(p, "no-cache", 8)==0) {
                    reload  = 1;
                }
            }
        }

        if((*p=='C' || *p=='c')
          && strncasecmp(p, "Cache-Control:", 13)==0) {
            while(p<r && (*p!=' ' && *p!='\t')) {
                p++;
            }

#if 0
            while(p<r && (*p==' ' || *p=='\t')) {
                p++;
            }
            if(p<r && strncasecmp(p, "no-cache", 8)==0) {
                reload  = 1;
            }
#endif

            p += 14;

            while(p<r && *p!='\r' && *p!='\n') {
                /* skip white */
                while(p<r && (*p==' ' || *p=='\t')) {
                    p++;
                }

                q = token;
                while(p<r && *p!=','
                  && *p!='\r' && *p!='\n' && *p!=' ' && *p!='\t') {
                    *q++ = *p++;
                }
                *q = '\0';
#if 1
Trace("1Token '%s'\n", token);
#endif

                /* skip white */
                while(p<r && (*p==' ' || *p=='\t')) {
                    p++;
                }


                if(*token) {
                    if(strcasecmp(token, "no-cache")==0) {
                        reload  = 1;
                    }
                    if(strcasecmp(token, "private")==0) {
                        cachable = 0;
                    }
                }
                if(*p=='\r' || *p!='\n') {
                    break;
                }
                if(*p==',') {
#if 0
Trace("cont.\n");
#endif
                    p++;
                    continue;
                }
                break;
            }

        }


        if((*p=='A' || *p=='a')
          && strncasecmp(p, "Authorization:", 14)==0) {
            cachable = 0;
            reload = 1;
        }

        if((*p=='S' || *p=='s')
          && strncasecmp(p, "Set-Cookie:", 11)==0) {
            cachable = 0;
            reload = 1;
        }

    }

    *xcachable = cachable;
    *xreload = reload;

    return 0;
}


int
HTTP_parse_request_header(char *buf,
    int *rmethod, char *ur, char *ve,
    int *xims,
    int *xcachable, int *xreload)
{
    register char *p, *q, *r;
    register int c;
    char me[L_URL];
    char token[STRING_SIZE];
    int cachable, reload;
    int ims;

#if 0
    dump_stringchunk("req.", buf);
#endif

    p = buf;
    q = me;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' '||*p=='\t'||*p=='\r'||*p=='\n')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';
    if(*p=='\0')
        return -1;

    /*
     * method
     */

    if(strcasecmp_first_all(me, 'G', "GET")) {
        *rmethod = M_GET;
    }
    else
    if(strcasecmp_first_all(me, 'H', "HEAD")) {
        *rmethod = M_HEAD;
    }
    else
    if(strcasecmp_first_all(me, 'P', "PUT")) {
        *rmethod = M_PUT;
    }
    else
    if(strcasecmp_first_all(me, 'P', "POST")) {
        *rmethod = M_POST;
    }
    else
    if(strcasecmp_first_all(me, 'T', "TRACE")) {
        *rmethod = M_TRACE;
    }
    else
    if(strcasecmp_first_all(me, 'O', "OPTION")) {
        *rmethod = M_OPTION;
    }
    else {
        *rmethod = M_UNKNOW;
    }

    /*
     * URL
     */
    p++;
    q = ur;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' '||*p=='\t'||*p=='\r'||*p=='\n')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';

    if(c>=L_URL) {
        return -2;              /* URL buffer overrun */
    }

    /*
     * version
     */

    if(*p=='\0') {              /* line is end */
        if(q==ur) {             /* URL is empty */
            return -1;
        }
        else {
            strcpy(ve, "HTTP/0.9");
            return 0;
        }
    }

    p++;
    q = ve;
    c = 0;
    while(*p && c<L_URL) {
        if(*p==' '|| *p=='\r' || *p=='\n')
            break;
        c++;
        *q++ = *p++;
    }
    *q = '\0';
    if(*p=='\0')
        return -1;


/*
    p = buf;
    r = buf + len;
*/
    r = p + strlen(p);

    cachable = *xcachable;
    reload  = *xreload;
    ims = -1;

    while(p<r) {
        while(p<r && *p!='\n') {
            p++;
        }
        p++;
#if 0
        dump_stringsegment("field line", p, r-p);
#endif
        if(*p=='P' || *p=='p') {
#if 0
            Trace("found 'P' or 'p'\n");
#endif

            if(strncasecmp(p, "pragma:", 7)==0) {
#if 0
                Trace("found 'Pragma'\n");
#endif

                while(p<r && (*p!=' ' && *p!='\t')) {
                    p++;
                }
                while(p<r && (*p==' ' || *p=='\t')) {
                    p++;
                }
                if(p<r && strncasecmp(p, "no-cache", 8)==0) {
                    reload  = 1;
                }
            }
        }

        if((*p=='C' || *p=='c')
          && strncasecmp(p, "Cache-Control:", 13)==0) {
#if 0
            while(p<r && (*p!=' ' && *p!='\t')) {
                p++;
            }
            while(p<r && (*p==' ' || *p=='\t')) {
                p++;
            }
            if(p<r && strncasecmp(p, "no-cache", 8)==0) {
                reload  = 1;
            }
#endif

#if 0
Trace("CC [%s", p);
#endif

            p += 14;


            while(p<r && *p!='\r' && *p!='\n') {
                /* skip white */
                while(p<r && (*p==' ' || *p=='\t')) {
                    p++;
                }

                q = token;
                while(p<r && *p!=',' && *p!='\r' && *p!='\n' && *p!=' ' && *p!='\t') {
                    *q++ = *p++;
                }
                *q = '\0';
#if 1
Trace("2Token '%s'\n", token);
#endif

                /* skip white */
                while(p<r && (*p==' ' || *p=='\t')) {
                    p++;
                }


                if(*token) {
                    if(strcasecmp(token, "no-cache")==0) {
                        reload  = 1;
                    }
                    if(strcasecmp(token, "private")==0) {
                        cachable = 0;
                    }
                }
                if(*p=='\r' || *p!='\n') {
                    break;
                }
                if(*p==',') {
Trace("cont.\n");
                    p++;
                    continue;
                }
                break;
            }


        }

        if((*p=='A' || *p=='a')
          && strncasecmp(p, "Authorization:", 14)==0) {
            cachable = 0;
            reload = 1;
        }

        if((*p=='S' || *p=='s')
          && strncasecmp(p, "Set-Cookie:", 11)==0) {
            cachable = 0;
            reload = 1;
        }

        if((*p=='I' || *p=='i')
            /*               123456789012345678 */
          && strncasecmp(p, "If-Modified-Since:", 18)==0) {
            /*
            dump_string(";IMS ", p);
            */
            ims = parse_date(p+19);
            /*
            Trace("; epoch %d\n", ims);
            */
        }

    }

    *xcachable = cachable;
    *xreload = reload;
    *xims = ims;

    return 0;
}


int
HTTP_parse_response_code(char *area, int len)
{
    int r;
    char tmp[L_URL];
    register char *p, *q;

    r = -1;

#if 0
    Trace("HTTP_parse_response_code: area %p, len %d\n", area, len);
    dump_stringsegment("response top line", area, len);
#endif

    /*
     *  123456789012
     *  HTTP/1.0 XXX
     */
    if(len<12) {
        return -1;
    }

    p = area;
    if(*p!='H' || strncmp(p, "HTTP/", 5)!=0) {
        return -1;
    }

    p += 5;
    q = tmp;
    while(*p && ((*p>='0' && *p<='9') || *p=='.')) {
        *q++ = *p++;
    }
    *q = '\0';

    p++;
    q = tmp;
    while(*p && (*p>='0' && *p<='9')) {
        *q++ = *p++;
    }
    *q = '\0';

    r = atoi(tmp);
    if(r<100 || r>599) {
        return -1;
    }
    else {
        return r;
    }
}

/*
 * a target header area must have termination.
 * this code believe that conditions.
 */

int
HTTP_parse_response_header(char *area, int len,
    int *xvmajor, int *xvminor,
    int *xrcode, time_t *xlmd, time_t *xexpire, off_t *xclen,
    int *xcachable, int *xreload)
{
    int ret;
    char line[L_BUF];
    char token[STRING_SIZE];
    register char *p, *q;
    register char *cpos;
    int chk;

    ret = -1;

    *xrcode     = -1;
    *xlmd       = -1;
    *xexpire    = -1;
    *xclen      = -1;
#if 0
    *xcachable  = 1;
    *xreload    = 1;
#endif

#if 0
    Trace("HTTP_parse_response_head: area %p, len %d\n", area, len);
    dump_stringchunk("res.", area);
/*
    dump_stringsegment("res.", area, len);
*/
#endif

    cpos = area;
    cpos = sgets(area, cpos, line, L_BUF);
    if(cpos==NULL || line[0]=='\0') {
        goto fail;
    }
    chk = HTTP_parse_version(line, xvmajor, xvminor);
#if 0
    Trace("  ver %d.%d\n", *xvmajor, *xvminor);
#endif

    if(*xvmajor<1) {
        goto fine;
    }

    *xrcode = HTTP_parse_response_code(line, strlen(line));
#if 0
    Trace("  rcode %d\n", *xrcode);
#endif

    ret = 0;

    while((cpos = sgets(area, cpos, line, L_BUF))!=NULL) {
        if(line[0]=='\0' || line[0]=='\r' || line[0]=='\n') {
            break;
        }

        if((line[0]=='L' || line[0]=='l')
                                /*12345678901234 */
            && strncasecmp(line, "Last-Modified:", 14)==0) {
            *xlmd = parse_date(line+15);
#if 0
    Trace("  lmd %d\n", *xlmd);
#endif
        }
        if((line[0]=='E' || line[0]=='e')
                                /*12345678901234 */
            && strncasecmp(line, "Expires:", 8)==0) {
            *xexpire = parse_date(line+9);
#if 0
    Trace("  expire %d\n", *xexpire);
#endif
        }
        if((line[0]=='C' || line[0]=='c')
                                /*123456789012345 */
            && strncasecmp(line, "Content-Length:", 15)==0) {
            *xclen = (off_t)atol(line+16);
#if 0
    Trace("  clen %ld\n", (long)*xclen);
#endif
        }
        if((line[0]=='C' || line[0]=='c')
                                /*123456789012345 */
            && strncasecmp(line, "Cache-Control:", 14)==0) {

            p = line;

#if 0
Trace("CC %p [%s", p, p);
#endif

            p += 14;

            while(*p && *p!='\r' && *p!='\n') {
                /* skip white */
                while(*p && (*p==' ' || *p=='\t')) {
                    p++;
                }

                q = token;
                while(*p && *p!=',' && *p!='\r' && *p!='\n' && *p!=' ' && *p!='\t') {
                    *q++ = *p++;
                }
                *q = '\0';
#if 0
Trace("3Token '%s'\n", token);
#endif

                /* skip white */
                while(*p && (*p==' ' || *p=='\t')) {
                    p++;
                }

                if(*token) {
                    if(strcasecmp(token, "public")==0) {
                        *xcachable = 1;
                    }
                    if(strcasecmp(token, "private")==0) {
                        *xcachable = 0;
                    }
                    if(strcasecmp(token, "no-cache")==0) {
                        *xreload  = 1;
                    }
                    if(strncasecmp(token, "no-cache", 8)==0) {
                        *xreload  = 1;
                    }
                }
                if(*p=='\0' || *p=='\r' || *p=='\n') {
                    break;
                }
                if(*p==',') {
#if 0
Trace("cont. <%p>\n", p);
#endif
                    p++;
                    continue;
                }

#if 0
Trace("last char. %d %#x '%s'\n", *p, *p, *p);
#endif
                break;
            }


        }

    }

fine:

    return ret;

fail:

    return -1;
}


/* send binary image */
int
HTTP_send_image(int ofd, char *ctypestr, int len, char *img)
{
    char *header_format="HTTP/1.0 200\r\n\
Content-Type: %s\r\n\
Content-Length: %d\r\n\
\r\n";
    int nwrite;
    char *pos;
    char *last;
    int width;
    int tr;
    int sum;

    sum = 0;

    tr = fdprintf(ofd, header_format, ctypestr, len);
    if(tr>0) sum += tr;

    pos = img;
    last = img + len;
    while(pos<last) {
        if(pos+512<last) {
            width = 512;
        }
        else {
            width = last - pos;
        }
try_write:
        tr = write(ofd, pos, width);
        if(tr<0) {
            if(errno==EINTR)
                goto try_write;
            Error("HTTP_send_image: fail write() (%d)", errno);

            return sum;
        }

        sum += tr;
        pos += width;
    }

    return sum;
}



int
HTTP_SendIgnoreMessage(int cfd, int rcode, char *short_msg, char *long_msg)
{
    char tmp[L_BUF];
    int nw;

    if(cfd<0) {
        return -1;
    }

    sprintf(tmp, "HTTP/1.0 %d %s\r\n\r\n%s\r\n",
        rcode, short_msg, long_msg);

    nw = write(cfd, tmp, strlen(tmp));

#if 0
    if(nw>=0) {
        MUTEX_LOCK(&stat_lock);
        intra_outgoing += (off_t) nw;
        MUTEX_UNLOCK(&stat_lock);
    }
#endif

    return nw;
}





