/*
 *  KOTETU: Informations
 *      by k-chinen@is.aist-nara.ac.jp, 1994, 1995
 *
 * $Id: info.h,v 1.7 1996/07/26 18:27:22 k-chinen Exp k-chinen $
 */

#ifndef KOTETU_INFO_H
#define KOTETU_INFO_H

/*                       0123456789ABCDEF */
#define KOTETU_INFO_ID    "KOTETU-INFO-0.050"




#ifndef CACHEKEEPTIME
#define CACHEKEEPTIME               (60*60*24*30)   /* 1 month */
#endif
#ifndef CACHEIGNOREKEEPTIME
#define CACHEIGNOREKEEPTIME         (30*60)         /* 30 min */
#endif

#ifndef MCACHE_THRESHOLD
#define MCACHE_THRESHOLD            (10*1024)       /* 10 kbytes */
#endif




#define INFOSIZE        (2048)

#define INFOVERSIZE     (16)
#define INFOTYPESIZE    (64)
#define INFONAMESIZE    (1024)



#ifndef EVAL_OFFSET
#define EVAL_OFFSET 10000
#endif



/*
 * Information structure
 *      store attributes
 */
typedef union {
    char dummy[INFOSIZE];           /* Allocate Info Size */
    struct {
        char    id[INFOVERSIZE];    /* Identifier */

        /*** <base> HTTP/0 ***/
        char    name[INFONAMESIZE]; /* Name (e.g., URN or URL) */

        /*** HTTP/1.0 ***/
        int     state;              /* State code (e.g., 200,403 or 501) */
        char    ver_major;          /* Version major number */
        char    ver_minor;          /* Version minor number */
        char    type[INFOTYPESIZE]; /* Type (e.g., text/html or image/gif) */
        off_t   length;             /* Length */
        time_t  lmd;                /* Last Modifid Date */

        /*** for keep alive ***/
        off_t   clength;            /* Content-Length of server responce */

        /*** for network ***/
        long    take_time;          /* Take Time to get [ms]
                                        (conn_time + trans_time) */
        long    conn_time;          /* Connection Time  [ms] */
        long    trans_time;         /* Translation Time [ms] */

        /*** for cache ***/
        int     init_state;         /* Initial State */
        off_t   hsize;              /* Header Size */
        off_t   bsize;              /* Body Size */
        long    count;              /* Access Count */
        time_t  first;              /* Create Date */
        time_t  last;               /* Last Access Date */
        time_t  expire;             /* Expire Date */

        /*** for memory cache ***/
        void    *phead;             /* pointor to header */
        void    *pbody;             /* pointor to body */

    } attr;
} Info ;


void ClearInfo(Info *info);
Info *NewInfo();
Info *DeleteInfo(Info *v);
int  SaveInfo(Info *info, char *name);
int  What(Info *info);
Info *Have(char *path);
int  UpdateInfo(char *name);
int  DiscardInfo(char *name);



extern time_t cache_keeptime;
extern time_t cache_ignorekeeptime;


#endif /* KOTETU_INFO_H */




