/*
 *  KOTETU: misc procedures
 *      by k-chinen@is.aist-nara.ac.jp, 1995
 *
 *  $Id: misc.c,v 1.2 1996/11/24 14:49:37 k-chinen Exp k-chinen $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>

#include <errno.h>

/*
#include "wcol.h"
*/
#include "range.h"
#include "msg.h"


#if 0
void
peek_str(FILE *fp, char *prefix, char *str, int len)
{
    int i;

    fprintf(fp, "%s ", prefix);
    for(i=0;i<len;i++) {
        if(str[i]=='\r')  {
            fputc('\\', fp);
            fputc('r', fp);
        }
        else
        if(str[i]=='\n')  {
            fputc('\\', fp);
            fputc('n', fp);
        }
        else
        if(str[i]=='\t')  {
            fputc('\\', fp);
            fputc('t', fp);
        }
        else {
            fputc(str[i], fp);
        }
    }
    fprintf(fp, "\n");
}

#endif


/***
 *** For Debug, Display 'What its read ?'
 ***/

/*
 * dump string segment
 */
void
dump_stringsegment(char *prefix, char *str, int len)
{
    char lline[L_BUF];
    register int c, i;
    register char *p, *q;

    if(str==NULL || len<=0) {
        return;
    }

#if 0
    /* range check */
    p = str;
    q = lline;
    for(i=0;i<len;i++) {
        *q = *p;
        p++;
    }
#endif

    lline[0] = '\0';
    strcat(lline, prefix);
    q = lline;
    c = 0;
    while(*q) {
        if(c>=L_BUF-1) {
            *q = '\0';
            Trace("%s", lline);
            q = lline;
            c = 0;
        }
        q++;
        c++;
    }

    *q++ = '[';
    c++;

    p = str;
    i = 0;
    while(i<len) {
        if(c>=L_BUF-1) {
            *q = '\0';
            Trace("%s", lline);
            q = lline;
            c = 0;

            continue;
        }

        if(*p=='\0')  {
            *q++ = '{';
            *q++ = 'N';
            *q++ = 'U';
            *q++ = 'L';
            *q++ = 'L';
            *q++ = '}';
        }
        else
        if(*p=='\r')  {
            *q++ = '{';
            *q++ = 'C';
            *q++ = 'R';
            *q++ = '}';
        }
        else
        if(*p=='\n')  {
            *q++ = '{';
            *q++ = 'L';
            *q++ = 'F';
            *q++ = '}';
        }
        else {
            if(*p<' ' || *p>0x7f) {
                *q++ = '{';
                *q++ = "01234567890abcdefz"[*p/16];
                *q++ = "01234567890abcdefz"[*p%16];
                *q++ = '}';
            }
            else {
                *q++ = *p;
            }
        }

        p++;
        i++;
        c++;
    }

    *q++ = ']';
    c++;

    *q++ = '\n';
    c++;

    if(c>0) {
        *q = '\0';
        Trace("%s", lline);
        q = lline;
        c = 0;
    }

}


/*
 * dump string line
 */

void dump_string(char *prefix, char *line)
{
    unsigned char *p;

    Trace("%s[", prefix);
    p = (unsigned char*) line;
    if(*p) {
        while(*p&&*p!='\r'&&*p!='\n') {
            if(*p<' ' || *p>0x7f) {
                Trace("{%02x}",*p);
            }
            else {
                Trace("%c",*p);
            }
            p++;
        }
        if(*p=='\0')
            Trace("{NULL}");

        if(*p=='\r') {
            Trace("{CR}");
            p++;
        }
        if(*p=='\n')
            Trace("{LF}");
        Trace("]\n");
    }
    else {
        Trace("<EMPTY>]\n");
    }
}

/*
 * dump string chunk
 */

void dump_stringchunk(char *prefix, char *chunk)
{
    unsigned char *p, *q, *t;
    char *l;
    unsigned char buf[L_BUF];
    char label[STRING_SIZE];
    char tmp[STRING_SIZE];
    int  c;
    int  k;

    if(strlen(prefix)>STRING_SIZE) {
        strcpy(label, "CHUNK ");
    }
    else {
        memset(label, ' ', strlen(prefix));
        label[strlen(prefix)] = '\0';
    }

    c = 0;

    p = (unsigned char*) chunk;
    if(!*p) {
        Trace("%s %03d[<EMPTY>]\n", prefix, c);
        return;
    }

    l = prefix;
    while(*p) {
        sprintf(tmp, "%s %03d[", l, c);
        c++;

        q = buf;
        t = (unsigned char*)tmp;
        while(*t) {
            *q++ = *t++;
        }
        *q = '\0';

        while(*p&&*p!='\r'&&*p!='\n') {
            if(*p<' ' || *p>0x7f) {
                sprintf(tmp, "{%02x}",*p);
                t = (unsigned char*)tmp;
                while(*t) {
                    *q++ = *t++;
                }
                *q = '\0';
            }
            else {
                *q++ = *p;
                *q = '\0';
            }
            p++;
        }
        if(*p=='\0') {
            sprintf(tmp, "{NULL}");
            t = (unsigned char*)tmp;
            while(*t) {
                *q++ = *t++;
            }
            *q = '\0';
        }

        if(*p=='\r') {
            sprintf(tmp, "{CR}");
            t = (unsigned char*)tmp;
            while(*t) {
                *q++ = *t++;
            }
            *q = '\0';
            p++;
        }
        if(*p=='\n') {
            sprintf(tmp, "{LF}");
            t = (unsigned char*)tmp;
            while(*t) {
                *q++ = *t++;
            }
            *q = '\0';
            p++;
        }
        sprintf(tmp, "]");
        t = (unsigned char*)tmp;
        while(*t) {
            *q++ = *t++;
        }
        *q = '\0';
        Trace("%s\n", buf);

        l = label;
    }
}






static char work_day_str[STRING_SIZE];

/*
 * display_sec - convert time_t to string
 */
char *display_sec(time_t t)
{
    time_t w, d, h, m, s;

    w = t;
    d = w / (24 * 60 * 60);

    w = w % (24 * 60 * 60);
    h = w / (60 * 60);

    w = w % (60 * 60);
    m = w / (60);
    s = w % (60);

#if 0
    sprintf(work_day_str,
        " %3d day %02d:%02d:%02d (%8d) ", d, h, m, s, t);
#else
    sprintf(work_day_str, " %3d day %02d:%02d:%02d ", d, h, m, s);
#endif

    return work_day_str;
}

char *conv_sectoshortstr(char *buf, time_t t)
{
    time_t w, d, h, m, s;
    int chk;

    w = t;
    d = w / (24 * 60 * 60);

    w = w % (24 * 60 * 60);
    h = w / (60 * 60);

    w = w % (60 * 60);
    m = w / (60);
    s = w % (60);

    if(d>0) {
        chk = sprintf(buf, "%dd_%02d:%02d:%02d", d, h, m, s);
    }
    else {
        chk = sprintf(buf, "%02d:%02d:%02d", h, m, s);
    }

    if(chk<0) {
        return NULL;
    }

    return buf;
}

char *conv_sectostr(char *buf, time_t t)
{
    time_t w, d, h, m, s;
    int chk;

    w = t;
    d = w / (24 * 60 * 60);

    w = w % (24 * 60 * 60);
    h = w / (60 * 60);

    w = w % (60 * 60);
    m = w / (60);
    s = w % (60);

    chk = sprintf(buf, "%3d day %02d:%02d:%02d", d, h, m, s);
    if(chk<0) {
        return NULL;
    }

    return buf;
}



char *display_msec(time_t t)
{
    time_t w, d, h, m, s;

    w = t/1000;
    d = w / (24 * 60 * 60);

    w = w % (24 * 60 * 60);
    h = w / (60 * 60);

    w = w % (60 * 60);
    m = w / (60);
    s = w % (60);

#if 0
    sprintf(work_day_str,
        " %3d day %02d:%02d:%02d (%8d) ", d, h, m, s, t);
#else
    sprintf(work_day_str, " %3d day %02d:%02d:%02d ", d, h, m, s);
#endif

    return work_day_str;
}



static char work_time_str[STRING_SIZE];

/*
 *
 */
char *conv_time(off_t t)
{
    int f;
    off_t v;

    if(t<0) {
        f = -1;
        t = -t;
    }
    else {
        f = 1;
    }

    if(t>_DAY_CONST_) {
        v = t/_DAY_CONST_;
        if(f>0)
            sprintf(work_time_str, "%4dd", v);
        else
            sprintf(work_time_str, "%4dd", -v);
    }
    else {
        if(t>_HOUR_CONST_) {
            v = t/_HOUR_CONST_;
            if(f>0)
                sprintf(work_time_str, "%4dh", v);
            else
                sprintf(work_time_str, "%4dh", -v);
        }
        else {
            sprintf(work_time_str, "%4dsec", t);
        }
    }

    return NULL;
}



static char work_byte_str[STRING_SIZE];

/*
 *
 */
char *conv_byte(off_t t)
{
    int f;
    off_t v;

    if(t<0) {
        f = -1;
        t = -t;
    }
    else {
        f = 1;
    }

#if 0
    Log("; %d %ld %lld / %i %li %lli\n", t,t,t, t,t,t);
#endif

#if SIZEOF_OFF_T > SIZEOF_LONG
    if(t>(off_t)_GB_CONST_) {
        v = t/(off_t)_GB_CONST_;
        if(f>0)
            sprintf(work_byte_str, "%4lldGB", v);
        else
            sprintf(work_byte_str, "%4lldGB", -v);
    }
    else {
        if(t>(off_t)_MB_CONST_) {
            v = t/(off_t)_MB_CONST_;
            if(f>0)
                sprintf(work_byte_str, "%4lldMB", v);
            else
                sprintf(work_byte_str, "%4lldMB", -v);
        }
        else {
            if(t>(off_t)_KB_CONST_) {
                v = t/(off_t)_KB_CONST_;
                if(f>0)
                    sprintf(work_byte_str, "%4lldKB", v);
                else
                    sprintf(work_byte_str, "%4lldKB", -v);
            }
            else {
                sprintf(work_byte_str, "%4lldB", t);
            }
        }
    }
#else
    if(t>(off_t)_GB_CONST_) {
        v = t/(off_t)_GB_CONST_;
        if(f>0)
            sprintf(work_byte_str, "%4dGB", v);
        else
            sprintf(work_byte_str, "%4dGB", -v);
    }
    else {
        if(t>(off_t)_MB_CONST_) {
            v = t/(off_t)_MB_CONST_;
            if(f>0)
                sprintf(work_byte_str, "%4dMB", v);
            else
                sprintf(work_byte_str, "%4dMB", -v);
        }
        else {
            if(t>(off_t)_KB_CONST_) {
                v = t/(off_t)_KB_CONST_;
                if(f>0)
                    sprintf(work_byte_str, "%4dKB", v);
                else
                    sprintf(work_byte_str, "%4dKB", -v);
            }
            else {
                sprintf(work_byte_str, "%4dB", t);
            }
        }
    }
#endif

    return work_byte_str;
}

char *conv_byte_real(off_t t)
{
    int f;
    double v;

    if(t<0) {
        f = -1;
        t = -t;
    }
    else {
        f = 1;
    }

    if(t>(off_t)_GB_CONST_) {
        v = ((double)t)/_GB_CONST_;
        if(f>0)
            sprintf(work_byte_str, "%7.2fGB", v);
        else
            sprintf(work_byte_str, "%7.2fGB", -v);
    }
    else {
        if(t>(off_t)_MB_CONST_) {
            v = ((double)t)/_MB_CONST_;
            if(f>0)
                sprintf(work_byte_str, "%7.2fMB", v);
            else
                sprintf(work_byte_str, "%7.2fMB", -v);
        }
        else {
            if(t>(off_t)_KB_CONST_) {
                v = ((double)t)/_KB_CONST_;
                if(f>0)
                    sprintf(work_byte_str, "%7.2fKB", v);
                else
                    sprintf(work_byte_str, "%7.2fKB", -v);
            }
            else {
                sprintf(work_byte_str, "%4dB", t);
            }
        }
    }

    return work_byte_str;
}



/*
 *
 */
char *Chop_CRLF(char *line)
{
    char *p;

    if(line==NULL) {
        return NULL;
    }

    p = line;
    while(*p) {
        if(*p=='\r' && *(p+1)=='\n' && *(p+2)=='\0') {
            *p = '\0';
            break;
        }
        if(*p=='\n' && *(p+1)=='\0') {
            *p = '\0';
            break;
        }
        p++;
    }

    return line;
}

/*
 *
 */
char *sgets(char *hbuf, char *pos, char *buf, int blen)
{
    char *p, *q;
    int  c;

    if(pos==NULL) {
        return NULL;
    }

#if 0
    dump_string("      rest", pos);
#endif

    q = buf;
    p = pos;
    c = 0;

    while(*p&&c<blen) {
        c++;
        if(*p=='\n') {
            *q++ = *p++;
            *q = '\0';
            return p;
        }
        *q++ = *p++;
    }
    *q = '\0';

    if(p==pos)
        return NULL;
    else
        return p;
}






