/*
 *  KOTETU: Message procedures (for loggin and debug)
 *      by k-chinen@is.aist-nara.ac.jp, 1994, 1995
 *
 * $Id: msg.h,v 1.3 1995/10/09 10:51:50 k-chinen Exp k-chinen $
 */

#ifndef KOTETU_MSG_H
#define KOTETU_MSG_H


/* When facility is not specifyed, set it as LOG_DAEMON */
#ifndef LOG_FACILITY
#define LOG_FACILITY LOG_DAEMON
#endif

#ifndef LOG_LINESIZE
#define LOG_LINESIZE        (1024)
#endif
#ifndef LOG_FILENAMESIZE
#define LOG_FILENAMESIZE    (512)
#endif
#ifndef LOG_INTERVAL
#define LOG_INTERVAL        (32)
#endif
#ifndef LOG_BUF_LEN
#define LOG_BUF_LEN (LOG_LINESIZE*(LOG_INTERVAL+2)+1)
#endif


#ifdef __STDC__
int InitLogger(char *name);
int RawTrace(const char *fmt, ...);
void LogSync(void);
int Log(const char *fmt, ...);
int DLog(const char *fmt, ...);
int Error(const char *fmt, ...);
int Fatal(const char *fmt, ...);
int SwitchLog(char *logpath, char *note);
int fdprintf(const int fd, const char *fmt, ...);
#else
int InitLogger();
int RawTrace();
void LogSync();
int Log();
int DLog();
int Error();
int Fatal();
int SwitchLog();
int fdprintf();
#endif

void TraceOn();
void TraceOff();
void TracePop();
void TracePush();



/* warp function with _trace_flag_ checking */
#define Trace if(_trace_flag_>0) RawTrace


extern volatile int _trace_flag_;


#endif /* KOTETU_MSG_H */

