/*
 *  HTML Parse program
 *      by k-chinen@is.aist-nara.ac.jp, 1994, 1995
 *
 * Warnning: Apply only HTML, don't apply others.
 *
 * $Id: parse.h,v 1.3 1995/10/09 10:33:04 k-chinen Exp k-chinen $
 */

#ifndef KOTETU_PARSE_H
#define KOTETU_PARSE_H


/*
 * This is # of slot, 2**n is beauty :-)
 */
#define NUM_SLOT         (64)
#define NUM_INDEX       (300)

#define PARSE_REFERED    (1U<<0)
#define PARSE_INCLUDED   (1U<<1)


typedef struct _pa_cell {
    char *val;                  /* target (e.g., URL) */
    int  num;                   /* number */
    struct _pa_cell *next;
} pa_cell;

typedef struct {
    int     count;
    pa_cell *slot[NUM_SLOT];    /* open hash (a.k.a. 'chain') */
} tags_t;



tags_t *HTML_NewTags();
int HTML_DestroyTags(tags_t *);
int HTML_DestroyTags_withoutvalue(tags_t *);
int HTML_ShowTags(char*, tags_t*);
#if 0
int HTML_ParseTags(tags_t*, char*, int);
#endif

char **HTML_ConvURLList(tags_t*, int*);
void HTML_ShowURLList(char**);
void HTML_FreeURLList(char**);

#endif /* KOTETU_PARSE_H */

