/*
 * KOTETU:
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#include <sys/types.h>
#include <time.h>
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif

#include <netinet/in.h>
#include <netdb.h>

#include <errno.h>

#include "wcol.h"
#include "args.h"
#include "http.h"
#include "sim_stat.h"
#include "sess.h"

/*
 * externals
 */

/* automatic */
extern                       char config_filename[];
extern                        int trace_flag;
extern                        int monitor_flag;
extern                        int prefetch_flag;
extern                        int service_portno;
extern                      char* localdomain_padding;
extern                      char* report_hook_hostname;
extern                        int require_sess_length;
extern                        int require_n_handler;
extern                        int require_chunk_size;
extern                      off_t require_total_memory_size;
extern                        int require_num_large_block;
extern                        int require_size_large_block;
extern                        int require_size_block;
extern                        int require_minimum_size_line;
extern                        int num_prefetch_referedpages;
extern                        int num_prefetch_includedobjs;

/* static */
extern pid_t    wcol_pid;
extern char     *progname;

/* end of externals */

char config_file[STRING_SIZE];
char dummy_string[STRING_SIZE];


/*
 * SetGlobalDefaults -
 */
void
SetGlobalDefaults()
{
    strcpy(config_filename, DEFAULT_CONFIGFILE);
    trace_flag = 1;
    monitor_flag = 1;
    prefetch_flag = 1;
    service_portno = (int) HTTP_PROXYPORTNO;
    localdomain_padding = strdup(".kotetu.proxy.cache");
    report_hook_hostname = strdup("www.self-report.cache");
    require_sess_length = (int) 2048;
    require_n_handler = (int) 4;
    require_chunk_size = (int) 32;
    require_total_memory_size = (off_t) 32*(1048576);
    require_num_large_block = (int) 0;
    require_size_large_block = (int) 1*(1048576);
    require_size_block = (int) 2048*(1024);
    require_minimum_size_line = (int) 12*(1024);
    num_prefetch_referedpages = (int) 8;
    num_prefetch_includedobjs = (int) 16;
}
/* end of SetGlobalDefaults() */





#define MAX_AV 10

/*
 * ReadConfigFile -
 */
void ReadConfigFile(char *filename)
{
    arg_t  *args, *pargs;
    int     num;
    int     tint;
    char   *av[MAX_AV];
    int     i, j;


    Trace("ReadConfigFile: filename='%s'\n", filename);
    if((num=ReadArgsFromFile(filename, &args))<=0) {
        Trace("ReadConfigFile: no arguments\n");
        return;
    }

    pargs = args;
    while(pargs) {
        /* project argument value to temporary pointor */
        for(i=0;pargs->vals[i] && i<MAX_AV;i++) {
            av[i] = pargs->vals[i];
        }
        for(j=i;j<MAX_AV;j++) {
            av[j] = NULL;
        }

        if(!pargs->name) {
            /* nothing */
            goto nextone;
        }
        else
        if(strcasecmp_first_all(pargs->name, 'C', "ConfigFile")) {
            if(pargs->vals[0]) {
                strcpy(config_filename,av[0]);
                goto nextone;
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'T', "Trace")) {
            trace_flag = 1;
            goto nextone;
        }
        else
        if((pargs->name[0]=='N' || pargs->name[0]=='n')
            && (pargs->name[1]=='O' || pargs->name[1]=='o')
            && strcasecmp(&pargs->name[2], "Trace")==0) {
            trace_flag = 0;
            goto nextone;
        }
        else
        if(strcasecmp_first_all(pargs->name, 'M', "Monitor")) {
            monitor_flag = 1;
            goto nextone;
        }
        else
        if((pargs->name[0]=='N' || pargs->name[0]=='n')
            && (pargs->name[1]=='O' || pargs->name[1]=='o')
            && strcasecmp(&pargs->name[2], "Monitor")==0) {
            monitor_flag = 0;
            goto nextone;
        }
        else
        if(strcasecmp_first_all(pargs->name, 'P', "Prefetch")) {
            prefetch_flag = 1;
            goto nextone;
        }
        else
        if((pargs->name[0]=='N' || pargs->name[0]=='n')
            && (pargs->name[1]=='O' || pargs->name[1]=='o')
            && strcasecmp(&pargs->name[2], "Prefetch")==0) {
            prefetch_flag = 0;
            goto nextone;
        }
        else
        if(strcasecmp_first_all(pargs->name, 'S', "ServicePort")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    service_portno = (int) tint * 1;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'L', "LocalDomain")) {
            if(pargs->vals[0]) {
                localdomain_padding = strdup(av[0]);
                goto nextone;
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'R', "ReportHook")) {
            if(pargs->vals[0]) {
                report_hook_hostname = strdup(av[0]);
                goto nextone;
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'N', "NumSession")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    require_sess_length = (int) tint * 1;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'N', "NumHandler")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    require_n_handler = (int) tint * 1;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'S', "SessionChunkLength")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    require_chunk_size = (int) tint * 1;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'T', "TotalMemorySize")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    require_total_memory_size = (off_t) tint * 1048576;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'N', "NumLargeBlock")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    require_num_large_block = (int) tint * 1;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'L', "LargeBlockSize")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    require_size_large_block = (int) tint * 1048576;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'B', "BlockSize")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    require_size_block = (int) tint * 1024;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'M', "MinimumLineSize")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    require_minimum_size_line = (int) tint * 1024;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'N', "NumPrefetchReferedPages")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    num_prefetch_referedpages = (int) tint * 1;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'N', "NumPrefetchIncludedObjects")) {
            if(pargs->vals[0]) {
                if((tint = atoi(av[0]))>0) {
                    num_prefetch_includedobjs = (int) tint * 1;
                    goto nextone;
                }
            }
        }
        else
        if(strcasecmp_first_all(pargs->name, 'M', "MaxLinePerWrite")) {
            /* nothing */
            goto nextone;
        }
        else
        if(strcasecmp_first_all(pargs->name, 'M', "MaxLinePerObj")) {
            /* nothing */
            goto nextone;
        }
        else {
            Error("Unknow argument '%s'", pargs->name);
            goto nextone;
        }
fail:
        Error("Argment specification ('%s') is wrong", pargs->name);
nextone:
        pargs = pargs->next;
    }

    FreeArgs(args);
}



/*
 * FixGlobals - Fix global vars.
 */
void
FixGlobals()
{

    if(service_portno<1) {
        Error("FixGlobals: 'ServicePort' is too small (min %d)",1);
        service_portno = (int) 1;
    }
    if(service_portno>32000) {
        Error("FixGlobals: 'ServicePort' is too large (max %d)",32000);
        service_portno = (int) 32000;
    }
    if(require_sess_length<128) {
        Error("FixGlobals: 'NumSession' is too small (min %d)",128);
        require_sess_length = (int) 128;
    }
    if(require_sess_length>N_SESS_MAX) {
        Error("FixGlobals: 'NumSession' is too large (max %d)",N_SESS_MAX);
        require_sess_length = (int) N_SESS_MAX;
    }
    if(require_n_handler<1) {
        Error("FixGlobals: 'NumHandler' is too small (min %d)",1);
        require_n_handler = (int) 1;
    }
    if(require_n_handler>N_HANDLER_MAX) {
        Error("FixGlobals: 'NumHandler' is too large (max %d)",N_HANDLER_MAX);
        require_n_handler = (int) N_HANDLER_MAX;
    }
    if(require_chunk_size<1) {
        Error("FixGlobals: 'SessionChunkLength' is too small (min %d)",1);
        require_chunk_size = (int) 1;
    }
    if(require_chunk_size>SESS_CHUNK_SIZE) {
        Error("FixGlobals: 'SessionChunkLength' is too large (max %d)",SESS_CHUNK_SIZE);
        require_chunk_size = (int) SESS_CHUNK_SIZE;
    }
    if(require_num_large_block<0) {
        Error("FixGlobals: 'NumLargeBlock' is too small (min %d)",0);
        require_num_large_block = (int) 0;
    }
    if(require_num_large_block>32) {
        Error("FixGlobals: 'NumLargeBlock' is too large (max %d)",32);
        require_num_large_block = (int) 32;
    }
    if(require_size_large_block<1 * 1048576 ) {
        Error("FixGlobals: 'LargeBlockSize' is too small (min %d)",1);
        require_size_large_block = (int) ( 1 * 1048576 ) ;
    }
    if(require_size_large_block>32 * 1048576 ) {
        Error("FixGlobals: 'LargeBlockSize' is too large (max %d)",32);
        require_size_large_block = (int) ( 32 * 1048576 );
    }
    if(require_size_block<128 * 1024 ) {
        Error("FixGlobals: 'BlockSize' is too small (min %d)",128);
        require_size_block = (int) ( 128 * 1024 ) ;
    }
    if(require_size_block>10240 * 1024 ) {
        Error("FixGlobals: 'BlockSize' is too large (max %d)",10240);
        require_size_block = (int) ( 10240 * 1024 );
    }
    if(require_minimum_size_line<4 * 1024 ) {
        Error("FixGlobals: 'MinimumLineSize' is too small (min %d)",4);
        require_minimum_size_line = (int) ( 4 * 1024 ) ;
    }
    if(require_minimum_size_line>1024 * 1024 ) {
        Error("FixGlobals: 'MinimumLineSize' is too large (max %d)",1024);
        require_minimum_size_line = (int) ( 1024 * 1024 );
    }
    if(num_prefetch_referedpages<0) {
        Error("FixGlobals: 'NumPrefetchReferedPages' is too small (min %d)",0);
        num_prefetch_referedpages = (int) 0;
    }
    if(num_prefetch_referedpages>64) {
        Error("FixGlobals: 'NumPrefetchReferedPages' is too large (max %d)",64);
        num_prefetch_referedpages = (int) 64;
    }
    if(num_prefetch_includedobjs<0) {
        Error("FixGlobals: 'NumPrefetchIncludedObjects' is too small (min %d)",0);
        num_prefetch_includedobjs = (int) 0;
    }
    if(num_prefetch_includedobjs>128) {
        Error("FixGlobals: 'NumPrefetchIncludedObjects' is too large (max %d)",128);
        num_prefetch_includedobjs = (int) 128;
    }
}




void
ShowGlobals(FILE *s)
{
    fprintf(s,
"======================================================================\n\
Flag Name                            CurrentValue\n\
----------------------------------------------------------------------\n");

    fprintf(s, "  f  ConfigFile                      '%s'\n",
        config_filename);
    fprintf(s, "  t  Trace                            %s\n",
        trace_flag==1 ? "*ON*" : "*OFF*" );
    fprintf(s, "  -  Monitor                          %s\n",
        monitor_flag==1 ? "*ON*" : "*OFF*" );
    fprintf(s, "  P  Prefetch                         %s\n",
        prefetch_flag==1 ? "*ON*" : "*OFF*" );
    fprintf(s, "  p  ServicePort                     %8d \n",
        service_portno);
    fprintf(s, "  -  LocalDomain                     '%s'\n",
        localdomain_padding);
    fprintf(s, "  R  ReportHook                      '%s'\n",
        report_hook_hostname);
    fprintf(s, "  n  NumSession                      %8d \n",
        require_sess_length);
    fprintf(s, "  H  NumHandler                      %8d \n",
        require_n_handler);
    fprintf(s, "  C  SessionChunkLength              %8d \n",
        require_chunk_size);
    fprintf(s, "  U  TotalMemorySize                 %8d M (x 1048576)\n",
        require_total_memory_size/(1048576));
    fprintf(s, "  -  NumLargeBlock                   %8d \n",
        require_num_large_block);
    fprintf(s, "  -  LargeBlockSize                  %8d M (x 1048576)\n",
        require_size_large_block/(1048576));
    fprintf(s, "  -  BlockSize                       %8d K (x 1024)\n",
        require_size_block/(1024));
    fprintf(s, "  -  MinimumLineSize                 %8d K (x 1024)\n",
        require_minimum_size_line/(1024));
    fprintf(s, "  r  NumPrefetchReferedPages         %8d \n",
        num_prefetch_referedpages);
    fprintf(s, "  i  NumPrefetchIncludedObjects      %8d \n",
        num_prefetch_includedobjs);
}

void
ShowGlobals_fd(int ofd)
{
    fdprintf(ofd,
"======================================================================\n\
Flag Name                        CurrentValue\n\
----------------------------------------------------------------------\n");

    fdprintf(ofd, "  f  ConfigFile                  '%s'\n",
        config_filename);
    fdprintf(ofd, "  t  Trace                        %s\n",
        trace_flag==1 ? "*ON*" : "*OFF*" );
    fdprintf(ofd, "  -  Monitor                      %s\n",
        monitor_flag==1 ? "*ON*" : "*OFF*" );
    fdprintf(ofd, "  P  Prefetch                     %s\n",
        prefetch_flag==1 ? "*ON*" : "*OFF*" );
    fdprintf(ofd, "  p  ServicePort                 %8d \n",
        service_portno);
    fdprintf(ofd, "  -  LocalDomain                 '%s'\n",
        localdomain_padding);
    fdprintf(ofd, "  R  ReportHook                  '%s'\n",
        report_hook_hostname);
    fdprintf(ofd, "  n  NumSession                  %8d \n",
        require_sess_length);
    fdprintf(ofd, "  H  NumHandler                  %8d \n",
        require_n_handler);
    fdprintf(ofd, "  C  SessionChunkLength          %8d \n",
        require_chunk_size);
    fdprintf(ofd, "  U  TotalMemorySize             %8d M (x 1048576)\n",
        require_total_memory_size/(1048576));
    fdprintf(ofd, "  -  NumLargeBlock               %8d \n",
        require_num_large_block);
    fdprintf(ofd, "  -  LargeBlockSize              %8d M (x 1048576)\n",
        require_size_large_block/(1048576));
    fdprintf(ofd, "  -  BlockSize                   %8d K (x 1024)\n",
        require_size_block/(1024));
    fdprintf(ofd, "  -  MinimumLineSize             %8d K (x 1024)\n",
        require_minimum_size_line/(1024));
    fdprintf(ofd, "  r  NumPrefetchReferedPages     %8d \n",
        num_prefetch_referedpages);
    fdprintf(ofd, "  i  NumPrefetchIncludedObjects  %8d \n",
        num_prefetch_includedobjs);
}

print_configration_FORM(int ofd)
{
    fdprintf(ofd,
"<form name=\"chk\" method=\"POST\" action=\"/config\">\n");

    fdprintf(ofd,
"<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n\
<tr bgcolor=\"#ffffcc\">\n\
    <th rowspan=\"2\"> name\n\
    <th colspan=\"2\"> current\n\
    <th rowspan=\"2\"> specified\n\
    <th rowspan=\"2\"> descriptions\n\
<tr bgcolor=\"#ffffcc\">\n\
    <th> value\n\
    <th> unit\n\
\n\
");

    fdprintf(ofd, "<tr><td>ConfigFile  <td colspan=\"2\"> %s <td><input name=\"ConfigFile\" value=\"%s\"> <td> path\n",
        config_filename, config_filename);
    fdprintf(ofd, "<tr><td>Trace  <td colspan=\"2\"> %s <td><input name=\"Trace\" value=\"%s\"> <td> on/off\n",
        trace_flag==1 ? "on" : "off",
        trace_flag==1 ? "on" : "off" );
    fdprintf(ofd, "<tr><td>Monitor  <td colspan=\"2\"> %s <td><input name=\"Monitor\" value=\"%s\"> <td> on/off\n",
        monitor_flag==1 ? "on" : "off",
        monitor_flag==1 ? "on" : "off" );
    fdprintf(ofd, "<tr><td>Prefetch  <td colspan=\"2\"> %s <td><input name=\"Prefetch\" value=\"%s\"> <td> on/off\n",
        prefetch_flag==1 ? "on" : "off",
        prefetch_flag==1 ? "on" : "off" );
    fdprintf(ofd, "<tr><td>ServicePort  <td align=\"right\"> %8d <td>  <td><input name=\"ServicePort\" value=\"%d\"> <td> max %d min %d\n",
        service_portno, service_portno, 32000, 1);
    fdprintf(ofd, "<tr><td>LocalDomain  <td colspan=\"2\"> %s <td><input name=\"LocalDomain\" value=\"%s\"> <td> path\n",
        localdomain_padding, localdomain_padding);
    fdprintf(ofd, "<tr><td>ReportHook  <td colspan=\"2\"> %s <td><input name=\"ReportHook\" value=\"%s\"> <td> path\n",
        report_hook_hostname, report_hook_hostname);
    fdprintf(ofd, "<tr><td>NumSession  <td align=\"right\"> %8d <td>  <td><input name=\"NumSession\" value=\"%d\"> <td> max %d min %d\n",
        require_sess_length, require_sess_length, N_SESS_MAX, 128);
    fdprintf(ofd, "<tr><td>NumHandler  <td align=\"right\"> %8d <td>  <td><input name=\"NumHandler\" value=\"%d\"> <td> max %d min %d\n",
        require_n_handler, require_n_handler, N_HANDLER_MAX, 1);
    fdprintf(ofd, "<tr><td>SessionChunkLength  <td align=\"right\"> %8d <td>  <td><input name=\"SessionChunkLength\" value=\"%d\"> <td> max %d min %d\n",
        require_chunk_size, require_chunk_size, SESS_CHUNK_SIZE, 1);
    fdprintf(ofd, "<tr><td>TotalMemorySize  <td align=\"right\"> %8d <td> M (x 1048576) <td><input name=\"TotalMemorySize\" value=\"%d\"> <td> max %d min %d\n",
        require_total_memory_size/(1048576), require_total_memory_size/(1048576), 4096, 8);
    fdprintf(ofd, "<tr><td>NumLargeBlock  <td align=\"right\"> %8d <td>  <td><input name=\"NumLargeBlock\" value=\"%d\"> <td> max %d min %d\n",
        require_num_large_block, require_num_large_block, 32, 0);
    fdprintf(ofd, "<tr><td>LargeBlockSize  <td align=\"right\"> %8d <td> M (x 1048576) <td><input name=\"LargeBlockSize\" value=\"%d\"> <td> max %d min %d\n",
        require_size_large_block/(1048576), require_size_large_block/(1048576), 32, 1);
    fdprintf(ofd, "<tr><td>BlockSize  <td align=\"right\"> %8d <td> K (x 1024) <td><input name=\"BlockSize\" value=\"%d\"> <td> max %d min %d\n",
        require_size_block/(1024), require_size_block/(1024), 10240, 128);
    fdprintf(ofd, "<tr><td>MinimumLineSize  <td align=\"right\"> %8d <td> K (x 1024) <td><input name=\"MinimumLineSize\" value=\"%d\"> <td> max %d min %d\n",
        require_minimum_size_line/(1024), require_minimum_size_line/(1024), 1024, 4);
    fdprintf(ofd, "<tr><td>NumPrefetchReferedPages  <td align=\"right\"> %8d <td>  <td><input name=\"NumPrefetchReferedPages\" value=\"%d\"> <td> max %d min %d\n",
        num_prefetch_referedpages, num_prefetch_referedpages, 64, 0);
    fdprintf(ofd, "<tr><td>NumPrefetchIncludedObjects  <td align=\"right\"> %8d <td>  <td><input name=\"NumPrefetchIncludedObjects\" value=\"%d\"> <td> max %d min %d\n",
        num_prefetch_includedobjs, num_prefetch_includedobjs, 128, 0);
    fdprintf(ofd,
"\n\
\n\
</table>\n\
\n");

    fdprintf(ofd,
"<input name=\"send\" type=\"submit\" value=\"APPLY\">\n\
<input name=\"clear\" type=\"reset\" value=\"CLEAR\">\n");


    fdprintf(ofd, "</form>\n");

	return 0;
}


void
ShowProgramStatus(FILE *outport)
{
#if 0
    fprintf(outport, "KOTETU (yet another Wcol) program-version %s, data-id %s\n",
        KOTETU_VER, KOTETU_INFO_ID);
#endif
    fprintf(outport, "KOTETU (yet another Wcol)\n");

    fflush(outport);
}

void
ShowUsage()
{
    FixGlobals();   /* check in temporary */
    ShowProgramStatus(stdout);
    ShowGlobals(stdout);
}

#if 0
int
SetProcessComment(char *comment)
{
    char line[STRING_SIZE];

    sprintf(line, "wcol : %s", comment);
    return SetProcessState(line);
}
#endif


/*
 * ReadCommandlineOption
 */
void ReadCommandlineOptions(int argc, char **argv)
{
    int flag;

    extern char *optarg;
    extern int  optind;

    while((flag = getopt(argc, argv,
        "hvf:tPp:R:n:H:C:U:r:i:")) != -1) {

        switch(flag) {
        case 'h':
            ShowUsage();
            exit(KOTETU_EXIT_NORMAL);
            break;
        case 'v':
            ShowProgramStatus(stdout);
            exit(KOTETU_EXIT_NORMAL);
            break;
        case 'f':
            strcpy(config_filename, optarg);
            ReadConfigFile(config_filename);
            break;
        case 't':
            trace_flag = 1 - trace_flag;
            break;
        case 'P':
            prefetch_flag = 1 - prefetch_flag;
            break;
        case 'p':
            service_portno = (int) atoi(optarg);
            break;
        case 'R':
            report_hook_hostname = strdup(optarg);
            break;
        case 'n':
            require_sess_length = (int) atoi(optarg);
            break;
        case 'H':
            require_n_handler = (int) atoi(optarg);
            break;
        case 'C':
            require_chunk_size = (int) atoi(optarg);
            break;
        case 'U':
            require_total_memory_size = (off_t) atoi(optarg) * 1048576;
            break;
        case 'r':
            num_prefetch_referedpages = (int) atoi(optarg);
            break;
        case 'i':
            num_prefetch_includedobjs = (int) atoi(optarg);
            break;
        }
    }
}



