/*
 * code-name 'KOTETU'
 *
 * proxy_main.c : main body for proxy server.
 *
 *      by k-chinen@is.aist-nara.ac.jp, 1999, 2000
 *
 * $Id$
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sched.h>
#include <pthread.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif
#ifdef HAVE_POLL_H
#include <poll.h>
#include <sys/poll.h>
#endif
#ifdef HAVE_SELECT_H
#include <sys/select.h>
#endif
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <strings.h>
#include <limits.h>
#include <sys/types.h>
#include <time.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <signal.h>
#include <setjmp.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/uio.h>
#include <assert.h>
#include <errno.h>

/* private headers */
#if 1
#include "wcol.h"
#endif
#if 0
#include "range.h"
#include "msg.h"
#include "url.h"
#include "base.h"
#endif
#if 0
#include "info.h"
#endif

#include "socket.h"
#include "sigs.h"
#include "sim_stat.h"
#include "misc.h"
#include "http.h"
#include "cache.h"
#include "sess.h"
#include "squeue.h"
#include "parse.h"

#include "reason.h"

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif
#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif



#ifndef MONITOR_INTERVAL
#define MONITOR_INTERVAL    (600)
#endif


pthread_mutex_t stat_lock = PTHREAD_MUTEX_INITIALIZER;
time_t boot_date = 0;
time_t service_start_date = 0;
int    session_queue_report_flag = 0;

volatile long long request_sirial_count = 0;
volatile int receive_request_count = 0;
volatile int process_request_count = 0;
volatile int issue_prefetch_count  = 0;
volatile int report_request_count  = 0;
volatile int reject_request_count  = 0;
volatile int ignore_request_count  = 0;

volatile int send_reply_count    = 0;
volatile int hit_reply_count     = 0;
volatile int miss_reply_count    = 0;
volatile int error_reply_count   = 0;

volatile int hash_colision       = 0;
volatile int cache_compaction   = 0;

int read_reply_total   = 0;
int read_reply_success = 0;
int read_reply_fail    = 0;

int cache_newover_count = 0;
int cache_newfree_count = 0;
int cache_newmin_count = 0;



volatile off_t intra_incoming = (off_t)0; /* requests from clients */
volatile off_t extra_outgoing = (off_t)0; /* requests to super class servers */
volatile off_t extra_incoming = (off_t)0; /* replys from super class servers */
volatile off_t intra_outgoing = (off_t)0; /* replys to clients */



sim_rec rcode_stat;
long    rcode_stat_count[1000];

sim_rec len_perread_stat;
static long server_buffer_stat_count[K(32)];

sim_rec object_size_stat;
static long object_size_stat_count[K(1)];

sim_rec url_first_hash_stat;
static long url_first_hash_stat_count[K(2)];
sim_rec url_second_hash_stat;
static long url_second_hash_stat_count[K(2)];

sim_rec object_alloc_stat;
static long object_alloc_stat_count[K(10)];


pthread_t th_listener;
pthread_mutex_t accept_lock = PTHREAD_MUTEX_INITIALIZER;

pthread_t th_handlers[N_HANDLER_MAX];
pthread_t th_monitor;

pthread_t th_signalhandler;

sigset_t handler_sig_mask;

int require_sess_length;

int think_queue_length;
sess_queue_t X_think_queue;
sess_queue_t *think_queue;
#if 0
sess_queue_t X_send_queue;
sess_queue_t *send_queue;
sess_queue_t X_fetch_queue;
sess_queue_t *fetch_queue;

sess_queue_t X_prompt_queue;
sess_queue_t *prompt_queue;
#endif


/*
 * externals
 */
extern unsigned char *_htrie_slot;

extern int nhot;


#if 0
#define push_sess(q,c) sq_timedpush(q,c,100000) /* 100 msec */
#else
#define push_sess(q,c) sq_push(q,c)
#endif
#define pull_sess(q) sq_pull(q)
#define pull_sess_nonblock(q) sq_pull_nonblock(q)

int InitSession(int);


/* automatic */
pthread_mutex_t config_lock = PTHREAD_MUTEX_INITIALIZER;

char config_filename[L_URL];
int trace_flag;
int monitor_flag;
int prefetch_flag=1;
int service_portno;
int require_n_handler;
int require_chunk_size;
off_t require_total_memory_size;
int require_num_large_block;
int require_size_large_block;
int require_size_block;
int require_minimum_size_line;
int num_prefetch_referedpages;
int num_prefetch_includedobjs;

int max_line_per_obj = MAX_LINE_PER_OBJ;
int max_line_per_write = MAX_LINE_PER_WRITE;

/*
char report_hook_hostname[] ="www.self-report.cache";
*/
char *localdomain_padding;
char *report_hook_hostname;

/* static */
pid_t    wcol_pid;
char     *progname;

unsigned char *htrie_shadow_top;

extern off_t sess_memory_size;
off_t cache_memory_size;



inline
static
int
release_slave_lines(line_rec *hlpos)
{
    register line_rec *clpos, *nlpos;

    if(hlpos==NULL) {
        return -1;
    }
    if(hlpos->cntl.next==NULL) {
        return -2;
    }

    clpos = (line_rec*) (hlpos->cntl.next);
    hlpos->cntl.next = NULL;
    while(clpos) {
        nlpos = (line_rec*) (clpos->cntl.next);

        clpos->cntl.type        = TYPE_EMPTY_LINE;
        clpos->cntl.count       = 0;
        clpos->cntl.totallength = -1;
        clpos->cntl.length      = -1;
        clpos->cntl.next        = NULL;

        clpos = nlpos;
    }

    return 0;
}


/*
 * return
 *      fail        0
 *      success     >0  (the number of lines)
 *      error       -1
 *
 */

int
alloc_buf(sess_t *this, block_cntl_rec *bcr,
        line_rec **r_hlpos, line_rec **r_tlpos, line_rec **r_nlpos,
        struct iovec *iov, int ciov)
{
    int use_tmpbuf;

    char *lcrp;
    line_cntl_rec *lcr;
    line_rec *hlpos;            /* head */
    line_rec *tlpos;            /* tail */
    line_rec *clpos;            /* current */
    line_rec *xlpos;            /* temporary */
    line_rec *lpos_edge;
    line_rec *over_pos, *empty_pos, *min_pos;
    int min_val;
    int l;
    int ll;
    int ln_sum;
    int sz_sum;
    int try;
    int chk;
    int ret;
    int c_comp;
    int gc_chg;

    int try_compaction;

    int giveup;

    struct timeval reftime;


    if(bcr==NULL) {
        return -1;
    }


    try = 0;
    try_compaction = 0;
    gettimeofday(&reftime, NULL);

    gc_chg = -1;
    ret = 0;

#ifdef TRACE_CACHE
    Trace("alloc_buf: th# %x, sess# %d, hash %d:%d\n",
        pthread_self(), this->sid, this->fhash, this->shash);
#endif

restart:
    try++;

#ifdef TRACE_CACHE
    cache_showblockaddr(this->fhash, 0);
#endif

 assert(_htrie_slot==htrie_shadow_top);

    /***
     *** alloc buffer
     ***/
    use_tmpbuf = 0;
    giveup = 0;

    over_pos = NULL;
    empty_pos = NULL;
    min_pos = NULL;
    min_val = INT_MAX;

    hlpos = NULL;
    tlpos = NULL;
    *r_hlpos = NULL;

    /*
     * scan same object line, minimum frequently line, empty line
     */
    lcrp = (char*) bcr + linesize;
    lpos_edge = (line_rec*)( (char*) bcr + linesize*(nline-1) );
    for(l=1;l<nline;l++) {
        lcr = (line_cntl_rec*) lcrp;

        if(lcr->type==TYPE_NORMAL_LINE
                && lcr->lhash==this->shash
                && strcmp((const char*)lcr->name, (const char*)this->loc)
                    ==0) {

            over_pos = (line_rec*)lcr;

            hlpos = tlpos = over_pos;
            sz_sum = hlpos->cntl.length;
            ln_sum = 1;
            xlpos = (line_rec*)(over_pos->cntl.next);
            while(xlpos) {
                sz_sum += xlpos->cntl.length;
                ln_sum++;
                tlpos = xlpos;
                xlpos = (line_rec*)(xlpos->cntl.next);
            }

#ifdef TRACE_CACHE
            Trace("  head %p, tail %p (%d lines) // size %d\n",
                hlpos, tlpos, ln_sum, sz_sum);
#endif
            if(hlpos->cntl.totallength>=0
                && hlpos->cntl.totallength!=sz_sum) {
#ifdef TRACE_CACHE
                Trace("recorded length <%d> is ignore. actual length is %d\n",
                    hlpos->cntl.totallength, sz_sum);
#endif

                hlpos->cntl.cracked = 1;
                release_slave_lines(hlpos);
                /*
                hlpos->cntl.next = NULL;
                */
#ifdef TRACE_CACHE
                Trace("slaves are released (cracked object)\n");
                cache_showblockaddr(this->fhash, 0);
#endif

                giveup = 1;


            }

            break;
        }

        if(lcr->type==TYPE_NORMAL_LINE
                && lcr->hot==0 && lcr->count<=min_val) {
            min_val = lcr->count;
            min_pos = (line_rec*)lcr;
        }

        if(empty_pos==NULL
                && lcr->type==TYPE_EMPTY_LINE) {
            empty_pos = (line_rec*)lcr;
        }

        lcrp += linesize;
    }
#ifdef TRACE_CACHE
    Trace("over_pos %p, empty_pos %p, min_pos %p\n",
        over_pos, empty_pos, min_pos);
#endif

    if(giveup) {
#ifdef TRACE_CACHE
        Trace("the line is cracked, meybe. use temprary buffer\n");
#endif
        goto alloc_tmpbuf;
    }

    /* found same object area. over write or append */
    if(over_pos) {
#ifdef TRACE_CACHE
        /*
        Trace("sess# %d, block# %d, over_pos %p [%p..%p] edge %p\n",
            this->sid, this->fhash, over_pos, hlpos, tlpos, lpos_edge);
        Trace("found same object: head %p, tail %p (%d lines), size %d\n",
            hlpos, tlpos, ln_sum, sz_sum);
        */
        Trace("sess# %d, block# %d, over_pos %p [%p..%p], %d lines, size %d\n",
            this->sid, this->fhash, over_pos, hlpos, tlpos,
            ln_sum, sz_sum);
#endif

        if(hlpos->cntl.owner != this->sid) {
#if 0
            Trace("touch otherone's line. sess# %d, owner %d\n",
                this->sid, hlpos->cntl.owner);
#endif
        }
        else {
            if(hlpos->cntl.oid != this->sid) {
                MUTEX_LOCK(&stat_lock);
                cache_newover_count++;
                MUTEX_UNLOCK(&stat_lock);

                hlpos->cntl.oid = this->sid;
                hlpos->cntl.count = 1;
            }
        }

        hlpos->cntl.hot      = reftime.tv_sec;


        if(hlpos->cntl.cracked) {
#if 0
            Trace("the line is cracked. use temprary buffer\n");
#endif
            giveup = 1;

            goto alloc_tmpbuf;
        }



        if(tlpos->cntl.size - tlpos->cntl.length < TYPICAL_MTU) {
            clpos = NULL;
#ifdef TRACE_CACHE
            Trace("  next reading will be large this line\n");
#endif

            if(ln_sum < max_line_per_obj) {
                /* seek empty line */
                if(!empty_pos) {
#ifdef TRACE_CACHE
                    Trace("  seek empty line once more\n");
#endif
                    xlpos = (line_rec*)((char*) tlpos + linesize);
                    while(xlpos<=lpos_edge) {
                        if(xlpos->cntl.type==TYPE_EMPTY_LINE) {
                            empty_pos = (line_rec*)xlpos;
                            break;
                        }
                        xlpos = (line_rec*)((char*) xlpos + linesize);
                    }
                }

                if(empty_pos) {
#ifdef TRACE_CACHE
Trace("next line is not empty. but empty line was found %p\n", empty_pos);
#endif
                    /*
                    ((line_rec*)tlpos->cntl.next) = empty_pos;
                    */
                    tlpos->cntl.next = (struct _line_cntl_rec *) empty_pos;
                    clpos = empty_pos;
                }
                else {
#ifdef TRACE_CACHE
Trace("next line is not empty. in addtion, empty line was not found\n");
#endif
                }

            }
            else {
#ifdef TRACE_CACHE
Trace("it is very long object. give up\n");
#endif
            }

            if(clpos) {
                clpos->cntl.type    = TYPE_SLAVE_LINE;
                clpos->cntl.oid     = this->sid;
                clpos->cntl.hot     = reftime.tv_sec;
                clpos->cntl.totallength  = -1;
                clpos->cntl.length  = 0;
                clpos->cntl.next    = NULL;

                /* iov[] stores 2 buffer */
                /* if faster is full, skip faster and use later */
                if(tlpos->cntl.size - tlpos->cntl.length == 0) {
                    tlpos = clpos;

                    ret = 1;
                    iov[0].iov_base = (char*)&clpos->body;
                    iov[0].iov_len  = clpos->cntl.size;
#ifdef TRACE_CACHE
Trace("iov[0] %p %d\n", iov[0].iov_base, iov[0].iov_len);
#endif
                }
                /* use rest of faster and later */
                else {
                    ret = 2;
                    iov[0].iov_base = (char*)&tlpos->body + tlpos->cntl.length;
                    iov[0].iov_len  = tlpos->cntl.size - tlpos->cntl.length;
                    iov[1].iov_base = (char*)&clpos->body;
                    iov[1].iov_len  = clpos->cntl.size;
#ifdef TRACE_CACHE
Trace("iov[0] %p %d\n", iov[0].iov_base, iov[0].iov_len);
Trace("iov[1] %p %d\n", iov[1].iov_base, iov[1].iov_len);
#endif
                }
            }
            else {
                if(try<2) {
                    goto compaction_start;
                }

                /*
                 * give up to store cache area
                 */
                hlpos->cntl.cracked = 1;
                release_slave_lines(hlpos);
#ifdef TRACE_CACHE
                Trace("slaves are released (larger object)\n");
                cache_showblockaddr(this->fhash, 0);
#endif

                tlpos = hlpos;

                goto alloc_tmpbuf;
            }
        }
        else {
#ifdef TRACE_CACHE
            Trace("  this line is enough to store next reading\n");
#endif

            ret = 1;
            iov[0].iov_base = (char*)&tlpos->body + tlpos->cntl.length;
            iov[0].iov_len  = tlpos->cntl.size - tlpos->cntl.length;
        }
    }
    else
    if(empty_pos) {
#ifdef TRACE_CACHE
        Trace("sess# %d, fhash %d, empty_pos %p\n",
                this->sid, this->fhash, empty_pos);
#endif
        this->oid = this->sid;
        hlpos = empty_pos;
        tlpos = hlpos;

        hlpos->cntl.type     = TYPE_NORMAL_LINE;
        hlpos->cntl.oid      = this->sid;
        strcpy((char*)hlpos->cntl.name, this->loc);
        hlpos->cntl.lhash    = this->shash;
        hlpos->cntl.count    = 1;
        hlpos->cntl.cracked  = 0;
        hlpos->cntl.hot      = reftime.tv_sec;
        hlpos->cntl.totallength = -1;
        hlpos->cntl.length   = 0;
        hlpos->cntl.owner    = this->sid;
        hlpos->cntl.next     = NULL;

        ret = 1;
        iov[0].iov_base = (char*)&hlpos->body;
        iov[0].iov_len  = hlpos->cntl.size;


        MUTEX_LOCK(&stat_lock);
        cache_newfree_count++;
        MUTEX_UNLOCK(&stat_lock);
    }
    else
    if(min_pos) {
#ifdef TRACE_CACHE
        Trace("sess# %d, fhash %d, min_pos %p\n",
                this->sid, this->fhash, min_pos);
#endif
        this->oid = this->sid;
        hlpos = min_pos;
        tlpos = hlpos;
#if 0
        xlpos = hlpos->cntl.next;
#endif

        hlpos->cntl.type      = TYPE_NORMAL_LINE;
        hlpos->cntl.oid       = this->sid;
        strcpy((char*)hlpos->cntl.name, this->loc);
        hlpos->cntl.lhash     = this->shash;
        hlpos->cntl.count     = 1;
        hlpos->cntl.cracked  = 0;
        hlpos->cntl.hot       = reftime.tv_sec;
        hlpos->cntl.totallength = -1;
        hlpos->cntl.length    = 0;
        hlpos->cntl.owner     = this->sid;
        /* release slaves */
        release_slave_lines(hlpos);
        /*
        hlpos->cntl.next     = NULL;
        */
#ifdef TRACE_CACHE
        Trace("slaves are released (minimum freqency)\n");
        cache_showblockaddr(this->fhash, 0);
#endif

        ret = 1;
        iov[0].iov_base = (char*)&hlpos->body;
        iov[0].iov_len  = hlpos->cntl.size;

        MUTEX_LOCK(&stat_lock);
        cache_newmin_count++;
        MUTEX_UNLOCK(&stat_lock);
    }
    else {
#ifdef TRACE_CACHE
        Error("no slot for over write, free or minimum [%d:%d]",
            this->fhash, this->shash);
#endif
        goto compaction_start;
    }

    if(ret) {
#ifdef TRACE_CACHE
        Trace("alloc to object cache area to %p\n", hlpos);
#endif

        goto alloc_done;
    }
#if 1
    else {
        goto alloc_tmpbuf;
    }
#endif
    /* following down compaction */



    /***
     *** Compaction
     ***/


compaction_start:
        try_compaction++;

        /*
         * cache compaction
         */
        MUTEX_LOCK(&stat_lock);
        c_comp = cache_compaction++;
        MUTEX_UNLOCK(&stat_lock);

 assert(_htrie_slot==htrie_shadow_top);

        clpos = (line_rec*) ((char*) bcr + linesize);
        gc_chg = 0;

#ifdef TRACE_CACHE
        Trace("              @@@@@ compaction (aka garbage collection)\n");
        Trace("compaction# %d, try %d+%d [%p..%p]\n",
            c_comp, try, try_compaction, clpos, lpos_edge);
#endif
#if 0
        cache_showblock(this->fhash, 0);
#endif
        while(clpos<=lpos_edge) {
#if 0
            if(clpos->cntl.type==TYPE_SLAVE_LINE) {
                clpos->cntl.type        = TYPE_EMPTY_LINE;
                clpos->cntl.totallength = -1;
                clpos->cntl.length      = -1;
                gc_chg++;
            }
            else
#endif
            if(clpos->cntl.type==TYPE_NORMAL_LINE
              && (clpos->cntl.oid != this->sid)
              && ((clpos->cntl.cracked
                        && reftime.tv_sec - clpos->cntl.hot > 10)
                    || (reftime.tv_sec - clpos->cntl.hot > 3600 ) ) ) {
#if 0
Trace("Compaction: remove sess# %d [%d:%d]\n",
    this->sid, this->fhash, this->shash);
#endif
#if 0
Trace("Compaction: remove oid# %d [%d:%d]\n",
    clpos->cntl.oid, this->fhash, clpos->cntl.lhash);
#endif

                clpos->cntl.type        = TYPE_EMPTY_LINE;
                clpos->cntl.totallength = -1;
                clpos->cntl.length      = -1;
                clpos->cntl.count       =  0;
                /* release slaves */
                release_slave_lines(clpos);
                /*
                clpos->cntl.next        = NULL;
                */

                gc_chg++;

            }

            clpos = (line_rec*)((char*) clpos + linesize);
        }


 assert(_htrie_slot==htrie_shadow_top);

#ifdef TRACE_CACHE
        Trace("change %3d\n", gc_chg);
        cache_showblockaddr(this->fhash, 0);
        Trace("allocation restart !!!\n");
#endif

#if 1
        if(gc_chg==0) {
            goto alloc_tmpbuf;
        }
#endif

        goto restart;



alloc_tmpbuf:
    use_tmpbuf = 1;
    return 0;

fail:
    return -1;

alloc_done:
#if 0
    cache_showblock(this->fhash, 0);
#endif
    goto out;

out:

#ifdef TRACE_CACHE
Trace("===>%d\n", ret);
#endif

    *r_hlpos = hlpos;
    *r_tlpos = tlpos;
    *r_nlpos = clpos;

    return ret;
}

int
release_buf(sess_t *this)
{
    int ret;
    int chk;

    block_cntl_rec *bcr;
    line_rec *hlpos;

 assert(_htrie_slot==htrie_shadow_top);

#ifdef TRACE_CACHE
    Trace("release_buf: sess# %d, '%s' [%d:%d] %s\n",
        this->sid, this->loc, this->fhash, this->shash,
        MSG_STATE_[this->state]);

#if 0
    cache_showblockaddr(this->fhash, 0);
#endif

#endif

    bcr = (block_cntl_rec*) cache_block_pos(this->fhash);
    if(bcr==NULL) {
        Error("; block position is not resolved");
        goto out;
    }

    chk = MUTEX_LOCK(&bcr->mutex);

    hlpos = (line_rec*)cache_find_line(this->fhash, this->shash, this->loc);

    if(hlpos==NULL) {
#ifdef TRACE_CACHE
        Trace("sess# %d, not found in cache. no problem.\n", this->sid);
#endif
        ret = -1;
    }
    else
    if(hlpos->cntl.owner==this->sid) {
#ifdef TRACE_CACHE
        Trace("sess# %d, line is mine. clear this owenership.\n", this->sid);
#endif
        hlpos->cntl.owner = 0;

        ret = 0;
    }

    if(bcr) {
        chk = MUTEX_UNLOCK(&bcr->mutex);
        bcr = NULL;
    }
out:

    return ret;
}

int
DoAccept(int listen_fd)
{
    struct sockaddr_in from;
    int len;
    int tmpfd;

 assert(_htrie_slot==htrie_shadow_top);

    len = sizeof(from);

    MUTEX_LOCK(&accept_lock);
    tmpfd = accept(listen_fd, (struct sockaddr*)&from, &len);
    MUTEX_UNLOCK(&accept_lock);

    if(tmpfd<0) {
        Trace("accept error (%d)\n", errno);
        tmpfd = -1;
        goto done;
    }

    MUTEX_LOCK(&stat_lock);
    receive_request_count++;
    request_sirial_count++;
    MUTEX_UNLOCK(&stat_lock);

done:

    return tmpfd;
}

#if 0
int
HTTP_parse_version(char *vstr, int *ma, int *mi)
{
    register char *p, *q;
    int c;
    char tmp[L_URL];

    if(vstr==NULL || *vstr=='\0') {
        return -1;
    }
#if 0
Trace("HTTP_parse_version: vstr '%s'\n", vstr);
#endif

    p = vstr;
    if(*p!='H') goto fail;
    p++;
    if(*p!='T') goto fail;
    p++;
    if(*p!='T') goto fail;
    p++;
    if(*p!='P') goto fail;
    p++;
    if(*p!='/') goto fail;
    p++;

    q = tmp;
    c = 0;
    while(c<L_URL && *p>='0' && *p<='9') {
        *q++ = *p++;
        c++;
    }
    *ma = atoi(tmp);

    if(*p!='.') {
        goto fail;
    }

    p++;

    q = tmp;
    c = 0;
    while(c<L_URL && *p>='0' && *p<='9') {
        *q++ = *p++;
        c++;
    }
    *mi = atoi(tmp);

done:
#if 0
Trace("  got <%d.%d>\n", *ma, *mi);
#endif

    return *ma;

fail:
Trace("HTTP_parse_version: vstr '%s' -> <%d.%d>\n", vstr, *ma, *mi);
    *ma = -1;
    *mi = -1;
    return -1;
}
#endif

int
DoReadReq(sess_t *this)
{
    int nread;
    int c;
    int method;
    char url[L_URL];
    char version[L_URL];
    void *cpos;
    int chk;
    int err;
    int cachable;
    int reload;
    int ims;

#if 0
    Trace("DoReadReq : sess# %d, cfd %d\n", this->sid, this->cfd);
#endif
 assert(_htrie_slot==htrie_shadow_top);

/*
    this->reqlen = 0;
*/
#if 0
dump_stringsegment("before", this->reqbuf, this->reqlen);
#endif

try_read:
    nread = read(this->cfd,
                &this->reqbuf[this->reqlen], L_REQBUF-this->reqlen);
    err = errno;
    if(nread<0) {
        if(err==EINTR) {
            goto try_read;
        }
        Error("sess# %d, read() fail (%d)", this->sid, err);
        DoHalfClientCloseSess(this);
#if 0
        this->state = STATE_CLOSE;
#endif
        this->reason = R_FAIL_CLIENT_READ;
        this->state = STATE_MESSAGE;

        MUTEX_LOCK(&stat_lock);
        ignore_request_count++;
        MUTEX_UNLOCK(&stat_lock);

        return -1;
    }
    if(nread==0) {
        Error("sess# %d, read() empty", this->sid);
#if 0
        Error("sess# %d, th %x, fd# %d, empty client request (%d)",
            this->sid, pthread_self(), this->cfd, err);
#endif
        DoHalfClientCloseSess(this);
#if 0
        this->state = STATE_CLOSE;
#endif
        this->reason = R_FAIL_CLIENT_READ_EMPTY;
        this->state = STATE_MESSAGE;

        MUTEX_LOCK(&stat_lock);
        ignore_request_count++;
        MUTEX_UNLOCK(&stat_lock);

        return -1;
    }

    MUTEX_LOCK(&stat_lock);
    extra_incoming += (off_t) nread;
    MUTEX_UNLOCK(&stat_lock);


    this->reqlen += nread;
    this->loc[0] = '\0';
    this->last_action = time(NULL);

#if 0
dump_stringsegment("o.req.", this->reqbuf, this->reqlen);
#endif

    c = HTTP_find_header_term(this->reqbuf, this->reqlen);

#if 0
Trace("DoReadReq: sess %p, read %d, header term %d\n", this->sid, nread, c);
#endif

    if(c>=0) {
#if 0
        dump_stringsegment("request", this->reqbuf, this->reqlen);
#endif

#if 0
 Trace(" 1 sfd# %d, cfd# %d\n", this->sfd, this->cfd);
#endif

        version[0] = '\0';
        cachable = 1;
        reload  = 0;
        ims = -1;

        c = HTTP_parse_request_header(this->reqbuf,
                &method, url, version,
                &ims, &cachable, &reload);

        if(c) {
            Error("ignore request from fd #%d", this->cfd);
#if 1
            dump_stringsegment("request", this->reqbuf, this->reqlen);
#endif

            if(c==-2) {
                this->reason = R_TOOLONG_URL;
            }
            else {
                this->reason = R_IGNORE_URL;
            }

            this->state = STATE_MESSAGE;
            return -1;
        }

        chk = -1;
        if(version[0]) {
            chk =
             HTTP_parse_version(version, &this->cver_major, &this->cver_minor);
        }
        if(chk<0) {
            this->cver_major = 0;
            this->cver_minor = 9;
        }
/*
Trace("sess# %d, client HTTP ver %d.%d\n",
    this->sid, this->cver_major, this->cver_minor);
*/

#ifdef TRACE_SESS
        Trace("sess# %d, <client> method <%s>,URL '%s' version <%s>\n",
            this->sid, MSG_M_[method], url, version);
#endif

        this->method = method;

        strcpy(this->loc, url);
        this->fhash = first_hash(url);
        this->shash = second_hash(url);

#if 0
        sim_stat_add_value(&url_first_hash_stat,  this->fhash);
        sim_stat_add_value(&url_second_hash_stat, this->shash);
#endif

/*****
 ***** check cachable or not
 *****/

        if(istempURL(url)) {
            cachable = 0;
            reload = 1;
            this->cachable  = SESS_UNCACHABLE;
            this->reload    = SESS_RELOAD;
        }
        else {
            if(cachable) {
                this->cachable = SESS_CACHABLE;
            }
            else {
                this->cachable = SESS_UNCACHABLE;
            }
            if(reload) {
                this->reload = SESS_RELOAD;
            }
            else {
                this->reload = SESS_NORELOAD;
            }
        }

#if 0
        if(!cachable||reload) {
            dump_stringsegment("p.req", this->reqbuf, this->reqlen);
        }
#endif


        if(ims>0) {
            this->ims = ims;
        }

#if 0
Trace("sess# %d, ver HTTP/%d.%d, %c%c, ims %d\n",
        this->sid,
        this->cver_major, this->cver_minor,
        (this->cachable==SESS_CACHABLE ? 'c' : 'N'),
        (this->reload==SESS_RELOAD ? 'R' : '-'),
        this->ims);
#endif

#if 0
 Trace(" 3 sfd# %d, cfd# %d\n", this->sfd, this->cfd);
#endif


done_cachable_check:
#if 0
 Trace(" 4 sfd# %d, cfd# %d\n", this->sfd, this->cfd);
#endif

        this->state = STATE_THINK;
    }
    else {
        Error("DoReadReq: HTTP_find_header_term() returns %d", c);
#if 1
        dump_stringsegment("e.req", this->reqbuf, this->reqlen);
#endif
    }
#if 0
 Trace(" 5 sfd# %d, cfd# %d\n", this->sfd, this->cfd);
#endif

    return 0;
}


int
DoSetReq(sess_t *this, char *aurl)
{
    int nread;
    int c;
    int method;
    char url[L_URL], version[L_URL];
    char protocol[L_URL], portstr[L_URL];
    void *cpos;
    int istmp;


#if 0
    Trace("DoSetReq : cfd %d\n", this->cfd);
#endif
 assert(_htrie_slot==htrie_shadow_top);

    this->reqlen = sprintf(this->reqbuf,
            "GET %s HTTP/1.0\r\nAccept: */*\r\n\r\n", aurl);

    this->loc[0] = '\0';

    this->last_action = time(NULL);


    c = HTTP_parse_simple_request(this->reqbuf, &method, url, version);
    if(c) {
        Error("ignore request from fd #%d", this->cfd);
#if 1
        dump_stringsegment("request", this->reqbuf, this->reqlen);
#endif

        this->reason = R_IGNORE_URL;
        this->state = STATE_MESSAGE;
        return -1;
    }

#if 0
    Trace("receive request\n");
    Trace("  method  <%s>\n  URL     <%s>\n  version <%s>\n",
        method, url, version);
#endif

    this->method = method;

    strcpy(this->loc, url);
    this->fhash = first_hash(url);
    this->shash = second_hash(url);

#if 0
    sim_stat_add_value(&url_first_hash_stat,  this->fhash);
    sim_stat_add_value(&url_second_hash_stat, this->shash);
#endif

    this->state = STATE_THINK;

    return 0;
}





int
DoReadReqFirst(sess_t *this)
{
    int ret;
    int b_state;

 assert(_htrie_slot==htrie_shadow_top);

    b_state = this->state;
    this->state = STATE_RECV_REQ;
    ret = DoReadReq(this);
#if 0
    Trace("DoReadReqFirst: sess# %d, %s -> %s , ret %d\n",
        this->sid, MSG_STATE_[b_state], MSG_STATE_[this->state], ret);
#endif

    return ret;
}


int
DoReadReqRest(sess_t *this)
{
    int ret;
    int b_state;

 assert(_htrie_slot==htrie_shadow_top);

    b_state = this->state;
    ret = DoReadReq(this);
#if 0
    Trace("DoReadReqRest: sess# %d, %s -> %s , ret %d\n",
        this->sid, MSG_STATE_[b_state], MSG_STATE_[this->state], ret);
#endif

    return ret;
}

int
HostnameNormalize(char *src)
{
    register char *p;
    register int c;
    int d;

    p = src;
    c = 0;
    while(*p) {
        c++;
        if(*p=='.') {
            goto have_dot;
        }
        p++;
    }

not_have_dot:

    MUTEX_LOCK(&config_lock);
    if(c+strlen(localdomain_padding)+1<L_HOST) {
        strcat(p, localdomain_padding);
    }
    MUTEX_UNLOCK(&config_lock);

    return 0;

have_dot:
    return 0;
}

int
DoThink(sess_t *this)
{
    int ihave;
    int chk;
    char protocol[L_URL], portstr[L_URL];

    block_cntl_rec *bcr;
    line_rec *hlpos, *tlpos, *nlpos;
    struct iovec iovec[2];
    int ciovec;
    int blen;
    struct timeval xbefore, xafter;

 assert(_htrie_slot==htrie_shadow_top);

    chk = ParseURL(this->loc, protocol,
            this->servername, portstr, this->serverpath);
    if(portstr[0]=='\0') {
        this->serverport = 80;
    }
    else {
        this->serverport = atoi(portstr);
    }
    chk = HostnameNormalize(this->servername);

#if 0
    Trace("DoThink: '%s' [%d:%d] '%s' %s %s\n",
        this->loc, this->fhash, this->shash, this->loc,
        this->cachable==SESS_CACHABLE ? "cachable" : "no-cachable",
        this->reload==SESS_RELOAD ? "reload" : "not-reload");
#endif

    /* this system permit only GET and POST method */
    if(! (this->method == M_GET || this->method == M_POST) ) {
        Trace("ignore method, sess %p (#%d)\n", this, this->sid);

        MUTEX_LOCK(&stat_lock);
        ignore_request_count++;
        MUTEX_UNLOCK(&stat_lock);

        this->reason = R_UNSUPPORT_METHOD;
        this->state = STATE_MESSAGE;
        return 0;
    }

#if 1
    if(strncasecmp(this->loc, "http:", 5)!=0) {
        this->reason = R_UNSUPPORT_PROTOCOL;
        this->state = STATE_MESSAGE;
        return 0;
    }
#endif

#if 0
    if(strcmp(this->servername, "@self")==0)
#endif
#if 0
    if(strcmp(this->servername, "www.self-report.cache")==0)
#endif
    if(strcmp(this->servername, report_hook_hostname)==0)
    {
#if 0
        Trace("report request. sess# %d %p\n", this->sid, this);
#endif

        MUTEX_LOCK(&stat_lock);
        report_request_count++;
        MUTEX_UNLOCK(&stat_lock);

        this->state = STATE_REPORT;
        this->cachable = SESS_UNCACHABLE;
        this->reload   = SESS_RELOAD;
        return 0;
    }


    sim_stat_add_value(&url_first_hash_stat,  this->fhash);
    sim_stat_add_value(&url_second_hash_stat, this->shash);

    switch(this->method) {
    /* GET method */
    case M_GET:
        if(this->reload!=SESS_RELOAD && this->cachable==SESS_CACHABLE) {

            bcr = (block_cntl_rec*) cache_block_pos(this->fhash);
            if(bcr==NULL) {
                Error("; block position is not resolved");
                return -1;
            }

            chk = MUTEX_LOCK(&bcr->mutex);

#if 0
    cache_showblockaddr(this->fhash, 0);
#endif

/*
    Trace("DoThink: call cache_have()\n");
*/

            ciovec = 2;
            iovec[0].iov_base = NULL;
            iovec[0].iov_len = -1;
            iovec[1].iov_base = NULL;
            iovec[1].iov_len = -1;

            gettimeofday(&xbefore, NULL);
            blen = alloc_buf(this, bcr, &hlpos, &tlpos, &nlpos, iovec, ciovec);
            gettimeofday(&xafter, NULL);
            sim_stat_add_value(&object_alloc_stat,
                KOTETU_SUB_TIME(xafter, xbefore));

#if 0
Trace("DoThink: sess# %d, blen %d\n", this->sid, blen);
Trace("  hlpos %p, tlpos %p, nlpos %p\n", hlpos, tlpos, nlpos);
Trace("  iovec %p, ciovec %d\n", iovec, ciovec);
#endif

            if(blen<0) {
#if 0
    cache_showblockaddr(this->fhash, 0);
#endif
                this->reason = R_LOST_BLOCK;
                this->state = STATE_MESSAGE;
            }
            else
            if(blen==0 || tlpos==NULL) {
#if 0
                Trace("sess# %d, ignore, cracked? [%d:%d]\n",
                this->sid, this->fhash, this->shash);
#endif
#ifdef TRACE_CACHE
#endif
                MUTEX_LOCK(&stat_lock);
                miss_reply_count++;
                MUTEX_UNLOCK(&stat_lock);

                this->state = STATE_QUERY_ADDR;

            }
            else {
#ifdef TRACE_SESS
Trace("DoThink: sess# %d, owner %d\n", this->sid, hlpos->cntl.owner);
#endif
#if 0
    cache_showblockaddr(this->fhash, 0);
#endif
                if(hlpos) {
                    this->count = hlpos->cntl.count;
                }

                if(hlpos->cntl.owner==this->sid) {
#ifdef TRACE_SESS
                    Trace("sess# %d, cachable, not have [%d:%d]\n",
                        this->sid, this->fhash, this->shash);
#endif
                    MUTEX_LOCK(&stat_lock);
                    miss_reply_count++;
                    MUTEX_UNLOCK(&stat_lock);

                    this->state = STATE_QUERY_ADDR;
                }
                else {
                    if(hlpos->cntl.cracked) {
                        /* cracked object
                         * don't warry other session
                         */
#ifdef TRACE_SESS
                        Trace("sess# %d, cachable, have and cracked [%d:%d]\n",
                            this->sid, this->fhash, this->shash);
#endif
                        MUTEX_LOCK(&stat_lock);
                        miss_reply_count++;
                        MUTEX_UNLOCK(&stat_lock);

                        this->state = STATE_QUERY_ADDR;
                    }
                    else
                    if(hlpos->cntl.owner==0) {
                        /* the object is not included other sessions
                         * this session can use the object
                         */
#ifdef TRACE_SESS
                        Trace("sess# %d, cachable, have [%d:%d], cold\n",
                            this->sid, this->fhash, this->shash);
#endif
#if 0
    cache_showblockaddr(this->fhash, 1);
#endif
#if 1
                        if(hlpos->cntl.expire>0) {
                        Trace("sess# %d, expire %d, now %d\n",
                            this->sid, hlpos->cntl.expire, xafter.tv_sec);
                        }
#endif
                        if(hlpos->cntl.expire>0 &&
                            xafter.tv_sec > hlpos->cntl.expire) {

                        MUTEX_LOCK(&stat_lock);
                        miss_reply_count++;
                        MUTEX_UNLOCK(&stat_lock);

                        this->state = STATE_QUERY_ADDR;

                        }
                        else {

                        MUTEX_LOCK(&stat_lock);
                        hit_reply_count++;
                        MUTEX_UNLOCK(&stat_lock);

                        this->state = STATE_SEND_CACHE;
                        }
                    }
                    else {
                        /* the object is included another session
                         * this session have to wait complete of that
                         */
#ifdef TRACE_SESS
                        Trace("sess# %d, cachable, have [%d:%d], hot\n",
                            this->sid, this->fhash, this->shash);
#endif
                        /* not hit and not miss */

                        this->state = STATE_WAIT_FRIEND;
                        this->reason2 = hlpos->cntl.owner;
#if 0
                        if(this->mode==MODE_CLIENT) {
                        Trace("sess# %d, to waiting owner %d, client\n",
                            this->sid, hlpos->cntl.owner);
                        }
                        else {
                        Trace("sess# %d, to waiting owner %d, self\n",
                            this->sid, hlpos->cntl.owner);
                        }
#endif
                    }
                }
            }


            if(bcr) {
                chk = MUTEX_UNLOCK(&bcr->mutex);
                bcr = NULL;
            }

        }
        else {
#if 0
            if(this->reload==SESS_RELOAD) {
                Trace("sess# %d, RELOAD, [%d:%d]\n",
                    this->sid, this->fhash, this->shash);
            }
            else
            if(this->reload==SESS_UNCACHABLE) {
                Trace("sess# %d, UNCACHABLE, [%d:%d]\n",
                    this->sid, this->fhash, this->shash);
            }
#endif

            MUTEX_LOCK(&stat_lock);
            miss_reply_count++;
            MUTEX_UNLOCK(&stat_lock);

            this->state = STATE_QUERY_ADDR;
        }

        break;

    /* POST method */
    case M_POST:
Trace("POST method <%s>\n", this->loc);
        MUTEX_LOCK(&stat_lock);
        miss_reply_count++;
        MUTEX_UNLOCK(&stat_lock);

        this->state = STATE_QUERY_ADDR;

        break;

    default:
        Error("sess# %d, ignore method %d '%s'",
            this->sid, this->state, MSG_M_[this->state]);

        MUTEX_LOCK(&stat_lock);
        miss_reply_count++;
        MUTEX_UNLOCK(&stat_lock);

        this->reason = R_UNSUPPORT_METHOD;
        this->state = STATE_MESSAGE;

        break;
    }

#if 0
    MUTEX_LOCK(&stat_lock);
    process_request_count++;
    MUTEX_UNLOCK(&stat_lock);
#endif

    return 0;
}

int
DoCheckEndFriendSess(sess_t *this)
{
    int chk;

    block_cntl_rec *bcr;
    line_rec *hlpos;

 assert(_htrie_slot==htrie_shadow_top);

#ifdef TRACE_SESS
    Trace("DoCheckEndFriendSess: sess# %d, '%s' [%d:%d] %s\n",
        this->sid, this->loc, this->fhash, this->shash,
        MSG_STATE_[this->state]);

#if 0
    cache_showblockaddr(this->fhash, 0);
#endif

#endif


    bcr = (block_cntl_rec*) cache_block_pos(this->fhash);
    if(bcr==NULL) {
        Error("; block position is not resolved");
        goto out;
    }

    chk = MUTEX_LOCK(&bcr->mutex);

    hlpos = (line_rec*)cache_find_line(this->fhash, this->shash, this->loc);

    if(hlpos==NULL) {
#ifdef TRACE_SESS
        Trace("sess# %d, not found in cache. may be expired\n", this->sid);
#endif
        MUTEX_LOCK(&stat_lock);
        miss_reply_count++;
        MUTEX_UNLOCK(&stat_lock);

        this->state = STATE_QUERY_ADDR;
    }
    else
    if(hlpos->cntl.owner==this->sid) {
#ifdef TRACE_SESS
        Trace("sess# %d, line is mine. may be expired\n", this->sid);
#endif
        MUTEX_LOCK(&stat_lock);
        miss_reply_count++;
        MUTEX_UNLOCK(&stat_lock);

        this->state = STATE_QUERY_ADDR;
    }
    else {
        if(hlpos->cntl.cracked) {
#ifdef TRACE_SESS
            Trace("sess# %d, line was cracked\n", this->sid);
#endif
            MUTEX_LOCK(&stat_lock);
            miss_reply_count++;
            MUTEX_UNLOCK(&stat_lock);

            this->state = STATE_QUERY_ADDR;
        }
        else
        if(hlpos->cntl.owner==0) {
#ifdef TRACE_SESS
            Trace("sess# %d, line is free\n", this->sid);
#endif
#if 0
cache_showblockaddr(this->fhash, 1);
#endif
            MUTEX_LOCK(&stat_lock);
            hit_reply_count++;
            MUTEX_UNLOCK(&stat_lock);

            this->state = STATE_SEND_CACHE;
        }
        else {
#ifdef TRACE_SESS
            Trace("sess# %d, still hold by sess# %d\n",
                this->sid, hlpos->cntl.owner);
#endif
            /* not hit and not miss */

            this->state = STATE_WAIT_FRIEND;
            this->reason2 = hlpos->cntl.owner;
        }
    }

#if 0
    if(this->state != STATE_WAIT_FRIEND) {
        Trace("DoCheckEndFriendSess: change to %s\n",
            MSG_STATE_[this->state]);
        cache_showblockaddr(this->fhash, 0);
    }
#endif

    if(bcr) {
        chk = MUTEX_UNLOCK(&bcr->mutex);
        bcr = NULL;
    }

out:

    return 0;
}


int
DoFindServer(sess_t *this)
{
    int chk;
    int ret;

 assert(_htrie_slot==htrie_shadow_top);

#if 0
    Trace("DoFindServer: URL '%s'\n\t host '%s', port %d, path '%s'\n",
        this->loc, this->servername, this->serverport, this->serverpath);
#endif
    if(this->servername==NULL || this->servername[0]=='\0') {
        Error("sess# %d, empty hostname is specified", this->sid);
        return -1;
    }

 assert(_htrie_slot==htrie_shadow_top);

#if 0
    hcache_list();
#endif

    chk = hcache_seek_addr_incache(this->servername, &(this->serveraddr));
 assert(_htrie_slot==htrie_shadow_top);
    if(chk) {
        /* miss */
#if 0
        Trace("miss in hostname cache, '%s' (%d)\n",
            this->servername, chk);
        Trace("send query to resolver\n");
#endif
        chk = hcache_send_query_addr_direct(this->servername,
                &(this->serveraddr), &this->rfd);
#if 0
        Trace("    ret %d\n", chk);
#endif
        if(chk) {
            Error("fail hcache_send_query_addr_direct() (%d)\n", chk);
            this->reason = R_RESOLVER_DOWN;
            this->state = STATE_MESSAGE;
            goto out;
        }

        this->state = STATE_WAIT_ADDR;
        ret = 0;
    }
    else {
        /* hit */
#if 0
        Trace("hit in hostname cache, '%s'\n",
            this->servername);
#endif
        this->serveraddr.sin_family = AF_INET;

        this->state = STATE_CONN_SERV;
        ret = 0;
    }

out:
 assert(_htrie_slot==htrie_shadow_top);
    return ret;
}


int
DoServerConnect(sess_t *this)
{
    int chk;

 assert(_htrie_slot==htrie_shadow_top);
#if 0
    Trace("DoServerConnect: server '%s' [%s], port %d\n",
        this->servername, inet_ntoa(this->serveraddr.sin_addr),
        this->serverport);
#endif

    this->last_action = time(NULL);

#if 0
    /* syncronus connect */
    this->sfd = TCP_connect_addr(&this->serveraddr, this->serverport);
    if(this->sfd<0) {
        this->state = STATE_MESSAGE;
        return 0;
    }

    this->state = STATE_SEND_REQUEST;
#else
    /* asyncronus connect */
    this->sfd = TCP_aconnect_addr(&this->serveraddr, this->serverport);
    if(this->sfd<0) {
        if(this->sfd == KOTETU_SOCK_SOCKETERROR) {
            this->reason = R_FAIL_SERVER_SOCKET;
#if 0
            exit(437);
#endif
        }
        else {
			Error("DoServerConnect: sess# %d, reason %d",
				this->sid, this->sfd);
            this->reason = R_FAIL_SERVER_CONNECT;
        }
        this->state = STATE_MESSAGE;
        return 0;
    }

    this->state = STATE_WAIT_CONN_SERV;
#endif

    return 0;
}

int
DoWaitServerConnect(sess_t *this)
{
    volatile int errno_backup;
    int err, len;
    int chk;

 assert(_htrie_slot==htrie_shadow_top);

#if 0
    Trace("DoWaitServerConnect: server '%s' [%s], port %d\n",
        this->servername, inet_ntoa(this->serveraddr.sin_addr),
        this->serverport);
#endif

    chk = iswritable_via_poll(this->sfd, 1, 0);
    if(chk>0) {
        this->state = STATE_SEND_REQUEST;
    }

    return 0;
}

int
DoSendRequest(sess_t *this)
{
    char req[L_BUF];
    int len, rqlen;
    register char *p, *q, *r;
    int  nw;
    char line[STRING_SIZE];
    char *cpos;

 assert(_htrie_slot==htrie_shadow_top);

    /*
     * several server requires HOST field, independly protocol versions.
     * then, the program put HOST field.
     */
    if(this->method==M_POST) {
        sprintf(req, "POST %s HTTP/1.0\r\nHost: %s\r\n",
            this->serverpath, this->servername);
#if 1
    dump_stringchunk("orignal", this->reqbuf);
#endif
#if 0
    dump_stringsegment("orignal", this->reqbuf, this->reqlen);
    dump_stringchunk("first", req);
#endif
    }
    else {
        sprintf(req, "GET %s HTTP/1.0\r\nHost: %s:%d\r\n",
            this->serverpath, this->servername, this->serverport);
    }

#if 0
    dump_stringsegment("r.req.", this->reqbuf, this->reqlen);
#endif

 assert(_htrie_slot==htrie_shadow_top);
    rqlen = HTTP_find_header_term(this->reqbuf, this->reqlen);
 assert(_htrie_slot==htrie_shadow_top);
    if(rqlen>=L_REQBUF-1) {
        Error("too long requst (meybe rqlen is %d)", rqlen);
        dump_stringsegment("the request", this->reqbuf, this->reqlen);

        this->state = R_TOOLONG_REQ;
        this->state = STATE_MESSAGE;
        return -1;
    }

    p = this->reqbuf;
    r = this->reqbuf + rqlen;

    while(*p && *p!='\n') {
        p++;
    }
    p++;

 assert(_htrie_slot==htrie_shadow_top);
    /* skip first line, because it was already copied */
    q = req;
    while(*q) {
        q++;
    }

    /* copy rest of header */
    cpos = p;
    while((cpos = sgets(p, cpos, line, STRING_SIZE))!=NULL) {
        if(line[0]=='\0') {
            break;
        }
        if((line[0]=='H' || line[0]=='h')
            && strncasecmp(line, "Host:", 5)==0) {
            continue;
        }
        if((line[0]=='P' || line[0]=='p')
            && strncasecmp(line, "Proxy-Connection:", 17)==0) {
            continue;
        }
        strcat(req, line);

        if(line[0]=='\r'||line[0]=='\n') {
            break;
        }
    }


    len = strlen(req);

#if 0
    dump_stringchunk("cooked request", req);
#endif

#if 1
    if(len>=L_REQBUF-1) {
        Error("too long requst (current %d, original %d)", len, this->reqlen);
        dump_stringchunk("the requst", req);

        this->state = R_TOOLONG_REQ;
        this->state = STATE_MESSAGE;
        return -1;
    }
#endif

#if 0
    dump_stringsegment("s.req.", req, len);
#endif

    if(this->method==M_POST) {
        int c;

        c = this->reqlen - (cpos-&this->reqbuf[0]);

#if 0
        dump_stringchunk("cooked", req);
#endif
        if(c) {
#if 0
            dump_stringsegment("rest  ", cpos, c);
#endif
            p = cpos;
            q = req + len;
            while(c>0) {
                *q++ = *p++;
                c--;
                len++;
            }
#if 0
        dump_stringsegment("cooked", req, len);
#endif
        }
    }

try_write:
    nw = write(this->sfd, req, len);
    if(nw<0) {
        if(errno==EINTR) {
            goto try_write;
        }

        if(errno==EPIPE) {
            this->reason = R_LOST_SERVER_CONNECT;
#if 0
            Error("sess# %d, server pipe (fd# %d) error (%d)",
                this->sid, this->sfd, errno);
#endif
        }
        else {
            this->reason = R_FAIL_SERVER_WRITE;

            Error("cannot write request to server sess %p fd #%d (%d)",
                this, this->sfd, errno);
        }

        this->state = STATE_MESSAGE;

        return -1;
    }
    if(nw==0) {
        this->state = STATE_CLOSE;
        return -1;
    }
#if 0
    Trace("write request %d byte(s)\n", nw);
#endif

    MUTEX_LOCK(&stat_lock);
    intra_outgoing += (off_t) nw;
    MUTEX_UNLOCK(&stat_lock);


    this->last_action = time(NULL);

 assert(_htrie_slot==htrie_shadow_top);

    if(this->method == M_GET) {
        this->state = STATE_RECV_RES;
    }
    else
    if(this->method == M_POST) {
        this->state = STATE_RELAY_DIRECT;
    }
    else {
    }

    return 0;
}


int
linecomp(const void *xp, const void *yp)
{
    int ret;
    line_cntl_rec *x, *y;

    x = (line_cntl_rec*)xp;
    y = (line_cntl_rec*)yp;

    if(x->oid==y->oid) {
       if(x->type==TYPE_NORMAL_LINE) {
            ret = 1;
       }
       else
       if(y->type==TYPE_NORMAL_LINE) {
            ret = -1;
       }
       else {
            ret = 0;
       }
    }
    else {
       ret = y->oid - x->oid;
    }
    return ret;
}


/*
 * for POST method
 */
int
DoRelayDirect(sess_t *this)
{
    int rest;
    int use_tmpbuf;
    char tmpbuf[L_BUF];
    block_cntl_rec *bcr;
    line_rec *hlpos, *tlpos, *nlpos;
    int l;
    struct iovec iovec[2];
    int ciovec;
    int blen;
    int nr;
    int nw;
    int chk;
    int err;

    int dir;
    int cr, cw, sr, sw;

#if 0
    Trace("DoRelayDirect: self %#x, sess# %d, hash %d:%d\n",
        pthread_self(), this->sid, this->fhash, this->shash);
#endif

 assert(_htrie_slot==htrie_shadow_top);


    dir = 0;
    cr = cw = sr = sw = (off_t)0L;

    /*
     * Since connection starts by client, client has high priority.
     */

client_side:
    if(this->cfd<0) {
        goto server_side;
    }
    chk = isreadable_via_poll(this->cfd, 0, 0);
    if(chk) {
        dir = 1; /* client */
    }
    else {
        goto server_side;
    }

try_c_read:
    nr = read(this->cfd, tmpbuf, L_BUF);
    if(nr<0) {
        if(errno==EINTR)
            goto try_c_read;

        this->reason = R_FAIL_CLIENT_READ;
        this->state = STATE_MESSAGE;
        goto out;
    }
    else
    if(nr==0) {
        DoHalfClientCloseSess(this);
        goto server_side;
    }


    cr += nr;

try_s_write:
    nw = write(this->sfd, tmpbuf, nr);
    if(nw<0) {
        if(errno==EINTR)
            goto try_s_write;

        this->reason = R_FAIL_SERVER_WRITE;
        this->state = STATE_MESSAGE;
        goto out;
    }

    sw += nw;


server_side:
    if(this->sfd<0) {
        goto disconn_check;
    }
    chk = isreadable_via_poll(this->sfd, 0, 0);
    if(chk) {
        dir += 2; /* server */
    }
    else {
        goto disconn_check;
    }

try_s_read:
    nr = read(this->sfd, tmpbuf, L_BUF);
    if(nr<0) {
        if(errno==EINTR)
            goto try_s_read;

        this->reason = R_FAIL_SERVER_READ;
        this->state = STATE_MESSAGE;
        goto out;
    }
    else
    if(nr==0) {
        DoHalfServerCloseSess(this);
        goto disconn_check;
    }

    sr += nr;

try_c_write:
    nw = write(this->cfd, tmpbuf, nr);
    if(nw<0) {
        if(errno==EINTR)
            goto try_c_write;

        this->reason = R_FAIL_CLIENT_WRITE;
        this->state = STATE_MESSAGE;
        goto out;
    }

    cw += nw;


disconn_check:

    if(this->cfd<0 || this->sfd<0) {
        this->state = STATE_CLOSE;
    }

out:
    MUTEX_LOCK(&stat_lock);
    if(cr>0) intra_incoming += cr;
    if(cw>0) intra_outgoing += cw;
    if(sr>0) extra_incoming += sr;
    if(sw>0) extra_outgoing += sw;
    MUTEX_UNLOCK(&stat_lock);

#if 0
    Trace("sess# %d, dir %x, cfd,sfd=%d,%d r/w=c %d/%d, s %d/%d %s\n",
        this->sid, dir, this->cfd, this->sfd,
        cr, cw, sr, sw, MSG_STATE_[this->state]);
#endif

    return 0;
}

int
DoServerReply(sess_t *this)
{
    int rest;
    int use_tmpbuf;
    char tmpbuf[L_BUF];
    block_cntl_rec *bcr;
    line_rec *hlpos, *tlpos, *nlpos;
    int l;
    struct iovec iovec[2];
    int ciovec;
    int blen;
    int nr;
    int nw;
    int chk;
    int err;
    struct timeval xbefore, xafter;

    int hlen;
    int xvmajor, xvminor;
    time_t xlmd, xexpire;
    off_t xclen;
    int xrcode;
    int xcachable;
    int xreload;

/*
#ifdef TRACE_CACHE
    Trace("DoServerReply: self %#x, sess# %d, hash %d:%d\n",
        pthread_self(), this->sid, this->fhash, this->shash);
#endif
*/

 assert(_htrie_slot==htrie_shadow_top);

#if 0
    chk = isreadable_via_poll(this->sfd, 0, 0);
    if(!chk) {
        return 0;
    }
#ifdef TRACE_CACHE
    Trace("DoServerReply: self %#x, sess# %d, hash %d:%d\n",
        pthread_self(), this->sid, this->fhash, this->shash);
#endif
#endif


    /***
     *** alloc buffer
     ***/
#ifndef DONTUSE_OCACHE
    use_tmpbuf = 0;
    bcr = NULL;
    hlpos = tlpos = NULL;
    blen = 0;

    if(this->cachable!=SESS_CACHABLE) {
        goto alloc_dicision_middle;
    }

    /*
     * alloc cache block with first hash
     */
    bcr = (block_cntl_rec*) cache_block_pos(this->fhash);
    if(bcr==NULL) {
        Error("; block position is not resolved");
        goto fail_memory;
    }

try_lock:
    /*
    chk = MUTEX_TRYLOCK(&bcr->mutex);
    */
    chk = MUTEX_LOCK(&bcr->mutex);
    if(chk) {
        bcr = NULL;     /* cancel */
        if(chk==EBUSY) {
#ifdef TRACE_CACHE
    Error("sess# %d, object cache line [%d:%d] was already used. sess %p (%d)",
        this->sid, this->fhash, this->shash, this, err);
#endif
            MUTEX_LOCK(&stat_lock);
            hash_colision++;
            MUTEX_UNLOCK(&stat_lock);
        }
        else {
            Error("DoServerReply: sess# %d, fail locking (%d)",
                this->sid, chk);
        }
        goto out;
    }

    ciovec = 2;
    iovec[0].iov_base = NULL;
    iovec[0].iov_len = -1;
    iovec[1].iov_base = NULL;
    iovec[1].iov_len = -1;

    gettimeofday(&xbefore, NULL);
    blen = alloc_buf(this, bcr, &hlpos, &tlpos, &nlpos, iovec, ciovec);
    gettimeofday(&xafter, NULL);
    sim_stat_add_value(&object_alloc_stat,
        KOTETU_SUB_TIME(xafter, xbefore));

    if(blen<0) {
        Error("DoServerReply: fail alloc_buf() for sess# %d, block# %d (%p)",
            this->sid, this->fhash, bcr);
        goto fail_memory;
    }
    if(blen>0 && ( hlpos==NULL || tlpos==NULL))  {
        Error("DoServerReply: fail alloc_buf() for sess# %d, block# %d (%p), len %d, head %p, tail %p",
            this->sid, this->fhash, bcr, blen, hlpos, tlpos);
        goto fail_memory;
    }
    if(blen==0) {
        use_tmpbuf = 1;
    }
    else {
#if 0
        if(this->ims>0 && hlpos && hlpos->cntl.lmd>0) {
            Trace("sess# %d, ims %d, lmd %d\n",
                this->sid, this->ims, hlpos->cntl.lmd);
        }
#endif
        if(this->ims>0 && hlpos && hlpos->cntl.lmd>0
            && hlpos->cntl.lmd < this->ims) {
            use_tmpbuf = 1;
        }
    }

#else /* DONTUSE_OCACHE */
    bcr = NULL;
    hlpos = tlpos = NULL;
    blen = 0;
    use_tmpbuf = 1;
#endif /* DONTUSE_OCACHE */


alloc_dicision_middle:
    if(use_tmpbuf || blen==0) {
#ifdef TRACE_CACHE
        Trace("  alloc to temporary area\n");
#endif
        iovec[0].iov_base = tmpbuf;
        iovec[0].iov_len = sizeof(tmpbuf);
        blen = 1;
    }
    else {
#ifdef TRACE_CACHE
        Trace("  alloc to cache area\n");
#endif
    }

    if(blen==1) {
        rest = iovec[0].iov_len;
    }
    else
    if(blen==2) {
        rest = iovec[0].iov_len + iovec[1].iov_len;
    }
    else {
        rest = -1;
    }

#if 0
Trace("read:\n");
Trace("  blen %d\n", blen);
Trace("  iovec[0] base %p, len %d\n", iovec[0].iov_base, iovec[0].iov_len);
if(blen>=2)
Trace("  iovec[1] base %p, len %d\n", iovec[1].iov_base, iovec[1].iov_len);
Trace("  rest %d\n", rest);
#endif

    /***
     *** read socket
     ***/
    MUTEX_LOCK(&stat_lock);
    read_reply_total++;
    MUTEX_UNLOCK(&stat_lock);

try_read:
 assert(_htrie_slot==htrie_shadow_top);
    errno = 0;
    nr = readv(this->sfd, iovec, blen);
    err = errno;
#ifdef TRACE_CACHE
    if(use_tmpbuf) {
        Trace("  sess# %d, fd# %d, read %d/%d (temporaly area)\n",
            this->sid, this->sfd, nr, rest);
    }
    else {
        Trace("  sess# %d, fd# %d, read %d/%d (cache area)\n",
            this->sid, this->sfd, nr, rest);
    }
    Trace("  hlpos %p, tlpos %p\n", hlpos, tlpos);
#endif
    if(nr<0) {
        if(errno==EINTR) {
            goto try_read;
        }
        /* for OSF/1 */
        if(errno==0) {
            goto try_read;
        }

        MUTEX_LOCK(&stat_lock);
        read_reply_fail++;
        MUTEX_UNLOCK(&stat_lock);

        if(errno==EAGAIN) {
            goto out;
        }
        if(errno==ECONNRESET) {
            goto lost_connect;
        }
        Error("cannot read server reply nr %d (%d)", nr, err);

        goto fail_read;
    }

    MUTEX_LOCK(&stat_lock);
    read_reply_success++;
    MUTEX_UNLOCK(&stat_lock);

    if(nr==0) {
        goto reach_end;
    }

    MUTEX_LOCK(&stat_lock);
    extra_incoming += (off_t) nr;
    MUTEX_UNLOCK(&stat_lock);

    sim_stat_add_value(&len_perread_stat, (long)nr);

    if(this->pos==0) {

        hlen = HTTP_find_header_term(iovec[0].iov_base,
                MAX(nr, iovec[0].iov_len));
#if 0
Trace("sess# %d, header term %d\n", this->sid, chk);
#endif
        if(hlen) {

        xcachable   = this->cachable;
        xreload     = this->reload;

        chk = HTTP_parse_response_header(iovec[0].iov_base, hlen,
                &xvmajor, &xvminor, &xrcode, &xlmd, &xexpire, &xclen,
                &xcachable, &xreload);
#if 0
Trace("sess# %d, <chk %d> ver %d.%d, rcode %d, lmd %d, expire %d, clen %d\n",
    this->sid, chk,
    xvmajor, xvminor, xrcode, xlmd, xexpire, xclen);
#endif

        if(!chk) {
            this->sver_major    = xvmajor;
            this->sver_minor    = xvminor;
            this->rcode         = xrcode;
            this->lmd           = xlmd;
            this->expire        = xexpire;
            this->clen          = xclen;
            this->cachable      = xcachable;
            this->reload        = xreload;
        }
        else {
            this->sver_major    = 0;
            this->sver_minor    = 0;
            this->rcode         = -1;
            this->lmd           = -1;
            this->expire        = -1;
            this->clen          = -1;
            this->cachable      = 1;
            this->reload        = 0;
        }


        }

    }

 assert(_htrie_slot==htrie_shadow_top);

    if(this->len<0) {
        this->len = (off_t) nr;
    }
    else {
        this->len += (off_t) nr;
    }

    if(hlpos) {
        if(hlpos->cntl.totallength<0)
            hlpos->cntl.totallength = nr;
        else
            hlpos->cntl.totallength += nr;

        if(blen==1) {
            tlpos->cntl.length += nr;
        }
        else
        if(blen==2) {
            if(nr <= iovec[0].iov_len) {
                tlpos->cntl.length += nr;
            }
            else {
                tlpos->cntl.length += iovec[0].iov_len;
                nlpos->cntl.length = (nr - iovec[0].iov_len);
            }
        }
    }

    this->last_action = time(NULL);

    if(this->cfd>=0) {
        if(blen==2) {
            if(nr<=iovec[0].iov_len) {
                blen = 1;
                iovec[0].iov_len = nr;
            }
            else {
                if(nr<=iovec[0].iov_len + iovec[1].iov_len) {
                    iovec[1].iov_len = nr - iovec[0].iov_len;
                }
                else {
        Error("length of read <%d> is large than buffer <%d(%d+%d)>\n",
            nr, iovec[0].iov_len + iovec[1].iov_len);
                }
            }
        }
        else
        if(blen==1) {
            if(nr<iovec[0].iov_len) {
                iovec[0].iov_len = nr;
            }
        }
#if 0
Trace("write:\n");
Trace("  blen %d\n", blen);
Trace("  iovec[0] base %p, len %d\n", iovec[0].iov_base, iovec[0].iov_len);
if(blen>=2)
Trace("  iovec[1] base %p, len %d\n", iovec[1].iov_base, iovec[1].iov_len);
#endif

try_write:
 assert(_htrie_slot==htrie_shadow_top);
        nw = writev(this->cfd, iovec, blen);

        if(nw<0) {
            if(errno==EINTR) {
                goto try_write;
            }
            if(errno==EPIPE) {
                DoHalfClientCloseSess(this);
                goto reach_end;
            }

            Error("sess# %d, cannot write to client fd# %d (%d)",
                this->sid, this->cfd, errno);
#if 0
            this->state = STATE_CLOSE;
#endif
            this->reason = R_FAIL_CLIENT_WRITE;
            DoHalfClientCloseSess(this);

            goto fail_write;
        }
        if(nw<nr) {
            Error("wrote size (%d) is smaller than read size (%d)\n", nw, nr);
            goto fail_write;
        }
        if(nw>nr) {
            Error("wrote size (%d) is larger than read size (%d)\n", nw, nr);
		}

        this->pos += (off_t) nw;

        MUTEX_LOCK(&stat_lock);
        intra_outgoing += (off_t) nw;
        MUTEX_UNLOCK(&stat_lock);
    }

#if 0
    if(this->pos != this->len) {
    Trace("sess# %d, pos %ld, len %ld\n",
        this->sid, (long)this->pos, (long)this->len);
    }
#endif

    goto out;

/*
 * error recovery
 */

fail_memory:
    Error("fail memory arrengment or memory trouble, sess# %d",
        this->sid);
    this->reason = R_LOST_BLOCK;

    goto fail;

lost_connect:
    Error("lost conection establishment to server with some reason, sess# %d",
        this->sid);
    this->reason = R_LOST_SERVER_CONNECT;

    goto fail;

fail_connect:
    Error("fail conection establishment to server with some reason, sess# %d",
        this->sid);
    this->reason = R_FAIL_SERVER_CONNECT;

    goto fail;

fail_read:
    Error("fail reading from server with some reason, sess# %d",
        this->sid);
    this->reason = R_FAIL_SERVER_READ;

    goto fail;

fail_write:
    Error("fail writing to client with some reason, sess# %d",
        this->sid);
    this->reason = R_FAIL_CLIENT_WRITE;

    goto fail;

fail:
    this->state = STATE_MESSAGE;
    if(hlpos) {
        hlpos->cntl.hot = 0;
        hlpos->cntl.owner = 0;
    }

    goto out;




reach_end:
    this->state = STATE_CLOSE;
#ifdef TRACE_CACHE
    Trace("Ok,sess# %d [%d:%d]                 read %12ld / %4ldK / %4ldM\n",
        this->sid, this->fhash, this->shash,
        (long)this->len,
        (long)(this->len/1024), (long)(this->len/(1024*1024)) );
#endif

    sim_stat_add_value(&object_size_stat, (long)(this->len/1024) );

    if(this->len==0) {
        Log("; sess# %d, empty ?", this->sid);
    }

    if(hlpos) {

        /* discard cached object */
        if(this->rcode == 304) {
            hlpos->cntl.cracked = 1;
        }

        hlpos->cntl.owner = 0;
    }

    goto out;

out:
 assert(_htrie_slot==htrie_shadow_top);
    if(bcr) {
        chk = MUTEX_UNLOCK(&bcr->mutex);
        bcr = NULL;
    }
    if(hlpos) {
        hlpos->cntl.hot = xafter.tv_sec;
    }
#ifdef TRACE_CACHE
Trace(" @\n\n");
#endif

    return 0;
}




int
DoSendCache(sess_t *this)
{
    int chk;
    block_cntl_rec *bcr;
    char *lcrp;
    line_cntl_rec *lcr;
    line_rec *lpos_edge;
    line_rec *hlpos, *tlpos, *clpos;
    int sum;
    int nw;
    int l;
    struct iovec iov[MAX_LINE_PER_OBJ];
    int ciov;

 assert(_htrie_slot==htrie_shadow_top);
#if 0
    struct timeval reftime;
#endif

#if 0
    Trace("DoSendCache: [%d:%d] '%s'\n",
    this->fhash, this->shash, this->loc);
#endif

    /*
     *
     */
    bcr = (block_cntl_rec*) cache_block_pos(this->fhash);
    if(bcr==NULL) {
        goto out;
    }
    chk = MUTEX_LOCK(&bcr->mutex);
    if(chk) {
        bcr = NULL;
        goto out;
    }

#if 0
    gettimeofday(&reftime, NULL);
#endif

 assert(_htrie_slot==htrie_shadow_top);

    hlpos = (line_rec*)cache_find_line(this->fhash, this->shash, this->loc);
    /* not found object */
    if(hlpos==NULL){
        Error("DoSendCache: hit sess# %d [%d:%d]. however, not found <%s,%s>",
            this->sid, this->fhash, this->shash,
            this->cachable==SESS_CACHABLE ? "cachable" : "NOTCACHABLE",
            this->reload==SESS_RELOAD ? "RELOAD" : "noreload");
#if 0
        Trace("  target='%s'\n", this->loc);
        cache_showblockaddr(this->fhash, 0);
#endif

        MUTEX_LOCK(&stat_lock);
        miss_reply_count++;
        hit_reply_count--;
        MUTEX_UNLOCK(&stat_lock);

        this->state = STATE_QUERY_ADDR;

        goto out;
    }

 assert(_htrie_slot==htrie_shadow_top);


    /* found object */

    tlpos = hlpos;
    lpos_edge = (line_rec*)( (char*) bcr + linesize*(nline-1) );

    this->len = hlpos->cntl.totallength;

#if 0
Trace("DoSendCache: sess# %d, ims %d, lmd %d, expire %d\n",
        this->sid, this->ims, hlpos->cntl.lmd, hlpos->cntl.expire);
#endif

#if 0
    Trace("sess# %d, pos %ld, len %ld // len %d, previous send %d, rest %d\n",
        this->sid,
        (long)this->pos, (long)this->len,
        hlpos->cntl.totallength,
        this->pos, hlpos->cntl.totallength - this->pos);
#endif

    if(this->len<0) {
        Trace("cached object is nothing.  Try retrieval once more.\n");

        this->state = STATE_QUERY_ADDR;

        goto out;
    }
    if(hlpos->cntl.totallength==0) {
        Trace("cached object is empty.  Try retrieval once more.\n");

        this->state = STATE_QUERY_ADDR;

        goto out;
    }
    if(hlpos->cntl.cracked) {
        Trace("cached object is cracked.  Try retrieval once more.\n");

        this->state = STATE_QUERY_ADDR;

        goto out;
    }
    if(this->pos>=hlpos->cntl.totallength) {
        Error("sess# %d, all content of object was send",
            this->sid, this->pos, this->len);
        goto done;
    }

    /*
     *
     */
    if(this->ims>0) {
#if 0
Trace("DoSendCache: sess# %d, ims %d, lmd %d, expire %d\n",
        this->sid, this->ims, hlpos->cntl.lmd, hlpos->cntl.expire);
#endif
    }


    /*
     *
     */
    hlpos->cntl.count++;
    this->count = hlpos->cntl.count;
#if 0
    hlpos->cntl.hot = reftime.tv_sec;
#endif
    hlpos->cntl.hot = this->last_action;
    this->ishit = SESS_HIT;
    this->oid = hlpos->cntl.oid;
    if(hlpos->cntl.oid<0) {
        Error("stored oid is negative");
    }

    this->rcode = HTTP_parse_response_code(
        (char*)&hlpos->body + this->pos,
        MAX(hlpos->cntl.length, 16));


    /*
     *
     */
    clpos = hlpos;
    sum = 0;

    do
    {
        l = 0;
        do {
 assert(_htrie_slot==htrie_shadow_top);
            iov[l].iov_base = (char*) &clpos->body;
            iov[l].iov_len = clpos->cntl.length;
            if(clpos->cntl.length>0) {
                sum += clpos->cntl.length;
            }

            tlpos = clpos;
            l++;

            clpos = (line_rec*)(clpos->cntl.next);
        } while(clpos && l < max_line_per_write
          && clpos->cntl.length>0 && clpos->cntl.type==TYPE_SLAVE_LINE);
        ciov = l;

        if(this->cfd<0) {
            break;
        }

try_write:
 assert(_htrie_slot==htrie_shadow_top);
#if 0
Trace("sess# %d, iov %d/%d\n", this->sid, ciov, max_line_per_write);
#endif
        nw = writev(this->cfd, iov, ciov);
        if(nw<0) {
            if(errno==EINTR) {
                goto try_write;
            }
            if(errno==EPIPE) {
                DoHalfClientCloseSess(this);
                goto done;
            }
            Error("sess# %d, cannot write to client fd# %d, ciov %d, (%d)",
            this->sid, this->cfd, ciov, errno);
#if 1
            this->reason = R_FAIL_CLIENT_WRITE;
            this->state = STATE_CLOSE;
#endif
#if 0
            this->reason = R_FAIL_CLIENT_WRITE;
            DoHalfClientCloseSess(this);
#endif

            goto out;
        }

        MUTEX_LOCK(&stat_lock);
        intra_outgoing += (off_t) nw;
        MUTEX_UNLOCK(&stat_lock);

        this->pos += nw;
        this->last_action = time(NULL);

    } while(sum<max_line_per_obj && clpos!=NULL);


    if(this->pos>=hlpos->cntl.length) {
        goto done;
    }


done:
    this->state = STATE_CLOSE;
    if(hlpos) {
        hlpos->cntl.hot = 0;
    }

out:
    if(bcr) {
        chk = MUTEX_UNLOCK(&bcr->mutex);
    }

    return 0;
}





/* support only IPv4 */
static
int
store_scrambled_name(char *dst, struct sockaddr_in *addr, int sc_key)
{
    register char *p, *q;
    register int i;
    register int c;

    q = (char*) &addr->sin_addr;

    c = 0xc634d3a5;
    c |= sc_key;
    for(i=3;i>=0;i--) {
        p = &q[i];
        c += *p;
        c = c << 3 + 0x01;

#if 0
        Trace(" #%d %3u %2x -> %12u %12x\n",
            i, (unsigned int)*p, (unsigned int)*p,
            (unsigned int)c, (unsigned int)c);
#endif
    }

    sprintf(dst, "c%u", c);

    return 0;
}

static
int
store_direct_name(char *dst, struct sockaddr_in *addr)
{
    register char *p, *q;
    register int i;
    register int c;

    p = (char*) &addr->sin_addr;
    q = dst;

    for(i=0;i<4;i++) {
        if(*p>100)
            *q++ = '0' + (*p / 100);
        if(*p>10)
            *q++ = '0' + ((*p % 100)/10);
        *q++ = '0' + (*p % 10);
        *q++ = '.';
        *q = '\0';

#if 0
        Trace(" #%d %3u %2x -> '%s'\n",
            i, (unsigned int)*p, (unsigned int)*p, dst);
#endif

        p++;
    }

    return 0;
}


static
int client_scramble_key;

void*
Listener(void *called_option)
{
    int chk;
    struct sockaddr_in from;
    int len;
    int cfd;
    int find;
    int p, c;
    int op;
    int listen_fd;
    sess_t *sessp;
    int t_req, t_rjq;
    int t_nhot;
    int err;
    int try_c;
    struct timeval tmp_accept_time;
    char tmp_clientname[L_HOST];


    listen_fd = *(int*)called_option;
    len = sizeof(from);

    while(1) {
try_accept:
#ifdef DO_ACCEPT_LOCK
        chk = MUTEX_LOCK(&accept_lock);
        if(chk) {
            Error("Listener: fail lock (%d)", chk);
            if(chk==EBUSY) {
                Trace(" ---  busy\n");
                goto try_accept;
            }

            goto try_accept;
        }
#endif

        err = errno = -1;
        cfd = accept(listen_fd, (struct sockaddr*)&from, &len);
        err = errno;
        gettimeofday(&tmp_accept_time, NULL);

#if 0
        Trace("Listener<%p> accept fd# %d (errno %d)\n",
            pthread_self(), cfd, err);
#endif

#ifdef DO_ACCEPT_LOCK

        try_c=0;
try_unlock:
        try_c++;

        chk = MUTEX_UNLOCK(&accept_lock);
        if(chk) {
            Error("Listener: fail unlock (%d) [%d]", chk, try_c);
            goto try_unlock;
        }
#endif

        if(cfd<0) {
            if(err==EINTR)
                goto try_accept;
#if 0
            if(err==ENFILE || err==EMFILE) {
                sleep(5);
                /*
                exit(143);
                */
            }
#endif

            Error("accept error (%d)", err);

            goto next;
        }

 assert(_htrie_slot==htrie_shadow_top);
#ifdef LOG_DIRECTCLIENTIPADDRESS
        store_direct_name(tmp_clientname, &from);
#else
        store_scrambled_name(tmp_clientname, &from, client_scramble_key);
#endif
 assert(_htrie_slot==htrie_shadow_top);

        MUTEX_LOCK(&stat_lock);
        receive_request_count++;
        request_sirial_count++;
        t_req = request_sirial_count;
        MUTEX_UNLOCK(&stat_lock);

#if 0
        Trace("th %d, conn. count %6d, cfd %3d\n",
            pthread_self(), t_req, cfd);
#endif


found_free:

        sessp = (sess_t*)sq_get_free();
        if(sessp==NULL) {
            Error("not enough memory for session");
            goto not_found_free;
        }


        /*
         * NOTE:
         *   # of hot session will be discrease.
         *   however, it is not increase. because increasing is only
         *   happen in this routines.
         */

        MUTEX_LOCK(&sess_lock);
        nhot++;
        MUTEX_UNLOCK(&sess_lock);



        chk = pthread_mutex_init(&(sessp->busy), NULL);

        sessp->sid    = t_req;
        sessp->psid   = -1;
        sessp->mode   = MODE_CLIENT;
        sessp->level  = 0;
        sessp->state  = STATE_ACCEPT;

        sessp->accept_time = tmp_accept_time;
        sessp->last_action = tmp_accept_time.tv_sec;

        sessp->reported = 0;
        sessp->reason = -1;

        sessp->pos    =  0;
        sessp->len    = -1;
        sessp->rcode  = -1;
        sessp->count  = 0;
        sessp->lmd    = -1;
        sessp->expire = -1;

        sessp->cachable = SESS_CACHABLE;
        sessp->reload   = SESS_NORELOAD;
        sessp->ishit  = SESS_MISS;
        sessp->oid    = -1;

        sessp->cfd    = cfd;
        sessp->sfd    = -1;
        sessp->rfd    = -1;

        strcpy(sessp->clientname, tmp_clientname);

        memset(sessp->loc, 0, sizeof(sessp->loc));
        sessp->method = M_UNKNOW;

        memset(sessp->reqbuf, 0, sizeof(sessp->reqbuf));
        sessp->reqlen = 0;

        sessp->ims = -1;

#ifdef TRACE_SESS
        Trace("sess# %d, new, addr %p\n", sessp->sid, sessp);
#endif

        sessp->state  = STATE_RECV_REQ;

        chk = push_sess(think_queue, sessp);
        if(chk) {
            Error("Listener: sess# %d, fail push to think Q", sessp->sid);
            DoSendMessage(sessp);
            DoCloseSess(sessp);
            DoReleaseSess(sessp);
            sessp = NULL;

            goto next;
        }

#if 0
        MUTEX_LOCK(&think_queue->lock);
        fflush(stderr);
        sq_show(stdout, think_queue);
        fflush(stdout);
        MUTEX_UNLOCK(&think_queue->lock);
#endif



        goto next;

not_found_free:
#if 0
        Error("not found idle session cell");
#endif
        MUTEX_LOCK(&stat_lock);
        reject_request_count++;
        t_rjq = reject_request_count;
        MUTEX_UNLOCK(&stat_lock);
#if 1
		if(t_rjq%100==0) {
			LogLine(": ; session list overflow");
		}
#endif


        HTTP_SendIgnoreMessage(cfd, 501,
            "service denided", "please wait few minutus");
        shutdown(cfd, 2);
        close(cfd);
        cfd = -1;

next:
        chk = 0;

    }

}



int
DoParseAnchor(sess_t *this)
{
    int chk;
    block_cntl_rec *bcr;
    line_rec *line_pos;
    int rest;
    int nw;
    int l;

    int t_req=1234; /* dummy */

    int nc;
    int ntag;
    int ihave;

    int howprefetch;

    tags_t  *tags;
    char    **urllist;
    int     nofref;

    sess_t *psessp;
    char **aurl;
    char nurl[L_URL];

    int fh, sh;

#ifdef TRACE_THREADS
    Trace("DoParseAnchor: sid %d, [%d:%d]\n",
        this->sid, this->fhash, this->shash);
#endif

 assert(_htrie_slot==htrie_shadow_top);

    tags = NULL;

    if(this->cachable==SESS_UNCACHABLE) {
#ifdef TRACE_PREFETCH
        Trace("DoParseAnchor: sess# %d is not cachable\n", this->sid);
#endif
        goto out_nothing;
    }
#ifdef TRACE_PREFETCH
    Trace("DoParseAnchor: sess# %d, level %d, URL '%s'\n",
        this->sid, this->level, this->loc);
#endif

    /* allow level 0 or 1 */
    if(this->level<0 || this->level>2) {
#if 0
        Trace("sess# %d %p, strange level %d\n",
            this->sid, this, this->level);
#endif
        goto out;
    }

    /*
     *
     */
    bcr = (block_cntl_rec*) cache_block_pos(this->fhash);
    if(bcr==NULL) {
        goto out_nothing;
    }
    chk = MUTEX_LOCK(&bcr->mutex);
    if(chk) {
        Trace("DoParseAnchor: fail lock block #%d [%d:%d]\n",
            this->fhash, this->fhash, this->shash);
        goto out_pending;
    }

 assert(_htrie_slot==htrie_shadow_top);
    line_pos =
        (line_rec*) cache_find_line(this->fhash, this->shash, this->loc);

    /* found object */
    if(line_pos==NULL) {
        Trace("sess# %d, conetent not found\n", this->sid);
        chk = MUTEX_UNLOCK(&bcr->mutex);
        bcr = NULL;
        goto not_found;
    }

    if(line_pos->cntl.length==0) {
        Trace("sess# %d, conetent is empty ?\n", this->sid);
        cache_showblockaddr(this->fhash, 0);
    }

    rest = line_pos->cntl.length - this->pos;
#if 0
    Trace("rest %d (cache line length %d, session position %d)\n",
        rest, line_pos->cntl.length , this->pos);
#endif

#if 0
    /* over */
    if(this->pos>=line_pos->cntl.length) {
        chk = MUTEX_UNLOCK(&bcr->mutex);
        bcr = NULL;
        goto done;
    }
#endif


    /***
     ***
     ***/

assert(_htrie_slot==htrie_shadow_top);
    tags = HTML_NewTags();
assert(_htrie_slot==htrie_shadow_top);

    if(this->level==0) {
#ifdef TRACE_PREFETCH
        Trace("parse refered: '%s' %db\n",
            this->loc, line_pos->cntl.length);
#endif
        chk = MUTEX_LOCK(&config_lock);
        howprefetch = num_prefetch_referedpages;
        chk = MUTEX_UNLOCK(&config_lock);

        ntag = HTML_ParseTags_FromMemory(tags, PARSE_REFERED,
                (char*)&line_pos->body, line_pos->cntl.length);
#ifdef TRACE_PREFETCH
        Trace("parse refered: #%d %ldb %d\n",
            this->sid, (long)line_pos->cntl.length, ntag);
#endif
    }
    else
    if(this->level==1) {
#ifdef TRACE_PREFETCH
        Trace("parse included: '%s' %db\n",
            this->loc, line_pos->cntl.length);
#endif
        chk = MUTEX_LOCK(&config_lock);
        howprefetch = num_prefetch_includedobjs;
        chk = MUTEX_UNLOCK(&config_lock);

        ntag = HTML_ParseTags_FromMemory(tags, PARSE_INCLUDED,
                (char*)&line_pos->body, line_pos->cntl.length);

#ifdef TRACE_PREFETCH
        Trace("parse included: #%d %db %d\n",
            this->sid, line_pos->cntl.length, ntag);
#endif
    }


#if 0
    dump_stringchunk("entity", (char*)&line_pos->body);
    Trace("there are %d tag(s).\n", ntag);
#endif

    chk = MUTEX_UNLOCK(&bcr->mutex);
    line_pos = NULL;



assert(_htrie_slot==htrie_shadow_top);

    if(ntag<=0) {
        FREE(tags);
        tags = NULL;
        goto out;
    }

    if(tags==NULL) {
        goto out;
    }
    else {
        if(tags->count==0) {
            FREE(tags);
            tags = NULL;
            goto out;
        }
    }

    urllist = HTML_ConvURLList(tags, &nofref);
    HTML_DestroyTags_withoutvalue(tags);
    tags = NULL;



    /*
     *
     */

#if 0
    /*
    HTML_ShowIndependURLList(this->loc, urllist);
    */
    HTML_ShowURLList(urllist);
#endif

#ifdef TRACE_PREFETCH
    if(urllist) {
        Trace("DoParseAnchor<%d>: decide prefetch targets about\n  '%s'\n",
            pthread_self(), this->loc);
    }
    else {
        Trace("DoParseAnchor<%d>: prefetch target list is empty\n");
    }
#endif

    nc = 0;
    aurl = urllist;
    while(*aurl!=NULL && nc<howprefetch) {
#if 0
        Trace("  newone '%s'\n", *aurl);
#endif

assert(_htrie_slot==htrie_shadow_top);

        URL_JoinStr(nurl, L_URL, this->loc, *aurl);
        if(nurl[0]=='\0') {
            goto next;
        }
#ifdef TRACE_PREFETCH
        Trace("  full URL '%s'\n", nurl);
#endif

        fh = first_hash(nurl);
        sh = second_hash(nurl);
#if 0
        Trace("  check object existance in cache\n");
#endif
        ihave = cache_have(fh, sh, nurl, 1, 0);
#if 0
        Trace("  ihave %d\n", ihave);
#endif
        if(ihave>0) {
            goto next;
        }
        /* URL is not empty and it is not hold in cache */
        else
        if(ihave==0) {
            psessp = (sess_t*)sq_get_free();
            if(psessp==NULL) {
                Error("not enough memory for new prefetching session");
                goto skip;
            }

            chk = pthread_mutex_init(&(psessp->busy), NULL);

            MUTEX_LOCK(&sess_lock);
            nhot++;
            MUTEX_UNLOCK(&sess_lock);


#if 1
            MUTEX_LOCK(&stat_lock);
            request_sirial_count++;
            t_req = request_sirial_count;

            issue_prefetch_count++;

            MUTEX_UNLOCK(&stat_lock);
#endif


            /***
             ***
             ***/

            psessp->sid    = t_req;
            psessp->psid   = this->sid;
            psessp->mode   = MODE_SELF;
            psessp->level  = this->level+1;
            psessp->state  = STATE_THINK;

            gettimeofday(&(psessp->accept_time), NULL);

            psessp->reported = 0;
            psessp->reason  = -1;

            psessp->pos     =  0;
            psessp->len     = -1;
            psessp->rcode   = -1;
            psessp->count   = 0;
            psessp->lmd     = -1;
            psessp->expire  = -1;

            psessp->cachable = SESS_CACHABLE;
            psessp->reload   = SESS_NORELOAD;
            psessp->ishit   = SESS_MISS;
            psessp->oid     = -1;

            psessp->cfd     = -1;
            psessp->sfd     = -1;
            psessp->rfd     = -1;


            strcpy(psessp->clientname, "self");

            memset(psessp->loc , 0, sizeof(psessp->loc));
            memset(psessp->reqbuf, 0, sizeof(psessp->reqbuf));
            psessp->reqlen = 0;

            psessp->cver_major = 0;
            psessp->cver_minor = 0;
            psessp->ims = -1;

            DoSetReq(psessp, nurl);
assert(_htrie_slot==htrie_shadow_top);

#if 0
            dump_stringchunk("generated request", psessp->reqbuf);
#endif

#ifdef TRACE_PREFETCH
            Trace("nurl = %4d-%02d %p (#%d) '%s'\n",
                this->sid, nc, psessp, psessp->sid, psessp->loc);
#endif

assert(_htrie_slot==htrie_shadow_top);

            chk = DoThink(psessp);
            if(chk==0 && psessp->state==STATE_QUERY_ADDR) {
                DoFindServer(psessp);
                if(psessp->state==STATE_CONN_SERV) {
#if 0
                    Trace("connect prefetch target '%s'\n", psessp->loc);
#endif
                    DoServerConnect(psessp);
                }

#ifdef TRACE_PREFETCH
                Trace("sess# %d, <self>   method <%s>,URL '%s' version ?\n",
                    psessp->sid, MSG_M_[psessp->method], psessp->loc);
#else
#ifdef TRACE_SESS
                Trace("sess# %d, <self>   method <%s>,URL '%s' version ?\n",
                    psessp->sid, MSG_M_[psessp->method], psessp->loc);
#endif
#endif

#if 0
                Trace("     push to think Q as sess# %d %s\n",
                    psessp->sid, MSG_STATE_[psessp->state]);
#endif
                if(psessp) {
                    chk = push_sess(think_queue, psessp);
                    if(chk) {
                        Error("DoParseAnchor: sess# %d, fail push to think Q",
                            psessp->sid);
                    }
                    psessp = NULL;

#if 0
        MUTEX_LOCK(&think_queue->lock);
        fflush(stderr);
        sq_show(stdout, think_queue);
        fflush(stdout);
        MUTEX_UNLOCK(&think_queue->lock);
#endif

                }
            }
            else {
                DoReleaseSess(psessp);
                psessp = NULL;
            }

assert(_htrie_slot==htrie_shadow_top);
#if 0
            Trace("  ..done\n");
#endif

skip:
            (void)1;    /* dummy for label */
#if 0
            Trace("  skip\n");
#endif

        }
        else {
            /*
            Trace("DoParseAnchor: fail cache_have(), return %d\n", ihave);
            */
        }
next:
assert(_htrie_slot==htrie_shadow_top);
#if 0
        Trace("  next\n");
#endif

        aurl++;
        nc++;
#if 0
        Trace("  ? next\n");
#endif
    }

#ifdef TRACE_PREFETCH
    Trace("DoParseAnchor<%d>: loop end\n");
#endif

    HTML_FreeURLList(urllist);
    FREE(urllist);
    urllist = NULL;

    tags = NULL;
assert(_htrie_slot==htrie_shadow_top);


#ifdef TRACE_PREFETCH
    Trace("DoParseAnchor<%d>: block end\n");
#endif

    goto out;

done:
 assert(_htrie_slot==htrie_shadow_top);

not_found:
    Error("DoParseAnchor: cache was not found #%d [%d:%d] when hit",
        this->sid, this->fhash, this->shash);
    goto out;

out:
 assert(_htrie_slot==htrie_shadow_top);

out_nothing:
 assert(_htrie_slot==htrie_shadow_top);

    return 0;


out_pending:

 assert(_htrie_slot==htrie_shadow_top);
    return 1;

}




/*
 * Handler
 *
 */

void*
Handler(sess_t *sessp, time_t now)
{
    int chk;
    int cv;
    int pending;

    if(sessp==NULL)
        return NULL;

#ifdef TRACE_SCHEDULE
    Trace("Handler<%p> start, sess %p, sess# %d, mode %d, state %s\n",
        pthread_self(),
        sessp, sessp->sid, sessp->mode, MSG_STATE_[sessp->state]);
#endif


    switch(sessp->state) {
    /*
     * like manager
     */
    case STATE_ACCEPT:
    case STATE_RECV_REQ:

        if(sessp->mode==MODE_CLIENT && sessp->cfd>=0) {
#if 0
            Trace("client request (%d) and client fd (%d) is normal\n",
                    sessp->mode, sessp->cfd);
#endif

            if(sessp->reqlen<4) {
                chk = DoReadReqFirst(sessp);
            }
            else
            if(sessp->reqlen > L_REQBUF) {
                Error("requet is too large");
                sessp->reason = R_TOOLONG_URL;
                goto ignore;
            }
            else {
                chk = DoReadReqRest(sessp);
            }

            if(sessp->state==STATE_MESSAGE)
                goto ignore;

            if(chk) {
#if 1
                Error("handler: fail client request parsing");
#endif
                goto fail;
            }
        }
        else {
#if 0
            Trace("self request (%d) or client fd (%d) is too small\n",
                    sessp->mode, sessp->cfd);
#endif
        }

        if(sessp->state!=STATE_THINK) {
            break;
        }

    case STATE_THINK:
        chk = DoThink(sessp);
        if(chk) {
            if(chk==-1) {
                sessp->reason = R_SOME_FATAL_ERROR;
                sessp->state = STATE_MESSAGE;
                goto ignore;
            }

            Error("Handler: fail session dicision");
            goto fail;
        }


        switch(sessp->state) {
        case STATE_REPORT:
            DoReport(sessp);
            DoCloseSess(sessp);
            DoReleaseSess(sessp);
            sessp = NULL;
            goto out;

        case STATE_WAIT_FRIEND:
            break;

        case STATE_QUERY_ADDR:
            DoFindServer(sessp);
            if(sessp->state==STATE_CONN_SERV) {
                DoServerConnect(sessp);
            }

            break;

        case STATE_SEND_CACHE:
    /*
     * like sender
     */
            DoSendCache(sessp);

            if(sessp->state==STATE_QUERY_ADDR) {
#if 0
Trace("sess# %d, change to fetch\n", sessp->sid);
#endif
                goto start_fetch;
            }
            break;

        case STATE_MESSAGE:
            goto ignore;

 /*NOTREACHED*/
            break;

        case STATE_DONE:
        case STATE_CLOSE:
            goto done;

        default:
            Error("Handler: sess# %d, strange state (%d) after DoThink() ",
                sessp->sid, sessp->state);
            goto fail;
        }

        break;


    case STATE_CLOSE:
    case STATE_DONE:
        goto done;

 /*NOTREACHED*/
        break;

    case STATE_WAIT_FRIEND:
        DoCheckEndFriendSess(sessp);
        break;

#if 1
    /*
     * like sender
     */
    case STATE_SEND_CACHE:
        DoSendCache(sessp);

        if(sessp->state==STATE_QUERY_ADDR) {
#if 0
Trace("sess# %d, change to fetch\n", sessp->sid);
#endif
            goto start_fetch;
        }

        break;
#endif

    /*
     * like fetcher
     */
    case STATE_QUERY_ADDR:
start_fetch: (void)1;

        DoFindServer(sessp);
        if(sessp->state==STATE_CONN_SERV) {
            DoServerConnect(sessp);
        }

        break;

    case STATE_WAIT_ADDR:

        chk = hcache_recv_response_addr_direct(sessp->servername,
            &(sessp->serveraddr), sessp->rfd);
        sessp->rfd = -1;
        if(chk) {
#ifdef TRACE_HCACHE
            Trace("fail hcache_recv_response_addr_direct() %d\n", chk);
#endif
            Error("fail hcache_recv_response_addr_direct() %d", chk);

            sessp->reason = R_RESOLVER_ERROR;
            sessp->state = STATE_MESSAGE;
        }
        else {
#ifdef TRACE_HCACHE
            Trace("  got address via hcache_recv_response_addr_direct()\n");
#endif
            chk = hcache_set_addr_incache(sessp->servername, &(sessp->serveraddr));

#if 0
            hcache_list();
#endif

            sessp->state = STATE_CONN_SERV;
        }

        if(sessp->state!=STATE_CONN_SERV) {
            goto ignore;
        }

    case STATE_CONN_SERV:

        DoServerConnect(sessp);
        break;

#if 0
    case STATE_WAIT_CONN_SERV:

        DoWaitServerConnect(sessp);
        break;
#endif

    case STATE_WAIT_CONN_SERV:
    case STATE_SEND_REQUEST:

        DoSendRequest(sessp);
        break;

    case STATE_RECV_RES:

        DoServerReply(sessp);
        break;

    case STATE_RELAY_DIRECT:

        DoRelayDirect(sessp);
        break;


    default:
        Error("Handler: strange state (%d) ", sessp->state);
        goto fail;

    } /* end of state switch */

    if(sessp!=NULL &&
        sessp->state==STATE_MESSAGE) {
        goto ignore;
    }


done:
    if(sessp!=NULL &&
        (sessp->state==STATE_CLOSE || sessp->state==STATE_DONE)) {


        DoCloseSess(sessp);

        MUTEX_LOCK(&stat_lock);
        process_request_count++;
        MUTEX_UNLOCK(&stat_lock);

        chk = MUTEX_LOCK(&config_lock);
        cv = prefetch_flag;
        chk = MUTEX_UNLOCK(&config_lock);

        if(cv &&
            (sessp->level<2 && sessp->rcode>=200 && sessp->rcode<=399) ) {

            pending = DoParseAnchor(sessp);
            if(pending) {
                Trace("Handler: pending sess# %d\n", sessp->sid);
            }
        }
#ifdef TRACE_PREFETCH
        else {
            Trace("Handler: skip parse object content\n");
        }
#endif

        DoReleaseSess(sessp);
        sessp = NULL;

        goto out;
    }


    goto conn;

ignore:
    DoSendMessage(sessp);
    sessp->state = STATE_CLOSE;

    DoCloseSess(sessp);
    DoReleaseSess(sessp);
    sessp = NULL;

    goto out;

fail:
    DoCloseSess(sessp);
    DoReleaseSess(sessp);
    sessp = NULL;

    goto out;

conn:
    if(sessp!=NULL) {
#ifdef TRACE_SCHEDULE
    Trace("Handler<%p> end,   sess %p, sess# %d, mode %d, state %s\n",
        pthread_self(),
        sessp, sessp->sid, sessp->mode, MSG_STATE_[sessp->state]);
#endif

#if 0
        Trace("### A\n");
        MUTEX_LOCK(&think_queue->lock);
        fflush(stderr);
        sq_show(stdout, think_queue);
        fflush(stdout);
        MUTEX_UNLOCK(&think_queue->lock);
#endif

        chk = push_sess(think_queue, sessp);
        if(chk) {
            Error("Handler: sess# %d, fail re-push to think Q", sessp->sid);
        }

        sessp = NULL;

#if 0
        Trace("### B\n");
        MUTEX_LOCK(&think_queue->lock);
        fflush(stderr);
        sq_show(stdout, think_queue);
        fflush(stdout);
        MUTEX_UNLOCK(&think_queue->lock);
#endif

    }

    goto out;

out:
    chk = 0;

#if 0
    Trace("### C\n");
    MUTEX_LOCK(&think_queue->lock);
    fflush(stderr);
    sq_show(stdout, think_queue);
    fflush(stdout);
    MUTEX_UNLOCK(&think_queue->lock);
#endif


    return NULL;
}

inline
int
check_timeout(sess_t *sessp, time_t now)
{
    int ret;
    int idle, elap;

    ret = 0;

    idle = now - sessp->last_action;
    elap = now - sessp->accept_time.tv_sec;

    switch(sessp->state) {
    case STATE_ACCEPT:
    case STATE_RECV_REQ:
#if 0
    Trace("check_timeout: sess# %d, now %d, idle %d, elap %d, reqlen %d\n",
        sessp->sid, now, idle, elap, sessp->reqlen);
#endif
        if(sessp->last_action == sessp->accept_time.tv_sec) {

            if(sessp->reqlen>0) {
#if 0
    Trace("    Is it empty request ?\n");
#endif
            }

            if(idle > RECEPT_TIMEOUT*3) {
                ret = 1;
            }
        }
        else
        if(idle > RECEPT_TIMEOUT)
            ret = 1;
        break;
    case STATE_WAIT_FRIEND:
    case STATE_WAIT_CONN_SERV:
    case STATE_RECV_RES:
        if(idle > FETCH_TIMEOUT)
            ret = 1;
        break;
    default:
        if(idle > ELSE_TIMEOUT)
            ret = 1;
        break;
    }

    if(ret==0) {
        if(elap > SESSION_TOTAL_TIMEOUT) {
            ret = 1;
        }
    }

    return ret;
}



#if 1
#define CHECK {\
    int k;\
    Trace("w_sess_count %d, w_fd_count %d\n", w_sess_count, w_fd_count);\
    if(w_sess_count>0) {\
        Trace("index sess     sid#  state           |cfd   sfd\n");\
        for(k=0;k<w_sess_count;k++) {\
            if(sess_chunk[k]) \
                Trace("%5d %p %5d %-15s |%5d %5d \n",\
                    k, sess_chunk[k],\
                    sess_chunk[k]->sid, MSG_STATE_[sess_chunk[k]->state],\
                    sess_chunk[k]->cfd, sess_chunk[k]->sfd\
                    );\
            else\
                Trace("%5d empty\n", k);\
        }\
    }\
    else {\
        Trace("***no sessions\n");\
    }\
    if(w_fd_count>0) {\
        Trace("\nindex fd    |sess   sid# state\n");\
        for(k=0;k<w_fd_count;k++) {\
            if(bound[k]) \
                Trace("%5d %5d |%p %5d %-15s\n",\
                    k, fdrec[k].fd,\
                    bound[k], bound[k]->sid, MSG_STATE_[bound[k]->state]);\
            else\
                Trace("%5d %5d empty\n", k, fdrec[k].fd);\
        }\
    }\
    else {\
        Trace("***no fds\n");\
    }\
    Trace("= = \n");\
}

#else
#define CHECK   ((void)0)
#endif


void*
Slave(void *dummy)
{
    time_t now;
    int w_sess_max;
    int w_sess_count;
    int w_fd_count;
    int timeout_count;
    sess_t *sess_chunk[SESS_CHUNK_SIZE];
    struct pollfd fdrec[SESS_CHUNK_SIZE*2];
    sess_t *bound[SESS_CHUNK_SIZE*2];
    int i, j;
    int chk;
    int try;
    int touched;
    int same;

#ifdef TRACE_SCHEDULE
    Trace("Slave: <%x> lunched\n",
        pthread_self());
#endif

    w_sess_max = require_chunk_size;

    while(1) {
        timeout_count = 0;
        w_sess_count = 0;
        w_fd_count = 0;

        for(i=0;i<SESS_CHUNK_SIZE;i++) {
            sess_chunk[i] = NULL;
            bound[i] = NULL;
        }

#if 0
        Trace("\nSlave: call sq_pullchunk with %d\n", w_sess_max);
#endif

        i = sq_pullchunk(think_queue, sess_chunk, w_sess_max);
        if(i<=0) {
            continue;
        }

        now = time(NULL);
        w_sess_count = i;

#if 0
        Trace("\nSlave: <%x> got %d session(s)\n",
            pthread_self(), w_sess_count);
#endif
        /*
         *
         */
        for(i=0;i<w_sess_count;i++) {
            if(sess_chunk[i]->last_action>0
                && check_timeout(sess_chunk[i], now)) {
                release_buf(sess_chunk[i]);
                DoTimeoutClose(sess_chunk[i]);
                DoReleaseSess(sess_chunk[i]);
                timeout_count++;

        sess_chunk[i]=NULL;

                continue;
            }

            switch(sess_chunk[i]->state) {
            case STATE_IDLE:
                break;
            case STATE_ACCEPT:
            case STATE_RECV_REQ:
                fdrec[w_fd_count].fd = sess_chunk[i]->cfd;
                fdrec[w_fd_count].events = POLLIN | POLLRDNORM;
                bound[w_fd_count] = sess_chunk[i];
                w_fd_count++;
                break;
            case STATE_WAIT_ADDR:
                fdrec[w_fd_count].fd = sess_chunk[i]->rfd;
                fdrec[w_fd_count].events = POLLIN | POLLRDNORM;
                bound[w_fd_count] = sess_chunk[i];
                w_fd_count++;
                break;
            case STATE_WAIT_CONN_SERV:
                fdrec[w_fd_count].fd = sess_chunk[i]->sfd;
                fdrec[w_fd_count].events = POLLOUT | POLLWRNORM;
                bound[w_fd_count] = sess_chunk[i];
                w_fd_count++;
                break;
            case STATE_RECV_RES:
                fdrec[w_fd_count].fd = sess_chunk[i]->sfd;
/*
*/
                fdrec[w_fd_count].events = POLLIN | POLLRDNORM;
/*
                fdrec[w_fd_count].events = POLLIN | POLLRDNORM
					 	| POLLHUP | POLLPRI | POLLERR;
*/
                bound[w_fd_count] = sess_chunk[i];
                w_fd_count++;
                break;
            case STATE_RELAY_DIRECT:
                fdrec[w_fd_count].fd = sess_chunk[i]->cfd;
                fdrec[w_fd_count].events = POLLIN | POLLRDNORM;
                bound[w_fd_count] = sess_chunk[i];
                w_fd_count++;
                fdrec[w_fd_count].fd = sess_chunk[i]->sfd;
                fdrec[w_fd_count].events = POLLIN | POLLRDNORM;
                bound[w_fd_count] = sess_chunk[i];
                w_fd_count++;
                break;
            case STATE_THINK:
                fdrec[w_fd_count].fd = sess_chunk[i]->cfd;
                fdrec[w_fd_count].events = POLLIN | POLLRDNORM;
                bound[w_fd_count] = sess_chunk[i];
                w_fd_count++;
                break;
            default:
#ifdef TRACE_SCHEDULE
                Trace("Slave: thread %x, sess# %d, mode %c, state strange %s\n",
                    pthread_self(),
                    sess_chunk[i]->sid,
                    sess_chunk[i]->mode==MODE_CLIENT ? 'c': 's',
                    MSG_STATE_[sess_chunk[i]->state]);
#endif
                break;
            }
        }

#ifdef TRACE_SCHEDULE
        Trace("w_sess_count/max %d/%d\n", w_sess_count, w_sess_max);
        Trace("w_fd_count %d\n", w_fd_count);

        Trace("\nbefore ***\n");
        CHECK;
#endif

        if(w_fd_count<1) {
            goto dispatch_by_sess;
        }

try_poll:
        chk = poll(fdrec, w_fd_count, 1000); /* 1000msec = 1sec */

#ifdef TRACE_SCHEDULE
        if(timeout_count) {
            Trace("Slave: <%08x> query/receive/timeout %4d/%4d/%4d\n",
                pthread_self(), w_fd_count, chk, timeout_count);
        }
#endif

        if(chk<0) {
            if(errno==EINTR) {
                goto try_poll;
            }
            Error("fail poll() (%d)", errno);

            for(i=0;i<w_sess_count;i++) {
                if(sess_chunk[i]) {
                    chk = push_sess(think_queue, sess_chunk[i]);

                }
            }
            goto next;
        }
        else
        if(chk==0) {
            /* timeout */
            for(i=0;i<w_sess_count;i++) {
                if(sess_chunk[i])
                    chk = push_sess(think_queue, sess_chunk[i]);
            }
            goto next;
        }


dispatch_by_fd:
        for(i=0;i<w_fd_count;i++) {
            touched = 0;

            /* count other fds is bounded to same session */
            same = 0;
            for(j=i+1;j<w_fd_count;j++) {
                if(bound[j]==bound[i]) {
                    same++;
                }
            }

            if(bound[i]==NULL)
                continue;
            if(
                (bound[i]->state==STATE_WAIT_CONN_SERV
                    && fdrec[i].revents & POLLOUT)
                  ||(bound[i]->state!=STATE_WAIT_CONN_SERV
                    && fdrec[i].revents & POLLIN)
                  ||(bound[i]->state!=STATE_WAIT_CONN_SERV
                    && fdrec[i].revents & POLLHUP)
                ) {
#ifdef TRACE_SCHEDULE
                Trace("  call handler<%p> %d: fd# %d, sess %p, sess# %d, %s\n",
                    pthread_self(), i, fdrec[i].fd,
                    bound[i], bound[i]->sid,
                    MSG_STATE_[bound[i]->state]);
#endif
                Handler(bound[i], now);
                touched = 1;
            }
            else {
                if(same==0) {
                    /* nobody is bounded to same session */
                    chk = push_sess(think_queue, bound[i]);
                }
            }

            /* clear a processed session */
            for(j=0;j<w_sess_count;j++) {
                if(bound[i]==sess_chunk[j]) {
                    sess_chunk[j] = NULL;
                }
            }
            if(touched && same) {
                for(j=i+1;j<w_fd_count;j++) {
                    if(bound[j]==bound[i]) {
                        bound[j] = NULL;
                    }
                }
            }
            bound[i] = NULL;
        }


dispatch_by_sess:

        for(i=0;i<w_sess_count;i++) {
            if(sess_chunk[i]) {
#ifdef TRACE_SCHEDULE
                Trace("  call handler<%p> %d: sess %p, sess# %d, %s\n",
                    pthread_self(), i,
                    sess_chunk[i], sess_chunk[i]->sid,
                    MSG_STATE_[sess_chunk[i]->state]);
#endif
                Handler(sess_chunk[i], now);

                for(j=0;j<w_sess_count;j++) {
                    if(i!=j && sess_chunk[i]==sess_chunk[j]) {
                        sess_chunk[j] = NULL;
                    }
                }
                sess_chunk[i]=NULL;
            }
        }

next:
        (void)0; /* dummy */

    } /* while */

}


void*
Reporter(void *dummy)
{
    int cfd;
    int w;
    int p;

    while(1) {
        AcceptReport_fp(stdout);
        ListSession(stdout);
#if 0
        sim_stat_show_lock(&len_perread_stat, stderr);  /* XXX */
#endif
#if 1
        sim_stat_show_lock(&object_size_stat, stderr);  /* XXX */
        cache_list_entry(stderr); /* XXX */
#endif
        sleep(900);
    }
}

extern sim_rec hres_stat;

void*
Monitor(void *dummy)
{
    char *fmt;
    char outline[STRING_SIZE];
    char elap_str[STRING_SIZE];
/*
    time_t last_print_t;
*/
    struct timeval last_print_t;

    /* time */
    struct timeval last_t, t0, t1, t2, t3, t4, t5, t6;
    int delta_t;
    int t_nhot;
    char mark;

    /* arrival */
    int c_arr, last_arr, delta_arr;
    double r_arr, rmax_arr;

    /* process */
    int c_pro, last_pro, delta_pro;
    double r_pro, rmax_pro;

    int print_count;
    time_t elap;

    int c_rjq;
    int c_err;
    int c_comp;

    unsigned int sig, last_sig;

    int  c_think, c_send, c_fetch, c_prompt;
    int  s_think, s_send, s_fetch, s_prompt;

    last_arr = 0;
    rmax_arr = -1.0;
    last_pro = 0;
    rmax_pro = -1.0;

    last_sig = 0xf0f0;

    print_count = 0;

    gettimeofday(&last_t, NULL);
    while(1) {
        /* interval */
#if 0
        sleep(5);
#else
        sleep(MONITOR_INTERVAL);
#endif

 assert(_htrie_slot==htrie_shadow_top);

        gettimeofday(&t0, NULL);
        MUTEX_LOCK(&stat_lock);
        elap = t0.tv_sec - boot_date;
        c_arr = receive_request_count;
        c_pro = process_request_count;
        c_err = error_reply_count;
        c_rjq = reject_request_count;
        c_comp = cache_compaction;
        MUTEX_UNLOCK(&stat_lock);


        gettimeofday(&t1, NULL);
        MUTEX_LOCK(&sess_lock);
        t_nhot = nhot;
        MUTEX_UNLOCK(&sess_lock);

        gettimeofday(&t2, NULL);
        MUTEX_LOCK(&think_queue->lock);
        c_think = think_queue->count;
        s_think = think_queue->sig;
        MUTEX_UNLOCK(&think_queue->lock);

#if 0
        gettimeofday(&t3, NULL);
        MUTEX_LOCK(&send_queue->lock);
        c_send = send_queue->count;
        s_send = send_queue->sig;
        MUTEX_UNLOCK(&send_queue->lock);

        gettimeofday(&t4, NULL);
        MUTEX_LOCK(&fetch_queue->lock);
        c_fetch = fetch_queue->count;
        s_fetch = fetch_queue->sig;
        MUTEX_UNLOCK(&fetch_queue->lock);

        gettimeofday(&t5, NULL);
        MUTEX_LOCK(&prompt_queue->lock);
        c_prompt = prompt_queue->count;
        s_prompt = prompt_queue->sig;
        MUTEX_UNLOCK(&prompt_queue->lock);
#else
        c_send   = s_send   = 0;
        c_fetch  = s_fetch  = 0;
        c_prompt = s_prompt = 0;
#endif

        gettimeofday(&t6, NULL);

        sig = c_arr | c_pro | t_nhot | s_think | s_send | s_fetch | s_prompt;


#if 0
        if(last_t==0) {
            delta_t = 1;
        }
        else {
            delta_t = t0 - last_t;
        }
#endif
        delta_t = KOTETU_SUB_TIME(t0,last_t);

        delta_arr = c_arr - last_arr;
        r_arr = ((double)delta_arr*1000)/delta_t;
        if(r_arr>rmax_arr) {
            rmax_arr = r_arr;
        }

        delta_pro = c_pro - last_pro;
        r_pro = ((double)delta_pro*1000)/delta_t;
        if(r_pro>rmax_pro) {
            rmax_pro = r_pro;
        }

#if 0
Trace("%d %d %d %d %d %d\n",
    t1-t0, t2-t1, t3-t2, t4-t3, t5-t4, t6-t5);
#endif

#if 0
        if(1)
#endif
        if(t0.tv_sec-last_print_t.tv_sec>=MONITOR_INTERVAL|| sig!=last_sig)
        {
fmt = ": time %d %d %s %c A %2ld %2d/%.1f/%.1f, E %d, P %2ld %2d/%.1f/%.1f, H %2d, Q %2d/%d/%d/%d, C %d, p %.2f, hit %d, miss %d, ratio%% %6.2f, ignore %d";
            if(sig!=last_sig) {
                mark = ':';
            }
            else {
#if 0
s_show_freelist();
#endif
                mark = '*';
            }

            conv_sectoshortstr(elap_str, elap);

            MUTEX_LOCK(&stat_lock);
            sprintf(outline, fmt,
                t0.tv_sec,
                elap, elap_str,
                mark,
                (long)c_arr, delta_arr, r_arr, rmax_arr,
                c_err,
                (long)c_pro, delta_pro, r_pro, rmax_pro,
                t_nhot,
                c_think, c_send, c_fetch, c_prompt,
                c_comp,
                c_arr>0 ?  ((double)c_pro*100.0)/c_arr : -100.0,
                hit_reply_count, miss_reply_count,
                (hit_reply_count+miss_reply_count>0 ?
                    (100.0*hit_reply_count)
                        /(hit_reply_count+miss_reply_count) : -1),
                error_reply_count);
            MUTEX_UNLOCK(&stat_lock);

            LogLine(outline);
            LogSync();
#ifndef LOG_REPORT_CONSOLE
            Trace("%s\n", outline);
#endif

#if 0
            if(print_count%10==0) {
                sim_stat_show(&hres_stat, stderr);
            }
#endif
#if 1
            if(print_count%10==0) {
                sim_stat_show(&object_alloc_stat, stderr);
            }
#endif


#ifdef TRACE_BLOCKS
{
    int i;
    block_cntl_rec *bcr;
    int chk;
    char *p;
    char line[1025];

    p = line;
    for(i=0;i<nblock&&i<1024;i++) {
        bcr = (block_cntl_rec*) cache_block_pos(i);
        if(bcr==NULL) {
            continue;
        }
        chk = MUTEX_TRYLOCK(&bcr->mutex);
        if(chk==0) {
            /* success, empty */
            *p = '.';
            MUTEX_UNLOCK(&bcr->mutex);
        }
        else
        if(chk==EBUSY) {
            /* busy, locked */
            *p = '*';
        }
        else {
            /* strange */
            *p = '?';
        }
        p++;
    }
    *p = '\0';

    Trace("LOCK %s\n", line);
#if 0
    sim_stat_show_lock(&url_first_hash_stat, stderr);
#endif

}
#endif

            last_sig = sig;
#if 0
            last_print_t = t0;
#endif
        memcpy(&last_print_t, &t0, sizeof(struct timeval));
            print_count++;
        }

        /* store last values */
#if 0
        last_t = t0;
#endif
        memcpy(&last_t, &t0, sizeof(struct timeval));
        last_arr = c_arr;
        last_pro = c_pro;

    }

}




static
int
check_mutex(pthread_mutex_t *mx)
{
    int chk;

    chk = MUTEX_TRYLOCK(mx);
    if(chk) {
        if(chk==EBUSY)
            return 0;
        else
            return -chk;
    }
    MUTEX_UNLOCK(mx);
    return 1;
}


static char *_msg_idle  = "IDLE ";
static char *_msg_busy  = "BUSY ";
static char *_msg_err   = "ERROR";

static
int
report_check_mutex(FILE *fp, char *msg, pthread_mutex_t *mx)
{
    int chk;
    char *rep;

    chk = check_mutex(mx);
    if(chk<0)   rep=_msg_err;
    if(chk==0)  rep=_msg_busy;
    if(chk>0)   rep=_msg_idle;

    fprintf(fp, "$$$ %s %s\n", msg, rep);

    return 0;
}

void print_sess(FILE *ofp, void* raw_addr, struct timeval *reftime)
{
    sess_t *self;
    int chk, err;
    char *rep;
    struct timeval reftime_local;
    int elap;

    if(reftime==NULL) {
        gettimeofday(&reftime_local, NULL);
        reftime = &reftime_local;
    }

    self = (sess_t*) raw_addr;

    chk = check_mutex(&(self->busy));
    if(chk<0)   rep=_msg_err;
    if(chk==0)  rep=_msg_busy;
    if(chk>0)   rep=_msg_idle;

    elap = reftime->tv_sec - self->accept_time.tv_sec;

    fprintf(ofp, "%3d %s %c %3d %3d <%s>\n",
        self->sid, rep, self->mode==MODE_CLIENT ? 'c': '-', elap, self->fhash, self->loc);
#if 0
    fprintf(ofp, "%3d ", self->reqlen);
    fprintf(ofp, "<%s> ", self->loc);
    fprintf(ofp, "\n");
#endif
}

static pthread_mutex_t logging_lock = PTHREAD_MUTEX_INITIALIZER;

RETSIGTYPE
Logging_Queues()
{
    FILE *fp;
    int i;
    struct timeval now;
    int t_nhot;

 assert(_htrie_slot==htrie_shadow_top);
    MUTEX_LOCK(&logging_lock);

    gettimeofday(&now, NULL);

    Trace("logggin queues\n");

    fp = fopen("queues.log", "w");
    if(fp==NULL) {
        goto out;
    }

    fprintf(fp, "process %d, thread %x\n\n", getpid(), pthread_self());

        fprintf(fp, " monitor           %x\n", th_monitor);
        fprintf(fp, " listener          %x\n", th_listener);
    fprintf(fp, " manager  %d/%d\n", require_n_handler, N_HANDLER_MAX);
    for(i=0;i<require_n_handler;i++) {
        fprintf(fp, "   %3d             %x\n", i, th_handlers[i]);
    }
    fprintf(fp, "\n");

    MUTEX_LOCK(&sess_lock);
    t_nhot = nhot;
    MUTEX_UNLOCK(&sess_lock);

    fprintf(fp, "hot session %d\n\n", t_nhot);

    fprintf(fp, "== think queue\n");
    sq_show_mapfunc(fp, think_queue,    print_sess, &now);
#if 0
    fprintf(fp, "== send queue\n");
    sq_show_mapfunc(fp, send_queue,     print_sess, &now);
    fprintf(fp, "== fetch queue\n");
    sq_show_mapfunc(fp, fetch_queue,    print_sess, &now);
    fprintf(fp, "== prompt queue\n");
    sq_show_mapfunc(fp, prompt_queue,   print_sess, &now);
#endif


    report_check_mutex(fp, "mutex stat   ", &stat_lock);
    report_check_mutex(fp, "mutex sess   ", &sess_lock);
    report_check_mutex(fp, "mutex config ", &config_lock);
    report_check_mutex(fp, "mutex logging", &logging_lock);


done:
 assert(_htrie_slot==htrie_shadow_top);

    fflush(fp);
    fclose(fp);

out:

    MUTEX_UNLOCK(&logging_lock);
}


/*
 *
 */
RETSIGTYPE
TERM_Trap()
{
    Log("; Catch signal for termination");
    MUTEX_LOCK(&stat_lock);
    catch_termination = 1;
    MUTEX_UNLOCK(&stat_lock);
    exit(127);
}

void*
signal_watcher(void *arg)
{
    int sig;
    int chk;

    while(1) {
 assert(_htrie_slot==htrie_shadow_top);
        chk = sigwait(&handler_sig_mask, &sig);
 assert(_htrie_slot==htrie_shadow_top);
        if(chk) {
            Trace("signal_watcher: chk %d\n", chk);
            continue;
        }

        Trace("signal_watcher: get signal %d\n", sig);

        switch(sig) {
        case SIGPIPE:
            MUTEX_LOCK(&stat_lock);
            session_queue_report_flag = 1;
            MUTEX_UNLOCK(&stat_lock);
            break;
        case SIGUSR2:
            MUTEX_LOCK(&stat_lock);
            session_queue_report_flag = 1;
            MUTEX_UNLOCK(&stat_lock);
            break;
        case SIGHUP:
            LogSync();
            break;
        case SIGINT:
        case SIGTERM:
            MUTEX_LOCK(&stat_lock);
            catch_termination = 1;
            MUTEX_UNLOCK(&stat_lock);
            Log("END");
            LogSync();
            exit(137);
            break;
        case SIGCHLD:
          {
            int stat;
            pid_t pid;

            do {
try_waitpid:
                pid = waitpid((pid_t)-1, &stat, WNOHANG | WUNTRACED);

                if(pid < 0) {
                    if(errno==EINTR) {
                        goto try_waitpid;
                    }
                    printf("error with errno=%d\n", errno);
                    break;
                }
                if (pid > 0) {
                    printf("child %d terminated\n", pid);
                }
            } while(pid>0);

          }
            break;
        default:
            break;
        }
    }

 /*NOTREACHED*/
    return (void*)NULL;
}



/*
 *
 * if fdcap is -1, this routine will set maximum value from getrlimit()
 */
void
ToBeMaximumFDCapacity(int fdcap)
{
    struct rlimit nfile;
    int last_nofile;

#ifdef RLIMIT_NOFILE
#define X   RLIMIT_NOFILE
#else
#define X   RLIMIT_OFILE
#endif

    if(getrlimit(X, &nfile)<0) {
        Error("getrlimit() for current check was fail (%d)", errno);
    }
    else {
        last_nofile = nfile.rlim_cur;
    }

    if(fdcap<0) {
        nfile.rlim_cur = nfile.rlim_max;
    }
    else {
        nfile.rlim_cur = fdcap;
    }

    if(setrlimit(X, &nfile)<0) {
        Error("settrlimit() fail (%d)", errno);
    }

    if(getrlimit(X, &nfile)<0) {
        Error("getrlimit() for verify was fail (%d)", errno);
    }
    else {
        Trace("ToBeMaximumFDCapacity: current to %d (max %d), last %d, specified %d\n",
            nfile.rlim_cur, nfile.rlim_max,
            last_nofile, fdcap);
    }

#undef X

}



int listen_fd;

int
main(int argc, char **argv)
{
    int i;
    int chk;
    int ll;

    pthread_attr_t th_attr_high, th_attr_mid, th_attr_low;
    pthread_attr_t *p_th_attr_high, *p_th_attr_mid, *p_th_attr_low;
    struct sched_param th_param;
    int th_policy_type;

    /***
     *** Initialize
     ***/

    MUTEX_LOCK(&stat_lock);
    boot_date = time(NULL);
    MUTEX_UNLOCK(&stat_lock);

#if 1
    TraceOn();
    {
        extern char log_file[];
        strcpy(log_file, "kotetu.log");
        Trace("*** log_file '%s'\n", log_file);
    }
#else
    TraceOff();
#endif
    InitLogger("kotetuserv");
    Log("START");
    LogSync();

    SetSignalHandler(SIGPIPE, SIG_IGN);

    sigemptyset(&handler_sig_mask);
    sigaddset(&handler_sig_mask, SIGTERM);
    sigaddset(&handler_sig_mask, SIGPIPE);
    pthread_sigmask(SIG_UNBLOCK, &handler_sig_mask, NULL);


    /* Configuration */

    SetGlobalDefaults();
    if(getenv(DEFAULT_CONFIG_ENVNAME)!=NULL) {
        strcpy(config_file, getenv(DEFAULT_CONFIG_ENVNAME));
    }
    if(config_file[0]) {
        ReadConfigFile(config_file);
    }
    ReadCommandlineOptions(argc, argv);

    FixGlobals();
    if(trace_flag) {
        ShowGlobals(stdout);
    }
    if(trace_flag) {
        TraceOn();
    }
    else {
        TraceOff();
    }

#if 1
    Trace("parameters:\n\
    L_URL       %6d\n\
    L_HOST      %6d\n\
    L_BUF       %6d\n\
    L_REQBUF    %6d\n", L_URL, L_HOST, L_BUF, L_REQBUF);
#endif

    ToBeMaximumFDCapacity(-1);

    /* sessions and queues */
#if 0
    InitSession(think_queue_length);
#endif
    InitSession(require_sess_length);
    think_queue_length = require_sess_length;

    sq_init(&X_think_queue, think_queue_length);
    think_queue = &X_think_queue;


    /* misc. statistically */
    sim_stat_alloc_new(&len_perread_stat, "length of per read(2)",
        K(32), server_buffer_stat_count);
    sim_stat_alloc_new(&object_size_stat,   "object size [KB]",
        K(1), object_size_stat_count);

    sim_stat_alloc_new(&rcode_stat,    "session response code",
        1000, rcode_stat_count);

    sim_stat_alloc_new(&url_first_hash_stat,    "first hash value",
        K(2), url_first_hash_stat_count);
    sim_stat_alloc_new(&url_second_hash_stat,   "second hash value",
        K(2), url_second_hash_stat_count);

    sim_stat_alloc_new(&object_alloc_stat,      "object alloc",
        K(10), object_alloc_stat_count);


    /* DNS cache */
    hcache_setup();


    /* object cache */
    cache_memory_size = require_total_memory_size - sess_memory_size;
    chk = cache_alloc_area(cache_memory_size,
            require_num_large_block, require_size_large_block,
            require_size_block, require_minimum_size_line);
    if(chk) {
        Error("Sorry, I exit. not enough memory.");
        exit(4);
    }
    if(nblock<0) {
        Error("Sorry, I exit. the number of block is too small (%d).", nblock);
        exit(7);
    }

    Trace("Memory allocation:\n\
\ttotal        %12lld // %5ldM+%06ld\n\
\tsession      %12lld // %5ldM+%06ld %6.2f%%\n\
\tobject cache %12lld // %5ldM+%06ld %6.2f%%\n",
        (long long)require_total_memory_size,
          (long)dM(require_total_memory_size),
          (long)mM(require_total_memory_size),
        (long long)sess_memory_size,
          (long)dM(sess_memory_size), (long)mM(sess_memory_size),
          100.0*sess_memory_size/require_total_memory_size,
        (long long)cache_memory_size,
          (long)dM(cache_memory_size), (long)mM(cache_memory_size),
          100.0*cache_memory_size/require_total_memory_size);
#if 0
    cache_list_entry(stderr);
#endif
    htrie_shadow_top = _htrie_slot;

    if(nblock<=require_n_handler*2) {
        if(nblock<=require_n_handler) {
            Log("; the number of handlers (%d) is very smaller than the number of cache blocks (%d)", require_n_handler, nblock);
        }
        else {
            Log("; the number of handlers (%d) is smaller than the number of cache blocks (%d)", require_n_handler, nblock);
        }
    }

#if 0
    {
        struct timeval now;
        gettimeofday(&now, NULL);
        client_scramble_key = now.tv_usec;
    }
#endif
#if 1
        client_scramble_key = 0xabba;
#endif


    /***
     *** Thread launching
     ***/

#ifdef DONT_USE_THREAD_ATTR
    p_th_attr_high  = NULL;
    p_th_attr_mid   = NULL;
    p_th_attr_low   = NULL;

#else
    chk = pthread_attr_init(&th_attr_high);
    chk = pthread_attr_init(&th_attr_mid);
    chk = pthread_attr_init(&th_attr_low);
    Trace("ret pthread_attr_init() %d (%d)\n", chk, errno);

    chk = pthread_attr_getschedparam(&th_attr_high, &th_param);
    Trace("default (initialized) priority value %d\n",
        th_param.sched_priority);
    th_param.sched_priority += th_param.sched_priority; /* double */
    chk = pthread_attr_setschedparam(&th_attr_high, &th_param);

    chk = pthread_attr_getschedparam(&th_attr_mid, &th_param);
    th_param.sched_priority = th_param.sched_priority; /* thru */
    chk = pthread_attr_setschedparam(&th_attr_mid, &th_param);

    chk = pthread_attr_getschedparam(&th_attr_low, &th_param);
    th_param.sched_priority = th_param.sched_priority/2; /* half */
    chk = pthread_attr_setschedparam(&th_attr_low, &th_param);

    chk = pthread_attr_getschedpolicy(&th_attr_mid, &th_policy_type);
    Trace("ret pthread_attr_getschedpolicy() %d (%d)\n", chk, errno);
    Trace("default value %d\n", th_policy_type);

#if 1
    th_policy_type = SCHED_FIFO;
    chk = pthread_attr_setschedpolicy(&th_attr_high, th_policy_type);
    th_policy_type = SCHED_RR;
    chk = pthread_attr_setschedpolicy(&th_attr_mid, th_policy_type);
    th_policy_type = SCHED_RR;
    chk = pthread_attr_setschedpolicy(&th_attr_low, th_policy_type);
#endif

    p_th_attr_high  = &th_attr_high;
    p_th_attr_mid   = &th_attr_mid;
    p_th_attr_low   = &th_attr_low;
#endif


    if(monitor_flag) {
        chk = pthread_create(&th_monitor, p_th_attr_mid,
                Monitor, NULL);
#ifdef TRACE_THREADS
        Trace("launch - monitor %d\n", chk);
#endif
    }


    /* boot listener, use maximum value of OS */
    listen_fd = TCP_bind_port(service_portno, -1);
    Trace("listen_fd %d, chk %d\n", listen_fd, chk);
    if(listen_fd<0) {
        Error("service port(%d) is alread use", service_portno);
        exit(4);
    }
#ifdef DO_ACCEPT_LOCK
    chk = pthread_create(&th_listener, p_th_attr_high,
                Listener, (void*)&listen_fd);
#endif
    chk = pthread_create(&th_listener, p_th_attr_high,
                Listener, (void*)&listen_fd);
#ifdef TRACE_THREADS
    Trace("launch - listenter %d\n", listen_fd, chk);
#endif

    ll = require_n_handler;
#ifdef TRACE_THREADS
    Trace("ll %d\n", ll);
#endif

    /* boot handlers */
    for(i=0;i<require_n_handler;i++) {
        chk = pthread_create(&th_handlers[i], p_th_attr_mid,
                Slave, (void*)i);
    }

#ifdef TRACE_THREADS
    Trace("launching time is over\n");
#endif

    MUTEX_LOCK(&stat_lock);
    service_start_date = time(NULL);
    MUTEX_UNLOCK(&stat_lock);


    /***
     ***
     ***/
    pthread_sigmask(SIG_BLOCK, &handler_sig_mask, NULL);
    pthread_create(&th_signalhandler, p_th_attr_low, signal_watcher, NULL);
    pthread_sigmask(SIG_UNBLOCK, &handler_sig_mask, NULL);

    atexit(LogSync);


    MUTEX_LOCK(&stat_lock);
    Trace("initalize take %d sec(s)\n", time(NULL) - boot_date);
    MUTEX_UNLOCK(&stat_lock);

    /***
     ***
     ***/
    /* for child reaping, this thread should be awake at sometime */
    while(1) {
        int t_flag;

 assert(_htrie_slot==htrie_shadow_top);
        MUTEX_LOCK(&stat_lock);
        t_flag = session_queue_report_flag;
        MUTEX_UNLOCK(&stat_lock);

        MUTEX_LOCK(&stat_lock);
        if(catch_termination) {
            Log("END");
            LogSync();
            exit(13);
        }
        MUTEX_UNLOCK(&stat_lock);

        if(t_flag) {
            Logging_Queues();
 assert(_htrie_slot==htrie_shadow_top);

            MUTEX_LOCK(&stat_lock);
            session_queue_report_flag = 0;
            MUTEX_UNLOCK(&stat_lock);
        }
 assert(_htrie_slot==htrie_shadow_top);

        sleep(10);
    }
}

