/*
 * code-name 'KOTETU'
 *
 * proxy_main.c : main body for proxy server.
 *
 *      by k-chinen@is.aist-nara.ac.jp, 1999, 2000
 *
 * $Id$
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sched.h>
#include <pthread.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif
#ifdef HAVE_POLL_H
#include <poll.h>
#include <sys/poll.h>
#endif
#ifdef HAVE_SELECT_H
#include <sys/select.h>
#endif
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <strings.h>
#include <limits.h>
#include <sys/types.h>
#include <time.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <signal.h>
#include <setjmp.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/uio.h>
#include <assert.h>
#include <errno.h>

/* private headers */
#if 1
#include "wcol.h"
#endif
#if 0
#include "range.h"
#include "msg.h"
#include "url.h"
#include "base.h"
#include "info.h"
#endif

#include "socket.h"
#include "sigs.h"
#include "sim_stat.h"
#include "misc.h"
#include "http.h"
#include "cache.h"
#include "sess.h"
#include "squeue.h"
#include "parse.h"

#include "reason.h"

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif
#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif

#ifndef NDEBUG
extern unsigned char *_htrie_slot;
extern unsigned char *htrie_shadow_top;
#endif

#if 0
extern volatile off_t intra_incoming;
extern volatile off_t extra_outgoing;
extern volatile off_t extra_incoming;
extern volatile off_t intra_outgoing;
#endif


static
int
M_IgnoreRequest(sess_t *this)
{
    char tmp[L_BUF];
    int nw;

 assert(_htrie_slot==htrie_shadow_top);

    if(this->cfd<0) {
        return -1;
    }

    sprintf(tmp, "HTTP/1.0 403 ignore request\r\n\
\r\n\
<html>\r\n\
<head>\r\n\
<title>Error Message</title>\r\n\
</head>\r\n\
<body bgcolor=\"#ffffff\">\r\n\
<h1>Ignore Request</h1>\r\n\
\r\n\
<p>\r\n\
Cannot found such object '%s'.\r\n\
Please, check URL and try once more.\r\n\
\r\n\
</html>\r\n\
\r\n", this->loc);

    nw = write(this->cfd, tmp, strlen(tmp));

    if(nw>=0) {
        MUTEX_LOCK(&stat_lock);
        intra_outgoing += (off_t) nw;
        MUTEX_UNLOCK(&stat_lock);
    }

    this->rcode = 403;

    return 0;
}

int
DoSendMessage(sess_t *this)
{
    int nw;
    char tmp[L_BUF];
    char buf[L_BUF];
    int rcode;
    char *smsg, *lmsg;
    int append_req = 0;

 assert(_htrie_slot==htrie_shadow_top);
    Trace("DoSendMessage: sess# %d, reason %d\n", this->sid, this->reason);

    if(this->cfd<0) {
        Trace("DoSendMessage: give up to send message, because cfd is -1.\n");
        return -1;
    }

    switch(this->reason) {
    /*
     * internal errors
     */
    case R_MEMORY_OVERFLOW:
        rcode = 500;
        smsg = "Internal error";
        lmsg  = tmp;
        sprintf(tmp, "Not enough memory\n");
        break;

    case R_LOST_BLOCK:
        rcode = 500;
        smsg = "Internal error";
        lmsg  = tmp;
        sprintf(tmp, "Some memory error\n");
        break;

    /*
     * resolver problems
     */
#if 0
    case R_RESOLVER_NOTFOUND:
#endif
    case R_RESOLVER_DOWN:
        rcode = 500;
        smsg = "Internal Error";
        lmsg = tmp;
        sprintf(tmp, "DNS resolver is down.\n\
Please, notice this message to admin\n");
        break;

    case R_RESOLVER_ERROR:
        rcode = 403;
        smsg = "Ignore Request";
        lmsg  = tmp;
        sprintf(tmp, "Cannot found address of such server '%s'.\n\
Please, check URL and try once more.\n", this->servername);
        break;

    /*
     * client side problems (except accept error)
     */
#if 0
    case R_FAIL_CLIENT_READ:
    case R_FAIL_CLIENT_READ_EMPTY:
        rcode = 403;
        smsg = "Ignore Request";
        lmsg  = tmp;
        sprintf(tmp, "Cannot found address of such server '%s'.\n\
Please, check URL and try once more.\n", this->servername);
        break;
#endif

    /*
     * request or services problems
     */

    case R_IGNORE_URL:
        rcode = 400;
        smsg = "Ignore Request";
        lmsg  = "The requst is not understandable.";
        append_req = 1;
        break;

    case R_TOOLONG_URL:
        rcode = 414;
        smsg  = "Too long URL Error";
        lmsg  = "The URL in the request is too long.";
        append_req = 1;
        break;

    case R_TOOLONG_REQ:
        rcode = 413;
        smsg  = "Too Long Request Error";
        lmsg  = "The request is too long.";
        append_req = 1;
        break;

    case R_UNSUPPORT_METHOD:
    case R_UNSUPPORT_PROTOCOL:
        rcode = 501;
        smsg = "Unsupport Method/Protocol";
        lmsg  = tmp;
        if(this->reason == R_UNSUPPORT_PROTOCOL) {
            sprintf(tmp, "Unsupport protocol.\n");
        }
        else {
            sprintf(tmp, "Unsupport method '%s'.\n", MSG_M_[this->method]);
        }
        break;

    case R_SERVER_NOTFOUND:
        rcode = 403;
        smsg = "Request Error";
        lmsg  = tmp;
        sprintf(tmp, "Server '%s' was not found.\n\
Please, check URL and try once more.\n", this->servername);
        break;

    /*
     * server side problems (except socket error)
     */
    case R_FAIL_SERVER_CONNECT:
        rcode = 403;
        smsg = "Connect Error";
        lmsg  = tmp;
        sprintf(tmp, "Server '%s' was found.\n\
But the connection to the server does not estaiblished.\n\
Sever is down or busy.\n", this->servername);
        break;

    default:
        rcode = 403;
        smsg = "Some Error";
        lmsg  = tmp;
        sprintf(tmp, "Some error was happend '%s'.\n\
Please, ask admin. with reason code %d.\n", this->loc, this->reason);
        break;
    }


if(append_req) {
    sprintf(buf,
"<html>\r\n<head>\r\n<title>KOTETU Error Message</title>\r\n</head>\r\n\
<body bgcolor=\"#ffffff\">\r\n<h1>%s</h1>\r\n\r\n<p>\r\n%s\r\n\
<hr>\r\n\
<pre>\r\n\
%s\
</pre>\r\n\
<hr>date: %d</html>\r\n", smsg, lmsg, this->reqbuf, time(NULL));
}
else {
    sprintf(buf,
"<html>\r\n<head>\r\n<title>KOTETU Error Message</title>\r\n</head>\r\n\
<body bgcolor=\"#ffffff\">\r\n<h1>%s</h1>\r\n\r\n<p>\r\n%s\r\n\
<hr>date: %d</html>\r\n", smsg, lmsg, time(NULL));
}

    nw = HTTP_SendIgnoreMessage(this->cfd, rcode, smsg, buf);
    if(nw>0) {
        MUTEX_LOCK(&stat_lock);
        intra_outgoing += (off_t) nw;
        MUTEX_UNLOCK(&stat_lock);
    }

    this->rcode = rcode;

    return 0;
}



