/*
 * code-name 'KOTETU'
 *
 * proxy_report.c : reporting prcedures for WWW proxy server
 *
 *      by k-chinen@is.aist-nara.ac.jp, 1999
 *
 * $Id$
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif
#ifdef HAVE_POLL_H
#include <poll.h>
#include <sys/poll.h>
#endif
#ifdef HAVE_SELECT_H
#include <sys/select.h>
#endif

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif


#include <strings.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <errno.h>


#include "wcol.h"
#include "socket.h"

#include "sim_stat.h"
#include "misc.h"

#include "http.h"
#include "cache.h"
#include "sess.h"

#include "img/plate01.jpg.c"

#include "img/bw200p01.jpg.c"
#include "img/bw200p02.jpg.c"
#include "img/bw200p03.jpg.c"
#include "img/bw200p04.jpg.c"
#include "img/bw200p05.jpg.c"
#include "img/bw200p06.jpg.c"
#include "img/bw200p07.jpg.c"
#include "img/bw200p08.jpg.c"
#include "img/bw200p09.jpg.c"
#include "img/bw200p10.jpg.c"
#include "img/bw200p20.jpg.c"
#include "img/bw200p30.jpg.c"
#include "img/bw200p40.jpg.c"
#include "img/bw200p50.jpg.c"
#include "img/bw200p60.jpg.c"
#include "img/bw200p70.jpg.c"
#include "img/bw200p80.jpg.c"
#include "img/bw200p90.jpg.c"
#include "img/bw200p100.jpg.c"



/*
 * externals
 */

/* automatic */
extern char config_filename[];
extern int trace_flag;
extern int service_portno;
extern int require_n_session;
extern int require_n_sender;
extern int require_n_fetcher;
extern int require_total_memory_size;
extern int require_num_large_block;
extern int require_size_large_block;
extern int require_size_block;
extern int require_minimum_size_line;

/* static */
extern pid_t    wcol_pid;
extern char     *progname;






/*
 * reqeust
 *      receive = process + ignore
 * reply
 *      hit + miss + error
 *
 */


void
AcceptReport_fp(FILE *ofp)
{
    int meybe=0;

    MUTEX_TRYLOCK(&stat_lock);
    if(errno==EBUSY) {
        meybe=1;
    }

    fprintf(ofp, "\nAcceptReport: (%s) processed %d, recveived %d.\n",
        meybe ? "Actually" : "Meybe",
        process_request_count,
        receive_request_count);
    fprintf(ofp, "\
Hit:    %12d\n\
Miss:   %12d\n\
Ignore: %12d\n",
        hit_reply_count, miss_reply_count, error_reply_count);

    if(!meybe) {
        MUTEX_UNLOCK(&stat_lock);
    }
}

void
AcceptReport_fd(int ofd)
{
    int meybe=0;
    int sum;

    MUTEX_LOCK(&stat_lock);
    if(errno==EBUSY) {
        meybe=1;
    }

    sum = process_request_count + report_request_count
            + ignore_request_count + reject_request_count;

    fdprintf(ofd, "Request\n\
\n\
      processed %12ld %6.2f\n\
      report    %12ld %6.2f\n\
      ignored   %12ld %6.2f\n\
      rejected  %12ld %6.2f\n\
-----------------------------\n\
      Total     %12ld\n\
      received  %12ld\n\
\n",
        process_request_count, sum>0 ? 100.0*process_request_count/sum: 0,
        report_request_count,  sum>0 ? 100.0*report_request_count/sum: 0,
        ignore_request_count,  sum>0 ? 100.0*ignore_request_count/sum: 0,
        reject_request_count,  sum>0 ? 100.0*reject_request_count/sum: 0,
        sum,
        receive_request_count
);

    sum = hit_reply_count + miss_reply_count + error_reply_count;

    fdprintf(ofd, "Reply\n\
\n\
      Hit       %12ld %6.2f\n\
      Miss      %12ld %6.2f\n\
      Error     %12ld %6.2f\n\
-----------------------------\n\
      Total     %12ld\n\
\n",
        hit_reply_count,    sum>0 ? 100.0*hit_reply_count/sum: 0,
        miss_reply_count,   sum>0 ? 100.0*miss_reply_count/sum: 0,
        error_reply_count,  sum>0 ? 100.0*error_reply_count/sum: 0,
        sum
    );

    fdprintf(ofd, "\nhash colision %d\n\n", hash_colision);


    if(!meybe) {
        MUTEX_UNLOCK(&stat_lock);
    }
}


static
int
print_bar(int x, int s)
{
    return 0;
}

static
int
print_text_bar_row(int ofd, char *n, int x, int s)
{
    double dv;
    int v;
    int r;
    int tr;

    r = 0;

    if(s==0) {
        dv = 0.0;
        v = 0;
    }
    else {
        dv = (100.0 * x )/s;
        v = (int) dv;
    }

    tr = fdprintf(ofd, "<tr><th bgcolor=\"#ffcccc\"> %s\
<td align=\"right\"> %d <td align=\"right\"> %6.2f",
        n, x, dv);
    if(tr>0) r += tr;

    if(v==100) {
        tr =  fdprintf(ofd, "<td><img width=\"200\" src=\"/img/bw200p100.jpg\"> 100  ");
    }
    else
    if(v<=0) {
        tr = fdprintf(ofd, "<td> 0  ");
    }
    else
    if(v<=10 || v%10==0) {
        tr = fdprintf(ofd, "<td><img width=\"%d\" src=\"/img/bw200p%02d.jpg\"> %d  ",
            v*2, v, v);
    }
    else {
        tr = fdprintf(ofd,
"<td><img width=\"%d\" src=\"/img/bw200p%02d.jpg\">\
<img width=\"%d\" src=\"/img/bw200p%02d.jpg\"> %d  ",
            (v/10)*20, (v/10)*10, (v%10)*2, v%10, v);
    }
    if(tr>0) r += tr;

    tr = fdprintf(ofd, "\n");
    if(tr>0) r += tr;

    return r;
}


int
report_overview_HTML_fd(int ofd)
{
    int meybe=0;
    int sum;
    int ret;
    int tr;
    time_t now;

    ret = 0;

    MUTEX_LOCK(&stat_lock);
    if(errno==EBUSY) {
        meybe=1;
    }

    now = time(NULL);


    tr = fdprintf(ofd,
"<table border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\n\
<tr bgcolor=\"#ffffcc\"><th bgcolor=\"#ff9999\" rowspan=\"5\">Date\n\
    <th>name<th>epoch time\n\
<tr><th bgcolor=\"#ffcccc\">boot            <td align=\"right\">%d\n\
<tr><th bgcolor=\"#ffcccc\">service start   <td align=\"right\">%d\n\
<tr><th bgcolor=\"#ffcccc\">current         <td align=\"right\">%d\n\
<tr><th bgcolor=\"#ffcccc\">diff            <td align=\"right\">%d<td>%s\n\
\n\
<tr>\n\n",
        boot_date, service_start_date, now, now - service_start_date,
        display_sec(now - service_start_date));
    if(tr>0) ret+=tr;


#if SIZEOF_OFF_T <= SIZEOF_LONG

    tr = fdprintf(ofd,
"<tr bgcolor=\"#ffffcc\"><th bgcolor=\"#ff9999\" rowspan=\"5\">Traffics\n\
    <th>name<th>bytes<th>G/M/K\n\
<tr><th bgcolor=\"#ffcccc\">incoming from extra<td align=\"right\"> %12ld <td>%ldG %ldM %ldK\n\
<tr><th bgcolor=\"#ffcccc\">outgoing to intra<td align=\"right\"> %12ld <td>%ldG %ldM %ldK\n\
<tr><th bgcolor=\"#ffcccc\">incoming from intra<td align=\"right\"> %12ld <td>%ldG %ldM %ldK\n\
<tr><th bgcolor=\"#ffcccc\">outgoing to extra<td align=\"right\"> %12ld <td>%ldG %ldM %ldK\n\
\n\
<tr>\n\n",
     (long)extra_incoming,
        (long)dG(extra_incoming), (long)dM(extra_incoming),
        (long)dK(extra_incoming),
     (long)intra_outgoing,
        (long)dG(intra_outgoing), (long)dM(intra_outgoing),
        (long)dK(intra_outgoing),
     (long)0,
        (long)0,
        (long)0,
        (long)0,
     (long)0,
        (long)0,
        (long)0,
        (long)0
        );

#else

#ifdef HAVE_QUAD_T


    tr = fdprintf(ofd,
"<tr bgcolor=\"#ffffcc\"><th bgcolor=\"#ff9999\" rowspan=\"5\">Traffics\n\
    <th>name<th>bytes<th>G/M/K\n\
<tr><th bgcolor=\"#ffcccc\">incoming from extra<td align=\"right\"> %12qd <td>%qdG %qdM %qdK\n\
<tr><th bgcolor=\"#ffcccc\">outgoing to intra<td align=\"right\"> %12qd <td>%qdG %qdM %qdK\n\
<tr><th bgcolor=\"#ffcccc\">incoming from intra<td align=\"right\"> %12qd <td>%qdG %qdM %qdK\n\
<tr><th bgcolor=\"#ffcccc\">outgoing to extra<td align=\"right\"> %12qd <td>%qdG %qdM %qdK\n\
\n\
<tr>\n\n",
     (quad_t)extra_incoming,
        (quad_t)dG(extra_incoming), (quad_t)dM(extra_incoming),
        (quad_t)dK(extra_incoming),
     (quad_t)intra_outgoing,
        (quad_t)dG(intra_outgoing), (quad_t)dM(intra_outgoing),
        (quad_t)dK(intra_outgoing),
     (quad_t)0,
        (quad_t)0,
        (quad_t)0,
        (quad_t)0,
     (quad_t)0,
        (quad_t)0,
        (quad_t)0,
        (quad_t)0
        );

#else

    tr = fdprintf(ofd,
"<tr bgcolor=\"#ffffcc\"><th bgcolor=\"#ff9999\" rowspan=\"5\">Traffics\n\
    <th>name<th>bytes<th>G/M/K\n\
<tr><th bgcolor=\"#ffcccc\">INTRA incoming*<td align=\"right\"> %12lld\n\
        <td>%lldG %lldM %lldK\n\
<tr><th bgcolor=\"#ffcccc\">EXTRA outgoing*<td align=\"right\"> %12lld\n\
        <td>%lldG %lldM %lldK\n\
<tr><th bgcolor=\"#ffcccc\">EXTRA incoming <td align=\"right\"> %12lld\n\
        <td>%lldG %lldM %lldK\n\
<tr><th bgcolor=\"#ffcccc\">INTRA outgoing <td align=\"right\"> %12lld\n\
        <td>%lldG %lldM %lldK\n\
\n\
<tr>\n\n",
     (long long)0,
        (long long)0,
        (long long)0,
        (long long)0,
     (long long)0,
        (long long)0,
        (long long)0,
        (long long)0,
     (long long)extra_incoming,
        (long long)dG(extra_incoming), (long long)dM(extra_incoming),
        (long long)dK(extra_incoming),
     (long long)intra_outgoing,
        (long long)dG(intra_outgoing), (long long)dM(intra_outgoing),
        (long long)dK(intra_outgoing)
        );

#endif /* HAVE_QUAD_T */

#endif



    tr = fdprintf(ofd,
"<tr bgcolor=\"#ffffcc\"><th bgcolor=\"#ff9999\" rowspan=\"9\"> Requests\n\
    <th>name<th>count<th>rate%<th>graph");
    if(tr>0) ret+=tr;

    sum = process_request_count + report_request_count
            + ignore_request_count + reject_request_count;

    ret += print_text_bar_row(ofd, "processed",    process_request_count, sum);
    ret += print_text_bar_row(ofd, "reported",     report_request_count, sum);
    ret += print_text_bar_row(ofd, "ignored",      ignore_request_count, sum);
    ret += print_text_bar_row(ofd, "rejectd",      reject_request_count, sum);

    tr = fdprintf(ofd,
"<tr> <th bgcolor=\"#ffcccc\"> Total     <td align=\"right\"> %12ld\n\
<tr> <th bgcolor=\"#ccccff\"> received  <td align=\"right\"> %12ld\n\
\n",
        sum,
        receive_request_count);
    if(tr>0) ret+=tr;

    tr = fdprintf(ofd,
"<tr> <th bgcolor=\"#ccccff\"> issued <td align=\"right\"> %12ld\n\
<tr> <th bgcolor=\"#ccccff\"> sirial  <td align=\"right\"> %12ld\n\
<tr>\n",
        issue_prefetch_count, request_sirial_count);
    if(tr>0) ret+=tr;


    tr = fdprintf(ofd, "<tr bgcolor=\"#ffffcc\"> <th bgcolor=\"#ff9999\" rowspan=\"5\"> Replies\n\
    <th>name<th>count<th>rate%<th>graph");
    if(tr>0) ret+=tr;

    sum = hit_reply_count + miss_reply_count + error_reply_count;

    ret += print_text_bar_row(ofd, "HIT",      hit_reply_count, sum);
    ret += print_text_bar_row(ofd, "MISS",     miss_reply_count, sum);
    ret += print_text_bar_row(ofd, "ERROR",    error_reply_count, sum);

    tr = fdprintf(ofd, "\
<tr> <th bgcolor=\"#ffcccc\"> Total     <td align=\"right\"> %12ld\n", sum);
    if(tr>0) ret+=tr;

    tr = fdprintf(ofd, "</table>\n\n");
    if(tr>0) ret+=tr;

    /*
     *
     */
    tr = fdprintf(ofd, "<p>hash colision %d\n\n", hash_colision);
    tr = fdprintf(ofd, "<p>cache compaction %d\n\n", cache_compaction);
    if(tr>0) ret+=tr;

    tr = fdprintf(ofd, "<table>\n\
<tr><th colspan=\"3\" bgcolor=\"#ff9999\">calling of read()\n\
<tr><th>total   <td align=\"right\"> %d <td>\n\
<tr><th>success <td align=\"right\"> %d <td align=\"right\">%.2f%%\n\
<tr><th>fail    <td align=\"right\"> %d <td align=\"right\">%.2f%%\n\
</table>\n",
        read_reply_total,
        read_reply_success,
            (read_reply_total==0.0) ? 0.0 :
                ((double)read_reply_success*100.0)/read_reply_total,
        read_reply_fail,
            (read_reply_total==0.0) ? 0.0 :
                ((double)read_reply_fail*100.0)/read_reply_total
        );
    if(tr>0) ret+=tr;


    /*
     *
     */
    sum = cache_newover_count+cache_newfree_count+cache_newmin_count;
    tr = fdprintf(ofd, "<table>\n\
<tr><th colspan=\"3\" bgcolor=\"#ff9999\">the number of store type\n\
<tr><th>overwrite<td align=\"right\"> %d <td align=\"right\">%.2f%%\n\
<tr><th>free    <td align=\"right\"> %d <td align=\"right\">%.2f%%\n\
<tr><th>minimum frequency<td align=\"right\"> %d <td align=\"right\">%.2f%%\n\
<tr><th>total   <td align=\"right\"> %d <td>\n\
</table>\n",
        cache_newover_count,
            (sum==0) ? 0.0 :
            (double)cache_newover_count*100.0/sum,
        cache_newfree_count,
            (sum==0) ? 0.0 :
            (double)cache_newfree_count*100.0/sum,
        cache_newmin_count,
            (sum==0) ? 0.0 :
            (double)cache_newmin_count*100.0/sum,
        sum
        );
    if(tr>0) ret+=tr;

    tr = fdprintf(ofd, "\n\n");
    if(tr>0) ret+=tr;


    if(!meybe) {
        MUTEX_UNLOCK(&stat_lock);
    }

    return ret;
}



int
ReportProxyStatus_root(sess_t *this)
{
    int w;
    int p;
    time_t now;
    int ret;
    int tr;

#if 0
    Trace("ReportProxyStatus: <root> cfd #%d, path '%s'\n",
        this->cfd, this->serverpath);
#endif

    ret = 0;

    /***
     *** header
     ***/
    tr = fdprintf(this->cfd,
"HTTP/1.0 200 Ok\r\n\
Content-Type: text/html\r\n\
\r\n");
    if(tr>0) ret += tr;


    /***
     *** body
     ***/
    /* preamble */
    tr = fdprintf(this->cfd, "<html>\r\n\
<title>KOTETU, Self Publications</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n\
\n\
<h1>KOTETU, Self Publications</h1>\r\n");
    if(tr>0) ret += tr;

    /* main body */
    tr = fdprintf(this->cfd, "<h2>Report</h2>\n\n");
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "<p><b>Overview</b>\n\
<ul>\n\
    <li> <a href=\"/report/overview\"> overview</a>\n\
</ul>\n\n");
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "<p><b>External</b>\n\
<ul>\n\
    <li> <a href=\"/report/rcode\"> response code</a>\n\
    <li> <a href=\"/report/objsize\"> object size</a>\n\
</ul>\n\n");
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "<p><b>Internal</b>\n\
<ul>\n\
    <li> <a href=\"/report/sess\"></a> sessions (not available)\n\
    <li> <a href=\"/report/cache\"> cache</a>\n\
    <li> <a href=\"/report/centry\"> cache entries</a> (long)\n\
    <li> <a href=\"/report/config\"> config</a>\n\
    <li> <a href=\"/report/fhash\"> first hash</a>\n\
    <li> <a href=\"/report/shash\"> second hash</a>\n\
    <li> <a href=\"/report/rlen\"> read length</a> (very long)\n\
</ul>\n\n");
    if(tr>0) ret += tr;

#if 0
    tr = fdprintf(this->cfd, "<p><b>Others</b>\n\
<ul>\n\
    <li> <a href=\"/report/all\"> all </a>\n\
</ul>\n\n");
    if(tr>0) ret += tr;
#endif

    tr = fdprintf(this->cfd,
"<p>Please use 'Back' and 'Forward' bottons to browse these reporting pages.\n\
Don't use 'Reload' botton.\n\
Graphical page consist of small images.\n\
Since most browser reload images when page reloading,\
you have to wait several seconds if you press 'Reload' button.\n");
    if(tr>0) ret += tr;



    /* postamble */
    now = time(NULL);
    tr = fdprintf(this->cfd, "<hr noshade>Thank you &lt;%d&gt;\r\n", now);
    if(tr>0) ret += tr;
    tr = fdprintf(this->cfd, "</html>\r\n");
    if(tr>0) ret += tr;

#if 1
    Trace(" done...\n");
#endif

    return ret;
}

int
ReportProxyOverview(sess_t *this)
{
    int w;
    int p;
    time_t now;
    int tr;
    int ret;

    ret = 0;

#if 0
    Trace("ReportProxyOverview: cfd #%d, path '%s'\n",
        this->cfd, this->serverpath);
#endif


    /***
     *** header
     ***/
    tr = fdprintf(this->cfd,
"HTTP/1.0 200 Ok\r\n\
Pragma: no-cache\r\n\
Cache-Control: no-cache\r\n\
Content-Type: text/html\r\n\
\r\n");
    if(tr>0) ret += tr;


    /***
     *** body
     ***/

    /* preamble */
    tr = fdprintf(this->cfd,
"<html>\r\n\
<title>KOTETU Report (Overview)</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n");
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd,
"<h1>KOTETU Report (Overview)</h1>\n\n\n");
    if(tr>0) ret += tr;

    ret += report_overview_HTML_fd(this->cfd);

    /* postamble */
    now = time(NULL);
    tr = fdprintf(this->cfd, "<hr noshade>Thank you &lt;%d&gt;\r\n", now);
    if(tr>0) ret += tr;
    tr = fdprintf(this->cfd, "</html>\r\n");
    if(tr>0) ret += tr;

    return ret;
}

int
ReportProxySessions(sess_t *this)
{
    int w;
    int p;
    time_t now;
    int ret;
    int tr;

    ret = 0;

#if 1
    Trace("ReportProxySessions: cfd #%d, path '%s'\n",
        this->cfd, this->serverpath);
#endif


    /***
     *** header
     ***/
    tr = fdprintf(this->cfd,
"HTTP/1.0 200 Ok\r\n\
Content-Type: text/html\r\n\
Cache-Control: no-cache\r\n\
Content-Type: text/html\r\n\
\r\n");
    if(tr>0) ret += tr;


    /***
     *** body
     ***/
    /* preamble */
    tr = fdprintf(this->cfd,
"<html>\r\n\
<title>KOTETU Report (Sessions)</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n");
    if(tr>0) ret += tr;


    tr = fdprintf(this->cfd, "<h1>KOTETU Sessions</h1>\r\n");
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "<listing>\r\n");
    if(tr>0) ret += tr;

    tr = ListSession_fd(this->cfd);
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "</listing>\r\n");
    if(tr>0) ret += tr;


    /* postamble */
    now = time(NULL);
    tr = fdprintf(this->cfd, "<hr noshade>Thank you &lt;%d&gt;\r\n", now);
    if(tr>0) ret += tr;
    tr = fdprintf(this->cfd, "</html>\r\n");
    if(tr>0) ret += tr;


    return ret;
}

int
ReportProxyConfig(sess_t *this)
{
    int w;
    int p;
    time_t now;
    int tr;
    int ret;


    ret = 0;

#if 1
    Trace("ReportProxyStatus: <root> cfd #%d, path '%s'\n",
        this->cfd, this->serverpath);
#endif


    /***
     *** header
     ***/
    tr = fdprintf(this->cfd,
"HTTP/1.0 200 Ok\r\n\
Content-Type: text/html\r\n\
\r\n");
    if(tr>0) ret += tr;


    /***
     *** body
     ***/
    /* preamble */
    tr = fdprintf(this->cfd, "<html>\r\n\
<title>KOTETU Report (Config)</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n");
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "<h1>KOTETU Proxys' Configuration</h1>\r\n");
    if(tr>0) ret += tr;

    /* main body */
    tr = fdprintf(this->cfd, "<listing>\r\n");
    if(tr>0) ret += tr;

    tr = ShowGlobals_fd(this->cfd);
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "</listing>\r\n");
    if(tr>0) ret += tr;


    /* postamble */
    now = time(NULL);
    tr = fdprintf(this->cfd, "<hr noshade>Thank you &lt;%d&gt;\r\n", now);
    if(tr>0) ret += tr;
    tr = fdprintf(this->cfd, "</html>\r\n");
    if(tr>0) ret += tr;

    return ret;
}


int
ReportProxyCache(sess_t *this)
{
    int w;
    int p;
    time_t now;
    int tr;
    int ret;

    ret = 0;

#if 1
    Trace("ReportProxyCache: cfd #%d, path '%s'\n",
        this->cfd, this->serverpath);
#endif



    /***
     *** header
     ***/
    tr = fdprintf(this->cfd,
"HTTP/1.0 200 Ok\r\n\
Pragma: no-cache\r\n\
Cache-Control: no-cache\r\n\
Content-Type: text/html\r\n\
\r\n");
    if(tr>0) ret += tr;


    /***
     *** body
     ***/
    /* preamble */
    tr = fdprintf(this->cfd, "<html>\r\n\
<title>KOTETU Report (Cache Overview)</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n");
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "<h1>KOTETU Status Report</h1>\r\n");
    if(tr>0) ret += tr;


    tr = cache_list_overview_HTML(this->cfd);
    if(tr>0) ret += tr;


    /* postamble */
    now = time(NULL);
    tr = fdprintf(this->cfd, "<hr noshade>Thank you &lt;%d&gt;\r\n", now);
    if(tr>0) ret += tr;
    tr = fdprintf(this->cfd, "</html>\r\n");
    if(tr>0) ret += tr;


    return ret;
}

int
ReportProxyCacheEntry(sess_t *this)
{
    int w;
    int p;
    time_t now;
    int tr;
    int ret;

    ret = 0;

#if 1
    Trace("ReportProxyCacheEntry: cfd #%d, path '%s'\n",
        this->cfd, this->serverpath);
#endif



    /***
     *** header
     ***/
    tr = fdprintf(this->cfd,
"HTTP/1.0 200 Ok\r\n\
Pragma: no-cache\r\n\
Cache-Control: no-cache\r\n\
Content-Type: text/html\r\n\
\r\n");
    if(tr>0) ret += tr;


    /***
     *** body
     ***/
    /* preamble */
    tr = fdprintf(this->cfd, "<html>\r\n\
<title>KOTETU Report (Cache Entiries)</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n");
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "<h1>KOTETU Cache Entries</h1>\r\n");
    if(tr>0) ret += tr;


    tr = fdprintf(this->cfd, "<listing>\r\n");
    if(tr>0) ret += tr;

    tr = cache_list_entry_fd(this->cfd);
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "</listing>\r\n");
    if(tr>0) ret += tr;

    /* postamble */
    now = time(NULL);
    tr = fdprintf(this->cfd, "<hr noshade>Thank you &lt;%d&gt;\r\n", now);
    if(tr>0) ret += tr;
    tr = fdprintf(this->cfd, "</html>\r\n");
    if(tr>0) ret += tr;


    return ret;
}

int
report_one_stat(sess_t *this, sim_rec *rec)
{
    int chk;
    int tr;
    int ret;

    ret = 0;



    /***
     *** header
     ***/
    tr = fdprintf(this->cfd,
"HTTP/1.0 200 Ok\r\n\
Pragma: no-cache\r\n\
Cache-Control: no-cache\r\n\
Content-Type: text/html\r\n\
\r\n");
    if(tr>0) ret += tr;


    chk = MUTEX_LOCK(&rec->busy);

    /***
     *** body
     ***/
    /* preamble */
    tr = fdprintf(this->cfd,
"<html>\r\n\
<title>KOTETU Report (%s)</title>\r\n\
<body bgcolor=\"#ffffff\">\r\n",
    rec->name);
    if(tr>0) ret += tr;

    tr = fdprintf(this->cfd, "<h1>KOTETU Report (%s)</h1>\r\n", rec->name);
    if(tr>0) ret += tr;

    chk = MUTEX_UNLOCK(&rec->busy);

    ret += sim_stat_show_HTML_nolock_fd(rec, this->cfd);


    return ret;
}



int
DoReport(sess_t *this)
{
    char *p;
    int nw;

#if 0
    Trace("DoReport: sess %p, cfd #%d, path '%s'\n",
        this, this->cfd, this->serverpath);
#endif

    nw = 0;

    if(strcmp(this->serverpath, "/")==0) {
        ReportProxyStatus_root(this);
    }
    else
    if(strncmp(this->serverpath, "/img/", 5)==0) {
        p = this->serverpath + 5;
#if 0
        Trace("    image filename '%s'\n", p);
#endif


        if(strcmp(p, "plate01.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_plate01_jpg, IM_plate01_jpg);
        }
        else
        if(strcmp(p, "bw200p100.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p100_jpg, IM_bw200p100_jpg);
        }
        else
        if(strcmp(p, "bw200p01.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p01_jpg, IM_bw200p01_jpg);
        }
        else
        if(strcmp(p, "bw200p02.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p02_jpg, IM_bw200p02_jpg);
        }
        else
        if(strcmp(p, "bw200p03.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p03_jpg, IM_bw200p03_jpg);
        }
        else
        if(strcmp(p, "bw200p04.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p04_jpg, IM_bw200p04_jpg);
        }
        else
        if(strcmp(p, "bw200p05.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p05_jpg, IM_bw200p05_jpg);
        }
        else
        if(strcmp(p, "bw200p06.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p06_jpg, IM_bw200p06_jpg);
        }
        else
        if(strcmp(p, "bw200p07.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p07_jpg, IM_bw200p07_jpg);
        }
        else
        if(strcmp(p, "bw200p08.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p08_jpg, IM_bw200p08_jpg);
        }
        else
        if(strcmp(p, "bw200p09.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p09_jpg, IM_bw200p09_jpg);
        }
        else
        if(strcmp(p, "bw200p10.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p10_jpg, IM_bw200p10_jpg);
        }
        else
        if(strcmp(p, "bw200p20.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p20_jpg, IM_bw200p20_jpg);
        }
        else
        if(strcmp(p, "bw200p30.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p30_jpg, IM_bw200p30_jpg);
        }
        else
        if(strcmp(p, "bw200p40.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p40_jpg, IM_bw200p40_jpg);
        }
        else
        if(strcmp(p, "bw200p50.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p50_jpg, IM_bw200p50_jpg);
        }
        else
        if(strcmp(p, "bw200p60.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p60_jpg, IM_bw200p60_jpg);
        }
        else
        if(strcmp(p, "bw200p70.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p70_jpg, IM_bw200p70_jpg);
        }
        else
        if(strcmp(p, "bw200p80.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p80_jpg, IM_bw200p80_jpg);
        }
        else
        if(strcmp(p, "bw200p90.jpg")==0) {
            nw = HTTP_send_image(this->cfd, "image/jpeg",
                LE_bw200p90_jpg, IM_bw200p90_jpg);
        }

    }
    else
    if(strncmp(this->serverpath, "/report/", 8)==0) {
        p = this->serverpath + 8;
#if 0
        Trace("    sub path '%s'\n", p);
#endif

#if 0
        if(strcmp(p, "all")==0) {
            nw = ReportProxyStatus_graph(this);
        }
        else
#endif
        if(strcmp(p, "overview")==0) {
            nw = ReportProxyOverview(this);
        }
        else
        if(strcmp(p, "objsize")==0) {
            nw = report_one_stat(this, &object_size_stat);
        }
        else
        if(strcmp(p, "rcode")==0) {
            nw = report_one_stat(this, &rcode_stat);
        }
        else
        if(strcmp(p, "fhash")==0) {
            nw = report_one_stat(this, &url_first_hash_stat);
        }
        else
        if(strcmp(p, "shash")==0) {
            nw = report_one_stat(this, &url_second_hash_stat);
        }
        else
        if(strcmp(p, "rlen")==0) {
            nw = report_one_stat(this, &len_perread_stat);
        }
        else
#if 0
        if(strcmp(p, "sess")==0) {
            nw = ReportProxySessions(this);
        }
        else
#endif
        if(strcmp(p, "config")==0) {
            nw = ReportProxyConfig(this);
        }
        else
        if(strcmp(p, "cache")==0) {
            nw = ReportProxyCache(this);
        }
        else
        if(strcmp(p, "centry")==0) {
            nw = ReportProxyCacheEntry(this);
        }
        else
        {
            this->rcode = 403;
            this->state = STATE_MESSAGE;
            return -1;
        }
    }
    else
    {
            this->rcode = 403;
            this->state = STATE_MESSAGE;
            return -1;
    }

    this->rcode = 200;
    this->state = STATE_DONE;

    if(nw>0) {
        MUTEX_LOCK(&stat_lock);
        intra_outgoing += (off_t) nw;
        MUTEX_UNLOCK(&stat_lock);
    }

#if 0
    Trace("DoReport: done\n");
    Trace("    %d bytes\n", nw);
#endif

    return 0;
}

