/*
 * range.h - define data/buffer range and related constats
 *
 *      by k-chinen@is.aist-nara.ac.jp, 1997
 *
 *  $Id$
 *
 */

#ifndef __RANGE_H__
#define __RANGE_H__ /* block for forever(or nest) loop */


/***
 ***
 ***/

#define _KB_CONST_  (1024L)
#define _MB_CONST_  (1024L*1024L)
#define _GB_CONST_  (1024L*1024L*1024L)

#define TOKB(x) ((x)/_KB_CONST_)
#define TOMB(x) ((x)/_MB_CONST_)
#define TOGB(x) ((x)/_GB_CONST_)

#define KB(x)   (x*_KB_CONST_)
#define MB(x)   (x*_MB_CONST_)
#define GB(x)   (x*_GB_CONST_)


#define _HOUR_CONST_    (3600)
#define _DAY_CONST_     (3600*24)

#define HOUR(x)     (x*_HOUR_CONST_)
#define DAY(x)      (x*_DAY_CONST_)




#ifndef STRING_SIZE
#define STRING_SIZE     512
#endif
#ifndef STRING_BLEN
#define STRING_BLEN     (32)
#endif

#ifndef L_URL
#define L_URL           (KB(2))
#endif
#ifndef L_HOST
#define L_HOST          (64)
#endif
#ifndef L_BUF
#define L_BUF           (KB(8))
#endif
#ifndef L_REQBUF
#define L_REQBUF        (KB(4))
#endif


#endif /* __RANGE_H_ */


