/*
 * code-name 'KOTETU'
 *
 * proxy_main.c : main body for proxy server.
 *
 *      by k-chinen@is.aist-nara.ac.jp, 1999
 *
 * $Id$
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STROPTS_H
#include <stropts.h>
#endif
#ifdef HAVE_POLL_H
#include <poll.h>
#include <sys/poll.h>
#endif
#ifdef HAVE_SELECT_H
#include <sys/select.h>
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include <strings.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <errno.h>


#include "wcol.h"
#include "socket.h"
#include "misc.h"

#include "cache.h"
#include "sim_stat.h"

#include "http.h"
#include "sess.h"
#include "squeue.h"


pthread_mutex_t sess_lock = PTHREAD_MUTEX_INITIALIZER;
size_t  sess_size = 0;
int     nhot = 0;

off_t sess_memory_size=0;

extern unsigned char *htrie_shadow_top;

 /*12345678901234567890*/
char *MSG_STATE_[]={
  "IDLE",
  "ACCEPT",
  "RECV_REQ",
  "THINK",
  "REPORT",
  "WAIT_FRIEND",
  "SEND_CACHE",
  "QUERY_ADDR",
  "WAIT_ADDR",
  "CONN_SERV",
  "WAIT_CONN_SERV",
  "SEND_REQUEST",
  "RECV_RES",
  "BODYPARSE",
  "CLOSE",
  "DONE",
  "MESSAGE",
  "RELAY_DIRECT",
};


int
ListSession(FILE *ofp)
{
    return 0;
}

int
ListSession_fd(int ofd)
{
    return 0;
}


int
DoHalfClientCloseSess(sess_t *this)
{
    if(this->cfd>=0) {
        shutdown(this->cfd, 2);
        close(this->cfd);
        this->cfd   = -1;
    }

    return 0;
}

int
DoHalfServerCloseSess(sess_t *this)
{
    if(this->sfd>=0) {
        shutdown(this->sfd, 2);
        close(this->sfd);
        this->sfd   = -1;
    }

    return 0;
}


int
ReportSess(sess_t *this, char *msg)
{
    char line[L_BUF];
    struct timeval cur_time;

#if 0
Trace("ReportSess:\n");
#endif
    gettimeofday(&cur_time, NULL);

    if(this==NULL) {
        return -1;
    }

    if(this->reported) {
#if 0
Trace("session #%d %p is reported already\n", this->sid, this);
#endif
        return 1;
    }


    if(strlen(msg)>L_BUF/4) {
        msg = "VERY-LONG";
    }

#if 1
    /* id time client cache server */
    /*
    id
 0      session-id
 1      parent session-id
    time
 2      start
 3      end
    category
 4      mode
 5      msg     FETCH/TIMEOUT
 6  :
    client
 7      client-id
        request
 8          method
 9          URL
10          version
11          cachable?
12          reload?
13          ims
14      hit/miss
15      reply code
16      read
17      write
18  :
    cache
19      object-id
20      lmd
21      expire
22      length
23      count
24  :
    server
25      version
26      read
27      write
28  :
    inner
29      state
30      reason
    */


    sprintf(line, "%d %d %d.%06d %d.%06d %c %s : %s %s %s %d.%d %c%c %d %s %d %ld %ld : %d %d %d %ld %d : %d.%d %ld %ld : %s %d",
        this->sid,
        this->psid,
        cur_time.tv_sec, cur_time.tv_usec,
        this->accept_time.tv_sec, this->accept_time.tv_usec,
        this->mode==MODE_CLIENT ? 'c' : 's',
        msg,

        this->clientname,
        MSG_M_[this->method],
        (this->loc ? ( *(this->loc) ? this->loc : "EMPTY") : "NONE"),
        this->cver_major, this->cver_minor,
        (this->cachable==SESS_CACHABLE ? 'c' : 'N'),
        (this->reload==SESS_RELOAD ? 'R' : '-'),
        this->ims,
        (this->ishit==SESS_HIT ? "HIT" : "MISS"),
        this->rcode,
        (long)0,
        (long)this->pos,

        this->oid,
        this->lmd,
        this->expire,
        (long)this->len,
        this->count,

        this->sver_major, this->sver_minor,
        (long)0,
        (long)0,

        MSG_STATE_[this->state],
        this->state==STATE_WAIT_FRIEND ? this->reason2 : this->reason
        );

#else

    sprintf(line, "%3d %3d %s %d.%06d %d.%06d %c %s %d %s %c%c %5ld %5ld %d : %s %s : %3d : %s %d",
        this->sid,
        this->psid,
        this->clientname,
        cur_time.tv_sec, cur_time.tv_usec,
        this->accept_time.tv_sec, this->accept_time.tv_usec,
        this->mode==MODE_CLIENT ? 'c' : 's',
        msg,
        this->rcode,
        (this->ishit==SESS_HIT ? "HIT " : "MISS"),
        (this->cachable==SESS_CACHABLE ? 'c' : 'N'),
        (this->reload==SESS_RELOAD ? 'R' : '-'),
        (long)this->pos, (long)this->len,
        this->count,
        MSG_M_[this->method],
        (this->loc ? ( *(this->loc) ? this->loc : "EMPTY") : "NONE"),
        this->oid,
        MSG_STATE_[this->state],
        this->state==STATE_WAIT_FRIEND ? this->reason2 : this->reason
        );

#endif


    LogLine(line);

#ifdef TRACE_SESS
    if(this->state==STATE_ACCEPT ||
        this->state==STATE_RECV_REQ) {
        Trace(": read request length %d\n", this->reqlen);
        dump_stringsegment("req. ", this->reqbuf, this->reqlen);
    }
#endif

    this->reported = 1;

    return 0;
}


static
int
_DoCloseSess(sess_t *this)
{
    if(this->cfd>=0) {
        shutdown(this->cfd, 2);
        close(this->cfd);
        this->cfd   = -1;
    }
    if(this->sfd>=0) {
        shutdown(this->sfd, 2);
        close(this->sfd);
        this->sfd   = -1;
    }
    if(this->rfd>=0) {
        shutdown(this->rfd, 2);
        close(this->rfd);
        this->rfd   = -1;
    }

    return 0;
}

int
DoCloseSess(sess_t *this)
{
    ReportSess(this, "FETCH");

    sim_stat_add_value(&rcode_stat, this->rcode);

    return _DoCloseSess(this);
}


int
DoTimeoutClose(sess_t *this)
{
    ReportSess(this, "TIMEOUT");

    sim_stat_add_value(&rcode_stat, 0);

#if 1
    MUTEX_LOCK(&stat_lock);
    error_reply_count++;
    MUTEX_UNLOCK(&stat_lock);
#endif

    return _DoCloseSess(this);
}

int
DoClearSess(sess_t *this)
{
    this->reported = 0;
    this->pos = 0;
    this->len = -1;

    this->sid   = -1;
    this->rcode = -1;

    this->state = STATE_IDLE;
    this->reason    = -1;
    this->reason2   = -1;

    this->last_action = 0;

    return 0;
}

int
DoReleaseSess(sess_t *this)
{
#ifdef TRACE_SESS
    Trace("sess# %d, released, addr %p\n", this->sid, this);
#endif
    DoClearSess(this);
    sq_be_free(this);

    MUTEX_LOCK(&sess_lock);
    nhot--;
    MUTEX_UNLOCK(&sess_lock);

    return 0;
}




/* forward definitions for sq_heap.c */

void sq_show_freelist();
off_t sq_alloc_list(int n);
sess_t* sq_get_free();
int sq_be_free(sess_t*);



int
InitSession(int h)
{
    sess_size = sizeof(sess_t);
    sess_memory_size = sq_alloc_list(h);

    return 0;
}

