/*
 * code-name 'KOTETU'
 *
 * sess.h: definition for sessions
 *
 *      by k-chinen@is.aist-nara.ac.jp, 1999
 *
 * $Id$
 */

#ifndef _SESS_H_
#define _SESS_H_


#ifndef N_SESS_MAX
#define N_SESS_MAX          (128000)
#endif

#ifndef N_HANDLER_MAX
#define N_HANDLER_MAX       (128)
#endif

#define STATE_IDLE              (0)
#define STATE_ACCEPT            (1)
#define STATE_RECV_REQ          (2)
#define STATE_THINK             (3)
#define STATE_REPORT            (4)
#define STATE_WAIT_FRIEND       (5)
#define STATE_SEND_CACHE        (6)
#define STATE_QUERY_ADDR        (7)
#define STATE_WAIT_ADDR         (8)
#define STATE_CONN_SERV         (9)
#define STATE_WAIT_CONN_SERV    (10)
#define STATE_SEND_REQUEST      (11)
#define STATE_RECV_RES          (12)
#define STATE_BODYPARSE         (13)
#define STATE_CLOSE             (14)
#define STATE_DONE              (15)
#define STATE_MESSAGE           (16)
#define STATE_RELAY_DIRECT      (17)

#define SESS_MISS               (0)
#define SESS_HIT                (1)

#define SESS_UNCACHABLE         (0)
#define SESS_CACHABLE           (1)

#define SESS_RELOAD             (7)
#define SESS_NORELOAD           (8)

#define MODE_CLIENT             (1)
#define MODE_SELF               (2)

#ifndef SESSION_TOTAL_TIMEOUT
#define SESSION_TOTAL_TIMEOUT   (300)
#endif
#ifndef RECEPT_TIMEOUT
#define RECEPT_TIMEOUT          (10)
#endif
#ifndef SEND_TIMEOUT
#define SEND_TIMEOUT            (30)
#endif
#ifndef FETCH_TIMEOUT
#define FETCH_TIMEOUT           (120)
#endif
#ifndef ELSE_TIMEOUT
#define ELSE_TIMEOUT            (60)
#endif


#ifndef SESS_CHUNK_SIZE
#define SESS_CHUNK_SIZE (512)
#endif /* SESS_CHUNK_SIZE */


typedef struct _session {
    pthread_mutex_t busy;
    struct _session *prev, *next;

    int  sid;
    int  psid;
    int  mode;
    int  level;
    int  state;
    int  reason;
    int  reason2;

    struct timeval accept_time;

    time_t last_action;
    int  reported;

    int  method;
    int  rcode;                     /* response code */
    int  count;
    int  cver_major, cver_minor;

    int  oid;
    int  fhash;
    int  shash;
    char loc[L_URL];

    int  sfd;   /* http server */
    int  cfd;   /* http client */
    int  rfd;   /* hostname resolver */

    char clientname[L_HOST];

    char servername[L_HOST];
    int  serverport;
    char serverpath[L_URL];

    int  qfd;
    struct sockaddr_in serveraddr;
    int  sver_major, sver_minor;

    char reqbuf[L_REQBUF];
    off_t reqlen;
    time_t ims;

    int cachable;
    int reload;
    int ishit;

    char *buf;
    off_t pos;
    off_t len;
    time_t lmd;
    time_t expire;
    off_t clen;

    void *follow;
} sess_t;

typedef struct {
    int sid;
    char loc[L_URL];
} prompt_t;


extern pthread_mutex_t sess_lock;
extern size_t sess_size;
extern int nhot;

extern sim_rec rcode_stat;
extern sim_rec len_perread_stat;
extern sim_rec object_size_stat;
extern sim_rec url_first_hash_stat;
extern sim_rec url_second_hash_stat;


extern pthread_mutex_t stat_lock;

extern time_t boot_date;
extern time_t service_start_date;

extern volatile long long request_sirial_count;
extern volatile int receive_request_count;
extern volatile int process_request_count;
extern volatile int issue_prefetch_count;
extern volatile int report_request_count;
extern volatile int reject_request_count;
extern volatile int ignore_request_count;

extern volatile int send_reply_count;
extern volatile int hit_reply_count;
extern volatile int miss_reply_count;
extern volatile int error_reply_count;

extern volatile int hash_colision;
extern volatile int cache_compaction;

extern int read_reply_total;
extern int read_reply_success;
extern int read_reply_fail;

extern int cache_newover_count;
extern int cache_newfree_count;
extern int cache_newmin_count;


extern volatile off_t intra_incoming;
extern volatile off_t extra_outgoing;
extern volatile off_t extra_incoming;
extern volatile off_t intra_outgoing;


extern char *MSG_STATE_[];





#endif /* _SESS_H_ */
