/*
 *  KOTETU: signals procedures
 *      by k-chinen@is.aist-nara.ac.jp, 1995, 1996
 *
 *  $Id: sigs.c,v 1.2 1996/12/01 20:36:18 k-chinen Exp k-chinen $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#include <sys/uio.h>
#include <sys/socket.h>
#include <signal.h>
#include <setjmp.h>
#include <fcntl.h>
#include <limits.h>
#include <time.h>
#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#endif

#include <errno.h>

#include "wcol.h"
#include "sigs.h"

#if 0
#include "request.h"
#include "ipc.h"

#endif


volatile sig_atomic_t pipe_broken;
volatile sig_atomic_t catch_termination;


void SetSignalHandler(int signo, RETSIGTYPE (*handler)(int))
{
#ifdef HAVE_SIGACTION
    struct sigaction act, oact;

    act.sa_handler = handler;
    sigemptyset(&act.sa_mask);

    act.sa_flags = 0;

#if 0

#ifdef SA_RESTART
    act.sa_flags |= SA_RESTART;
#else
#ifdef SV_INTERRUPT
    act.sa_flags |= SV_INTERRUPT;
#endif
#endif

#else

    if(signo == SIGALRM) {
#ifdef SV_INTERRUPT
        act.sa_flags |= SV_INTERRUPT;
#endif
    }
    else {
#ifdef SA_RESTART
        act.sa_flags |= SA_RESTART;
#endif
    }

#endif

    sigaction(signo, &act, &oact);

#else
    /* no sigaction() */
    signal(signo, handler);

#endif /* HAVE_SIGACTION */
}




/*
 *
 */
RETSIGTYPE PipeErrorHandler()
{
    Trace("*** PIPE pipe was broken\n");

    pipe_broken=1;

    return;
}



/*
 *
 */
RETSIGTYPE ReleseChild()
{
    pid_t pid;

#ifdef HAVE_WAIT3

#ifdef HAVE_SYS_WAIT_H      /* like POSIX */
    int status;
#else
    union wait status;
#endif

    while((pid = wait3(&status, WNOHANG | WUNTRACED,
        (struct rusage*)NULL)) > 0 ) {

        DLog("INFO chlid %d (unknown*) die.", pid);
    }

#else /* HAVE_WAIT3 */

#ifdef HAVE_SYS_WAIT_H      /* like POSIX */
    while((pid = wait((int*) NULL)) >= 0 ) {
        DLog("INFO chlid %d (unknown*) die.", pid);
    }
#else
    while((pid = wait((union wait*) NULL)) >= 0 ) {
        DLog("INFO chlid %d (unknown*) die.", pid);
    }
#endif

#endif /* HAVE_WAIT3 */
}



/*
 *
 */
RETSIGTYPE ExitProgram()
{
    Log("; Catch signal for exit. goodbye !");
    exit(KOTETU_EXIT_NORMAL);
}



/*
 *
 */
RETSIGTYPE HookTERM()
{
    Log("; Catch signal for termination");
    catch_termination = 1;
}



/*
 *
 */
RETSIGTYPE DoNothing()
{
}



