/*
 *  KOTETU: signals (POSIX like) procedures
 *      by k-chinen@is.aist-nara.ac.jp, 1995
 *
 *  $Id: sigs.h,v 1.2 1996/12/01 20:36:12 k-chinen Exp k-chinen $
 */


#ifndef KOTETU_SIGS_H
#define KOTETU_SIGS_H

#ifdef HAVE_SIGLONGJMP
#define SIGLONGJMP(x,y)     siglongjmp(x,y)
#else
#define SIGLONGJMP(x,y)     longjmp(x,y)
#endif

#ifdef HAVE_SIGSETJMP
#define SIGSETJMP(x,y)      sigsetjmp(x, y)
#else
#define SIGSETJMP(x,y)      setjmp(x)
#endif

#ifndef HAVE_SIG_ATOMIC_T
typedef int sig_atomic_t;
#endif

#ifndef HAVE_SIGJMP_BUF
typedef jmp_buf sigjmp_buf;
#endif


RETSIGTYPE PipeErrorHandler ();
RETSIGTYPE ReleseChild ();
RETSIGTYPE ExitProgram ();
RETSIGTYPE HookTERM();
RETSIGTYPE DoNothing ();

extern volatile sig_atomic_t pipe_broken;
extern volatile sig_atomic_t catch_termination;


#endif /* KOTETU_SIGS_H */

