/*
 * simple stat routines
 *          by k-chinen@is.aist-nara.ac.jp, 1999
 *
 * $Id$
 */


#define SIM_REC_NAMELEN     (64)


typedef struct {
    pthread_mutex_t busy;
    char name[SIM_REC_NAMELEN];
    long max;
    long count;
    long *hcount;
    long igcount;
    long vsum;
} sim_rec;

int sim_stat_clear(sim_rec *srec);
int sim_stat_alloc_new(sim_rec *addr, char *name, int sz, long *ar);
sim_rec* sim_stat_new(char *name, int sz);

int sim_stat_show(sim_rec *rec, FILE *fp);
int sim_stat_show_lock(sim_rec *rec, FILE *fp);
int sim_stat_show_lock_fd(sim_rec *rec, int ofd);
int sim_stat_show_HTML_nolock_fd(sim_rec *rec, int ofd);
int sim_stat_show_skip_lock_fd(sim_rec *rec, int ofd, int sk);
int sim_stat_show_short(sim_rec *rec, FILE *fp);

int sim_stat_reset(sim_rec *rec);
int sim_stat_add_value(sim_rec *rec, long cv);


