/*
 *  KOTETU: socket(TCP/UDP) procedures.
 *      by k-chinen@is.aist-nara.ac.jp, 1994, 1995, 1996
 *
 *  $Id: socket.c,v 1.1 1996/11/24 14:50:10 k-chinen Exp k-chinen $
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#ifdef HAVE_POLL_H
/*
#include <stropts.h>
*/
#include <poll.h>
#endif
#include <time.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <errno.h>

#include "wcol.h"
#include "hname.h"
#include "accept.h"
#include "socket.h"

#include "fds.h"


#define _TRACE_LOCK


int
bind_listen_port(int type, int portno, int listen_queue_length)
{
    int netd;
    struct sockaddr_in addr;
    int flag;

    if((netd=socket(AF_INET, type, 0))<0) {
        Error("bind_listen_port: Cannot crate socket (%d)", errno);
        return -1;
    }

    flag = 1;
    if(setsockopt(netd, SOL_SOCKET, SO_REUSEADDR,
      (char *) &flag, sizeof(flag)) < 0) {
        Error("bind_listen_port: Cannot set REUSEADDR (%d)", errno);
        return -1;
    }

    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_port = htons(portno);
    addr.sin_addr.s_addr = INADDR_ANY;
    if( bind(netd, (struct sockaddr*)&addr, sizeof(addr)) < 0 ) {
        Error("bind_listen_port: bind() fail (%d). type %d, port #%d", errno, type, portno);
        return -1;
    }

    if(type==SOCK_STREAM) {
        if(listen(netd, listen_queue_length)<0 ) {
            Error("bind_listen_port: listen() fail (%d).", errno);
            return -1;
        }
    }

    return netd;
}


#ifdef USE_BSD_LOCK

int
lock_port(int pfd)
{
    int e;

lock_try:
    if(e = flock(pfd, LOCK_EX)) {
        if(errno==EINTR)
            goto lock_try;
        else {
            Error("lock_port: fail to flock() fd# %d (%d)", pfd, errno);
        }
    }
    else {
        Trace("lock_port: sucess lock fd# %d\n", pfd);
    }
    return e;
}

int
unlock_port(int pfd)
{
    int e;

unlock_try:
    if(e = flock(pfd, LOCK_UN)) {
        if(errno==EINTR)
            goto unlock_try;
        else {
            Error("unlock_port: fail to flock() fd# %d (%d)", pfd, errno);
        }
    }
    else {
        Trace("unlock_port: sucess unlock fd# %d\n", pfd);
    }

    return e;
}

#else /* USE_BSD_LOCK */


int
lock_port(int pfd)
{
    int e;
    struct flock cnt;

    cnt.l_type      = F_WRLCK;
    cnt.l_start     = 0;
    cnt.l_whence    = SEEK_SET;
    cnt.l_len       = 0;

    if((e = fcntl(pfd, F_SETLK, &cnt)) < 0) {
#ifdef TRACE_LOCK
        Trace("lock-fail(%d)\n", errno);
#endif
    }
    else {
#ifdef TRACE_LOCK
        Trace("lock ");
#endif
    }

    return e;
}

int
unlock_port(int pfd)
{
    int e;
    struct flock cnt;

    cnt.l_type      = F_UNLCK;
    cnt.l_start     = 0;
    cnt.l_whence    = SEEK_SET;
    cnt.l_len       = 0;

    if((e = fcntl(pfd, F_SETLK, &cnt)) < 0) {
#ifdef TRACE_LOCK
        Trace("unlock-fail(%d)\n", errno);
#endif
    }
    else {
#ifdef TRACE_LOCK
        Trace("unlock\n");
#endif
    }

    return e;
}



#endif /* USE_BSD_LOCK */



/*
 * isreadable - check specified FD is readable or not.
 *      if sec<0        wait with blocking
 *
 *
 * return:
 *      1   readable
 *      0   not readable
 *     -1   error
 *
 */

#ifdef HAVE_SELECT

int
isreadable_via_select(int fd, int sec, int usec)
{
    fdset_t fdset, rfdset;
    struct timeval timeout;
    struct timeval *ptimeout;
    int chk;

    FD_ZERO(&fdset);
    FD_SET(fd, &fdset);

    if(sec<0) {
        ptimeout = NULL;
    }
    else {
        ptimeout = &timeout;

        timeout.tv_sec  =  sec;
        if(usec<0) {
            timeout.tv_usec = 0;
        }
        else {
            timeout.tv_usec = usec;
        }
    }

retry:
    rfdset = fdset;
    chk = select(fd+1, &rfdset, NULL, NULL, ptimeout);

#if 0
    dump_fdset(fd+1, &fdset, &rfdset, NULL, NULL);
#endif
    if(chk<0) {
        if(errno==EINTR) {
            goto retry;
        }
        else {
            Error(" #isreadable:fd# %d, errno %d# ", fd, errno);
            return -1;
        }
    }

    if(FD_ISSET(fd, &rfdset)) {
#if 0
        Trace("readable ");
#endif
        return 1;
    }
    else {
#if 0
        Trace("unreadable ");
#endif
        return 0;
    }
}

#endif


#ifdef HAVE_POLL

/*
 *
 * return
 *      1   readable
 *      0   not readable
 *      -1  error
 *
 */
int
isreadable_via_poll(int fd, int sec, int usec)
{
    struct pollfd fds;
    int wtime;
    int chk;

    if(sec==0) {
        wtime   = 0;
    }
    else
    if(sec <= -1) {
        wtime   = -1;
    }
    else {
        wtime   = sec*1000000+usec;
    }
    fds.fd      = fd;
    fds.events  = POLLIN | POLLRDNORM;

try_poll:
#if 0
    Trace("call poll() with fd# %d timeout %d for read\n",
        fd, wtime);
#endif
    chk = poll(&fds, 1, wtime);
#if 0
    Trace("read poll() fd# %d returns %d\n", fd, chk);
#endif
    /* error */
    if(chk<0) {
        if(errno==EINTR) {
            goto try_poll;
        }
        if(errno==EINPROGRESS) {
#if 0
            Trace("inprogress...\n");
#endif
            return 0;
        }
        Error("fail read poll() for fd# %d (%d)", fd, errno);

        return -1;
    }
    /* no error and no event */
    if(chk==0) {
        return 0;
    }
    else {
#if 0
        Trace("read poll result, fd# %d, fd revents %#x\n",
            fd, fds.revents);
#endif
        if((fds.revents|POLLIN) || (fds.revents|POLLRDNORM)) {
            return 1;
        }
        if((fds.revents|POLLERR) || (fds.revents|POLLHUP)
          || (fds.revents|POLLNVAL)) {
            return -1;
        }

        return 0;
    }

    /*NOTREACHED*/
    return 0;
}

int
iswritable_via_poll(int fd, int sec, int usec)
{
    struct pollfd fds;
    int wtime;
    int chk;

    if(sec==0) {
        wtime   = 0;
    }
    else
    if(sec <= -1) {
        wtime   = -1;
    }
    else {
        wtime   = sec*1000000+usec;
    }
    fds.fd      = fd;
    fds.events  = POLLOUT;

try_poll:
#if 0
    Trace("call poll() with fd %d timeout %d for write\n",
        fd, wtime);
#endif
    chk = poll(&fds, 1, wtime);
#if 0
    Trace("write poll() returns %d\n", chk);
#endif
    /* error */
    if(chk<0) {
        if(errno==EINTR) {
            goto try_poll;
        }
        if(errno==EINPROGRESS) {
#if 0
            Trace("inprogress...\n");
#endif
            return 0;
        }
        Error("fail write poll() for fd# %d (%d)", fd, errno);

        return -1;
    }
    /* no error and no event */
    if(chk==0) {
        return 0;
    }
    else {
#if 0
        Trace("write poll result, fd revents %#x\n", fds.revents);
#endif
        if(fds.revents|POLLOUT) {
            return 1;
        }
        if((fds.revents|POLLERR) || (fds.revents|POLLHUP)
          || (fds.revents|POLLNVAL)) {
            return -1;
        }

        return 0;
    }

    /*NOTREACHED*/
    return 0;
}

#endif


/*****
 *****  Sync. CONNECT
 *****/


static int
_sync_connect(int type, struct sockaddr_in *addr)
{
    int netd;
    char *byte_addr;

    if((netd=socket(AF_INET, type, 0))<0) {
        Error("_sync_connect: Cannot crate socket (%d)", errno);
        return KOTETU_SOCK_SOCKETERROR;
    }

conn:
    if(connect(netd,
      (struct sockaddr*) addr, sizeof(struct sockaddr_in)) < 0) {
        if(errno == EINTR)
            goto conn;

        close(netd);
        netd = -1;

        Error("_sync_connect: Cannot connect (%d).\n", errno);
        byte_addr = (char*) addr;
        show_addr("_sync_connect_byname: Cannot connect", byte_addr);

        return KOTETU_SOCK_CONNECTERROR;
    }

    return netd;
}

int
sync_connect_byname(int type, char *hostname, int portno)
{
    struct sockaddr_in addr;

    if(find_addr(hostname, portno, &addr)) {
        Trace("sync_connect_byname: Cannot found host '%s'\n", hostname);
        return KOTETU_SOCK_UNKNOWHOST;
    }

    return _sync_connect(type, &addr);
}

int sync_connect_byaddr(int type, struct sockaddr_in *addr, int portno)
{
    addr->sin_port = htons(portno);

    return _sync_connect(type, addr);
}




/*****
 *****  Async. CONNECT
 *****/

static int
_async_connect(int type, struct sockaddr_in *addr)
{
    int netd;
    int cntl_opt;
    char msg[STRING_SIZE];
    char *byte_addr;
    int ret_connect;
    int c;

    if((netd=socket(AF_INET, type, 0))<0) {
        Error("_async_connect: Cannot crate socket (%d)", errno);
        return KOTETU_SOCK_SOCKETERROR;
    }

    msg[0] = '\0';

#if 1
/*
 * via fcntl()
 */
    if((cntl_opt = fcntl(netd, F_GETFL, 0))<0) {
        Error("_async_connect: Fail F_GETFL (%d)\n", errno);
        cntl_opt = 0;
    }


#ifdef O_NONBLOCK
    cntl_opt |= O_NONBLOCK; /* strcat(msg, "+O_NONBLOCK");  */
#endif
#ifdef NONBLOCK
    cntl_opt |= FNONBLOCK;  /* strcat(msg, "+NONBLOCK");    */
#endif
#ifdef NONBLK
    cntl_opt |= FNONBLK;    /* strcat(msg, "+FNONBLK");     */
#endif

#ifdef FNDELAY
    cntl_opt |= FNDELAY;    /* strcat(msg, "+FNDELAY");     */
            /* See "Advanced 4.4BSD IPC Tutorial" (PSD:21-25) */
#endif
#ifdef O_NDELAY
    cntl_opt |= O_NDELAY;   /* strcat(msg, "+O_NDELAY");    */
#endif

    if(fcntl(netd, F_SETFL, cntl_opt)<0) {
        Error("_async_connect: fail fcntl() mode %s (%d)", msg, errno);
    }
    else {
/*
        Trace("_async_connect: fd# %d, mode %s\n", netd, msg);
*/
    }


#else

/*
 * via ioctl()
 */
    cntl_opt = 1;
    if(ioctl(netd, FIONBIO, &cntl_opt)<0) {
        Error("_async_connect: Fail FIONBIO mode, ret=%d", errno);
    }

#endif

    c = 0;
conn:
    c++;
    ret_connect =
        connect(netd, (struct sockaddr*) addr, sizeof(struct sockaddr_in));
    if(errno == EINTR) {
        goto conn;
    }

    if(errno==0 || errno == EINPROGRESS) {
/*
        Trace("_async_connect: progress fd# %d (%d)\n", netd, errno);
*/
    }
/* XXX */
#if 1
    else
    if(errno==EAGAIN) {
	if(c<10) {
	struct timespec ts;
	ts.tv_sec = 0;
	ts.tv_nsec = 10*1000*1000; /* 10msec */
	nanosleep(&ts, NULL);
	goto conn;
	}
	else {
        Error("_async_connect: Cannot connect (%d).", errno);
        return KOTETU_SOCK_CONNECTERROR;
	}
    }
#endif
    else {
        Error("_async_connect: Cannot connect (%d).", errno);

        close(netd);

/*
        Error("_async_connect: Cannot connect (%d).", errno);
        byte_addr = (char*) addr;
        show_addr("_async_connect: Cannot connect", byte_addr);
*/

        return KOTETU_SOCK_CONNECTERROR;
    }

    return netd;
}

int
async_connect_byname(int type, char *hostname, int portno)
{
    int netd;
    struct sockaddr_in addr;
    int cntl_opt;

    if(find_addr(hostname, portno, &addr)) {
#if 0
        Trace("async_connect_byname: Cannot found host '%s'\n", hostname);
#endif
        return KOTETU_SOCK_UNKNOWHOST;
    }

    return _async_connect(type, &addr);
}


int
async_connect_byaddr(int type, struct sockaddr_in *addr, int portno)
{
    addr->sin_port = htons(portno);

    return _async_connect(type, addr);
}




/*
 * release_socket -  Apply shutdown() and close() to socket FD.
 *                  And set -1 as unused.
 *
 * return:
 *      0   success (done close(), if shutdown() is success or not)
 *      1   fail    (fail close())
 */

int
release_socket(int *fd)
{
    int _errno_;

    if(*fd<0) {
        return 0;
    }

    /* shutdown - send "I/O is over" to remote port */
    if(shutdown(*fd, 2)) {  /* fail */
        _errno_ = errno;
#if 0
        Error("release_socket: fd# %d is cannot shutdown (%d)", *fd, _errno_);
#endif
    }

    /* close - close socket FD */
    if(close(*fd)) {        /* fail */
        _errno_ = errno;
        Error("release_socket: fd# %d is cannot close (%d)", *fd, _errno_);
        *fd = -1;

        return 1;
    }
    else {                  /* success */
        *fd = -1;

        return 0;
    }
}


/*
 * dump_fdset - Dump fdsets (read, write and except), for debug around select()
 */
void
dump_fdset(int nfd, fdset_t *session_fdset,
    fdset_t *rdset, fdset_t *wdset, fdset_t *edset)
{
    char line[STRING_SIZE];
    int i,c;
    char *p;

    strcpy(line,"       ");
    p=line;
    while(*p) p++;
    for(i=0;i<nfd;i++) {
        *p++ = '0'+i%10;
    }
    *p = '\0';
    Trace("%s\n", line);

    if(session_fdset!=NULL) {
    c=0;
    strcpy(line,"FDSET: ");
    p=line;
    while(*p) p++;
    for(i=0;i<nfd;i++) {
        if(FD_ISSET(i, session_fdset)) {
            *p++ = '1';
            c++;
        }
        else
            *p++ = '0';
    }
    *p = '\0';
    Trace("%s\n", line);
    }

    if(rdset!=NULL) {
    c=0;
    strcpy(line,"RDSET: ");
    p=line;
    while(*p) p++;
    for(i=0;i<nfd;i++) {
        if(FD_ISSET(i, rdset)) {
            *p++ = '1';
            c++;
        }
        else
            *p++ = '0';
    }
    *p = '\0';
    Trace("%s\n", line);
    }

    if(wdset!=NULL) {
    c=0;
    strcpy(line,"WDSET: ");
    p=line;
    while(*p) p++;
    for(i=0;i<nfd;i++) {
        if(FD_ISSET(i, wdset)) {
            *p++ = '1';
            c++;
        }
        else
            *p++ = '0';
    }
    *p = '\0';
    Trace("%s\n", line);
    }
}




