/*
 *  KOTETU: socket (TCP/UDP) procedures
 *      by k-chinen@is.aist-nara.ac.jp, 1994, 1995, 1996
 *
 * $Id: socket.h,v 1.1 1996/11/24 14:50:05 k-chinen Exp k-chinen $
 */

#ifndef KOTETU_SOCKET_H
#define KOTETU_SOCKET_H

#ifndef KOTETU_LISTEN_LENGTH
#define KOTETU_LISTEN_LENGTH      (128)
#endif /* KOTETU_LISTEN_LENGTH */


#define KOTETU_SOCK_SOCKETERROR   (-1)
#define KOTETU_SOCK_UNKNOWHOST    (-2)
#define KOTETU_SOCK_CONNECTERROR  (-3)


int bind_listen_port(int type, int portno, int listen_queue_length);

int lock_port(int pfd);
int unlock_port(int pfd);
#if 0
int isreadable(int fd, int sec, int usec);
#endif
#ifdef HAVE_POLL
#define isreadable(f, s, u)     isreadable_via_poll(f,s,u)
#else
#define isreadable(f, s, u)     isreadable_via_select(f,s,u)
#endif

int sync_connect_byname(int type, char *hostname, int portno);
int sync_connect_byaddr(int type, struct sockaddr_in *addr, int portno);
int async_connect_byname(int type, char *hostname, int portno);
int async_connect_byaddr(int type, struct sockaddr_in *addr, int portno);

int release_socket(int *sfd);


/*
 * synatx sugers
 */

/* UDP */
#define UDP_bind_port(portno, length) \
            bind_listen_port(SOCK_DGRAM, portno, length)
#define UDP_connect(hostname, portno) \
            sync_connect_byname(SOCK_DGRAM, hostname, portno)
#define UDP_aconnect(hostname, portno) \
            async_connect_byname(SOCK_DGRAM, hostname, portno)
#define UDP_connect_addr(addr, portno) \
            sync_connect_byaddr(SOCK_DGRAM, addr, portno)
#define UDP_aconnect_addr(addr, portno) \
            async_connect_byaddr(SOCK_DGRAM, addr, portno)

/* TCP */
#define TCP_bind_port(portno, length) \
            bind_listen_port(SOCK_STREAM, portno, length)
#define TCP_connect(hostname, portno) \
            sync_connect_byname(SOCK_STREAM, hostname, portno)
#define TCP_aconnect(hostname, portno) \
            async_connect_byname(SOCK_STREAM, hostname, portno)
#define TCP_connect_addr(addr, portno) \
            sync_connect_byaddr(SOCK_STREAM, addr, portno)
#define TCP_aconnect_addr(addr, portno) \
            async_connect_byaddr(SOCK_STREAM, addr, portno)


#endif /* KOTETU_SOCKET_H */
