/*
 *
 * $Id$
 */

#ifndef _SQUEUE_H_
#define _SQUEUE_H_


typedef struct {
    pthread_mutex_t lock;
    pthread_cond_t  not_empty;
    pthread_cond_t  not_full;

    int cmax;
    int count;
    int sig;

    void **head;
    void **tail;
} sess_queue_t;



off_t sq_alloc_list(int);

int sq_init(sess_queue_t *self, int sz);
int sq_show(FILE *ofp, sess_queue_t *self);
int sq_show_mapfunc(FILE *, sess_queue_t *,
        void (func)(FILE*, void*, struct timeval*), struct timeval*);
int sq_showaddr_mapfunc(FILE *, sess_queue_t *,
        void (func)(FILE*, void*, struct timeval*), struct timeval*);


int     sq_raw_push(sess_queue_t *self, sess_t *xcell);
sess_t* sq_raw_pull(sess_queue_t *self);

int     sq_push(sess_queue_t *self, sess_t *xcell);
int     sq_timedpush(sess_queue_t *self, sess_t *xcell, int wait_time);

sess_t* sq_pull(sess_queue_t *self);
sess_t* sq_pull_nonblock(sess_queue_t *self);
sess_t* sq_timedpull(sess_queue_t *self, int wait_time);
int sq_pullchunk(sess_queue_t *self, sess_t *xchunk[], int range);


#endif /* _SQUEUE_H_ */


