/*
 *  KOTETU:
 *      by k-chinen@is.aist-nara.ac.jp, 1996, 1997
 *
 * $Id: url.h,v 1.1 1996/06/28 08:19:28 k-chinen Exp k-chinen $
 */


#ifndef KOTETU_URL_H
#define KOTETU_URL_H


#define STATIC_URL  (0)
#define HEAP_URL    (1)

#define DIRTY_URL   (0)
#define CLEAR_URL   (1)
#define NORMAL_URL  (2)

#ifndef URL_LENGTH
#define URL_LENGTH  (1024)
#endif

typedef struct {
    int  loc;                   /* STATIC or HEAP */
    int  state;                 /* DIRTY or CLEAR */
    char full_loc[URL_LENGTH];

    char *proto;
    char *host;
    char *port;
    char *path;
} url_t;


#define URL_Parse(x)    (x->state==DIRTY_URL ? URL_RawParse(x) : 0)


void    URL_Show(url_t *this);
url_t   *URL_New();
url_t   *URL_NewVal(char *val);
int     URL_Delete(url_t *this);

int     URL_RawParse(url_t *this);
int     URL_Normalize(url_t *this);
url_t   *URL_Join(url_t *base, url_t *target);

int     URL_JoinStr(char*, int, char*, char*);
char    *URL_JoinStrOnHeap(char *base, char *name);

int     IsURL_NOTEorBODY(char *name, char *realname);


#endif /* KOTETU_URL_H */


