/*
 *  KOTETU: The prefetching proxy server
 *
 *  wcol.h - global header
 *      by k-chinen@is.aist-nara.ac.jp, 1994-2000.
 *
 *  $Id: wcol.h,v 1.9 1996/11/18 20:58:21 k-chinen Exp k-chinen $
 */

#ifndef KOTETU_H
#define KOTETU_H  /* block for forever(or nest) loop */


/*
 * Constants
 */

#define KOTETU_VER      "kotetu alpha"

#define KOTETU_SHMKEY_HSTATE  (0x0123)
#define KOTETU_SHMKEY_SESSION (0x0125)
#define KOTETU_SHMKEY_CACHE   (0x0127)


#define SERVER_UNKNOW       (0)
#define SERVER_ORIGIN       (1)
#define SERVER_SIBLING      (2)
#define SERVER_PARENT       (3)



/* EXIT CODE */
#define KOTETU_EXIT_NORMAL        0
#define KOTETU_EXIT_UNDEF         1
#define KOTETU_EXIT_BINDERROR     2
#define KOTETU_EXIT_NOMEMORY      3
#define KOTETU_EXIT_PIPEBROKEN    4


/*
 * Basic header files
 */
#include "range.h"
#include "msg.h"
#include "url.h"

extern pid_t wcol_pid;
extern char config_file[];


/*
 * memory
 */
#ifndef MEMORY_CHECK

#define MALLOC(x)   malloc(x)
#define FREE(x)     free(x)

#else /* MEMORY_CHECK */

#define MALLOC(x)   wcol_malloc(x)
#define FREE(x)     wcol_free(x)

#endif /* MEMORY_CHECK */


/*
 * misc macros
 */
#define strcmp_first_all(x, y0, y)      (x[0]==y0 && strcmp(x,y)==0)
#define Nstrcmp_first_all(x, y0, y)     (x[0]!=y0 || strcmp(x,y)!=0)
#define strcmp_first3(x, y0, y1, y2)    (x[0]==y0 && x[1]==y1 && x[2]==y2)
#define Nstrcmp_first3(x, y0, y1, y2)   (x[0]!=y0 || x[1]!=y1 || x[2]!=y2)
#define strncmp_first_all(x, n, y0, y)  (x[0]==y0 && strncmp(x,y,n)==0)
#define Nstrncmp_first_all(x, n, y0, y) (x[0]!=y0 || strncmp(x,y,n)!=0)
#define strcasecmp_first_all(x, y0, y) \
            ((x[0]==y0 || tolower(x[0])==tolower(y0)) && strcasecmp(x,y)==0)
#define Nstrcasecmp_first_all(x, y0, y) \
            ((x[0]!=y0 && tolower(x[0])!=tolower(y0)) || strcasecmp(x,y)!=0)
#define strncasecmp_first_all(x, n, y0, y) \
            ((x[0]==y0 || tolower(x[0])==tolower(y0)) && strncasecmp(x,y,n)==0)
#define Nstrncasecmp_first_all(x, n, y0, y) \
            ((x[0]!=y0 && tolower(x[0])!=tolower(y0)) || strncasecmp(x,y,n)!=0)



/***
 ***
 ***/

#define NBLK(radix, x)  ((x)/(radix)+(((x)%(radix))!=0))
#define NBLK512(x)      (NBLK(512,(x))*512)

#define BCEIL(x, blen)  (((x)/(blen)+1)*(blen))

#define alloc_str(x)    ((char*)MALLOC(sizeof(char)*BCEIL((x)+1, STRING_BLEN)))


#define STRDUP(d,s) \
    ((d=alloc_str(strlen(s)))==NULL ? NULL : strcpy(d, s), d)


/***
 ***
 ***/

#define KOTETU_LTIME(x)       (time(x))
#define KOTETU_UTIME(x)       (time(x), *(x)=mktime(gmtime(x)))
#define KOTETU_TO_UTIME(x)    (mktime(gmtime(x)))
#define KOTETU_TO_LTIME(x)    (mktime(localtime(x)))

        /* x(sec,usec) - y(sec,usec) */
#define KOTETU_SUB_TIME(x,y) \
        ( (x.tv_sec  - y.tv_sec )*1000 + (x.tv_usec - y.tv_usec)/1000 )

#if 0

#define KOTETU_ADD_TIME(x,y) {\
        x.tv_usec += y.tv_usec%1000000; \
        x.tv_sec  += y.tv_sec + y.tv_usec/1000000; \
        }

#else

        /* x(sec,usec) += z(msec) */
#define KOTETU_ADD_MSEC(x,y) {\
        x.tv_usec += (y%1000)*1000; \
        x.tv_sec  += y/1000+(x.tv_usec/1000000); \
        x.tv_usec = x.tv_usec%1000000; \
        }
        /* x(sec,usec) += z(usec) */
#define KOTETU_ADD_USEC(x,y) {\
        x.tv_sec  += y/1000000; \
        x.tv_usec += y%1000000+(x.tv_usec/1000000); \
        x.tv_usec = x.tv_usec%1000000; \
        }


#endif




/***
 ***
 ***/

#ifndef DEFAULT_CONFIG_ENVNAME
#define DEFAULT_CONFIG_ENVNAME "KOTETU"
#endif

#ifndef DEFAULT_CONFIGFILE
#define DEFAULT_CONFIGFILE      "/etc/kotetu.conf"
#endif

#endif /* KOTETU_H */
