import java.util.*;

public class Philosopher2 extends Thread {
    private static int nextId = 0;
    private final int myId;
    private final int howManyDinners;
    private Chopstick left;
    private Chopstick right;
    private DiningRoom droom;

    public Philosopher2(int n,Chopstick l,Chopstick r,DiningRoom dr) {
        this.myId = nextId++;
        this.howManyDinners = n;
        this.left = l;
        this.right = r;
        this.droom = dr;
    }

    public void run() {
        Random random = new Random();
        for (int i = 0; i < howManyDinners; i++) {
            System.out.println("Ph" + myId + " is thinking.");
            try { Thread.sleep(random.nextInt(500)); }
            catch (InterruptedException e) {}
            System.out.println("Ph" + myId + " wants to dine.");
            try { droom.enter(); }
            catch (InterruptedException e) {}
            System.out.println("Ph" + myId + " has entered the dining room.");
            try { left.acquire(); }
            catch (InterruptedException e) {}
            System.out.println("Ph" + myId
                               + " has acquired the left chopstick.");
            try { right.acquire(); }
            catch (InterruptedException e) {}
            System.out.println("Ph" + myId
                               + " has acquired the right chopstick.");
            System.out.println("Ph" + myId + " is dining.");
            try { Thread.sleep(random.nextInt(500)); }
            catch (InterruptedException e) {}
            right.release();
            System.out.println("Ph" + myId
                               + " has released the right chopstick.");
            left.release();
            System.out.println("Ph" + myId
                               + " has released the left chopstick.");
            droom.leave();
            System.out.println("Ph" + myId + " has left the dining room.");
        }
        System.out.println("Ph" + myId + " is sleepy.");
    }
}