open Ls
open Term
open Trs

(* TODO: Weakly Orthogonal Composability *)

(* restriction *)
let (|\) rs p =
  [ l,r | l,r <- rs; List.mem (root l) p ]

let rec composable r s = cond1 r s && cond1 s r && cond2 r s
and cond1 r s = conss r @^ defs s = []
and cond2 r s =
  subseteq
    ((r@s) |\ (defs r @^ defs s))
    (r @^ s)

let all_composable rss =
  List.for_all
    (Util.uncurry composable)
    (triangle rss)

let cond2WMO r s = cond2 r s && Match.is_WMO r s
let composableWMO r s = composable r s && cond2WMO r s
let all_composableWMO rss =
  List.for_all
    (Util.uncurry composableWMO)
    (triangle rss)

let commuting r s = Result.is_YES (Commute.direct r s)
let all_commuting rss =
  List.for_all
    (Util.uncurry commuting)
    (triangle rss)

(********* DECOMPOSITION **********)

(* if Cr and Ds has common symbols A, move rules in S to R
     s.t. defined symbols of rule are included in A
 * suppose Cr and Ds have common symbol *)
let fix_cond1 r s = ((s |\ (conss r @^ defs s)) @+ r, s)

(* if R has rules that has common defined symbol on R and S, and
     these rules are not contained in S, then move these rules to S *)
let fix_cond2 r s =
  let is = (r@+s) |\ (defs r @^ defs s) in
  (is @+ r, is @+ s)

(* suppose R and S are composable *)
let fix_WMO r s =
  if Match.is_WMO r s then
    [r;s]
  else
    [r@+s]
let fix_COM r s =
  if commuting r s then
    [r;s]
  else
    [r@+s]


let rec remove_subset = function
  | []    -> []
  | [x]   -> [x]
  | x::xs -> let ys = [ y | y <- xs; not (subseteq y x) ] in
      if List.exists (fun y -> subset x y) xs then
        remove_subset ys
      else
        x :: remove_subset ys

let small_order xss =
  let len = List.length in
  List.sort
    (fun xs ys -> compare (len xs) (len ys))
    xss

let rec decompose rs =
  small_order @@ decompose' @@
    (* initial TRSs are grouped by defined symbol *)
    group_by (fun a b -> def a = def b) rs
and decompose' rss =
  if all_composable rss then
    rss
  else
    decompose' @@ remove_subset @@
      [ rs | (r,s) <- triangle rss;
             (r',s') <- [proc r s];
             rs <- [r';s']]
and proc r s =
  match cond1 r s, cond1 s r, cond2 r s with
  | false,_,_ -> fix_cond1 r s
  | _,false,_ -> fix_cond1 s r
  | _,_,false -> fix_cond2 r s
  | _         -> (r,s)

let rec decomposeWMO rs =
  small_order @@ decomposeWMO' (decompose rs)
and decomposeWMO' rss =
  if all_composableWMO rss then
    rss
  else
    decomposeWMO' @@ remove_subset @@
      [ rs | (r,s) <- triangle rss;
             rs <- fix_WMO r s ]

let rec decomposeCOM rs =
  small_order @@ decomposeCOM' (decompose rs)
and decomposeCOM' rss =
  if all_commuting rss then
    rss
  else
    decomposeCOM' @@ remove_subset @@
      [ rs | (r,s) <- triangle rss;
             rs <- fix_COM r s ]

let decompose   rs =
  Console.watcher_l "Composable decomposition" decompose rs
let decomposeWMO rs =
  Console.watcher_l "Composable decompositionWMO" decomposeWMO rs
let decomposeCOM rs =
  Console.watcher_l "Composable decompositionCOM" decomposeCOM rs


(** constructor sharing **)
(* cond is not symmetric *)
let cond_cons r s = defs r @^ funs s = []

(* merge subsystems in rss s.t. overlapping function and defined symbols *)
let rec members rss rs =
  match [ ss | ss <- rss; not (cond_cons rs ss && cond_cons ss rs) ] with
  | []  -> rs
  | sss -> members (rss \\ sss) (rs @+ union sss)

(* merge all subsystems by function 'member' *)
let rec member_class = function
  | []      -> []
  | rs::rss ->
      let m = members rss rs in
      m :: member_class [ ss | ss <- rss; not (subseteq ss m) ]

let cons_share rs = small_order @@
  member_class [[lr] | lr <- rs]

let cons_share rs = Console.watcher_l "Constructor-sharing decomposition" cons_share rs

(** Utility **)
let is_composable rs = List.length (decompose rs) > 1
let is_cons_share rs = List.length (cons_share rs) > 1

let show_decompose rss =
  Format.printf "%d decompositions@." (List.length rss);
  List.iter
    (fun (i,rs) ->
      Format.printf " #%d -----------\n%s@."
        i
        (sprint_rules rs))
    (indexing rss)

let print_decompose  rs = show_decompose (decompose rs)
let print_cons_share rs = show_decompose (cons_share rs)
