open Term

type command 'a = (string -> 'a) -> string * out_channel -> string list -> 'a

(* run command and read all stdout *)
val run           : string -> string
val run_with      : 'a command



(* take yices format *)
val sat      : string list -> (string list * string list) list option
val sat_save : string list -> (string list * string list) list option
val is_sat   : string list -> bool

val maxsat    : string list -> ((string list * string list) list * int list * int) option
val is_maxsat : string list -> bool


(* apply function, and measure processing time *)
val chronicle : ('a -> 'b) -> 'a -> 'b * float
(* output processing time to stderr *)
val watcher   : string -> ('a -> 'b) -> 'a -> 'b
(* watcher for longer label *)
val watcher_l : string -> ('a -> 'b) -> 'a -> 'b

val sat_check : unit -> bool
val max_check : unit -> bool
