{
open Lexing
open Parser

let ident_or_keyword = function
  | "VAR" -> VAR
  | "RULES" -> RULES
  | "STRATEGY" -> STRATEGY
  | "INNERMOST" -> INNERMOST
  | "THEORY" -> OTHER
  | s -> IDENT s

exception Lexing_error of string

}

let letter = 
  ['a'-'z' 'A'-'Z' '0'-'9' '\''
   '#' '+' '-' '*' '/' '.' '\\' ':' ';' '=' '<' '>' '_' '@' '`' '$'
   '{' '}' '[' ']' '|' '~' '?' '&' '"' '!' '%']

rule token = parse
  | [' ' '\r' '\t'] {  token lexbuf }
  | '\n'   { new_line lexbuf; token lexbuf }
  | "->="  { ARROWEQ }
  | "->"   { ARROW }
  | "("    { LPAREN }
  | ")"    { RPAREN }
  | ","    { COMMA }
  | letter+ as s { ident_or_keyword s }
  | _      { OTHER }
  | eof    { EOF }
