%{
open Num
open Lexing
open Term
open Parsing

let add xs rs (xs', rs') = (xs @ xs', rs @ rs')

let rec convert_term xs = function
  | V _ as t -> t
  | F (x, []) when List.mem x xs -> V x
  | F (f, ts) -> F (f, List.map (convert_term xs) ts)

let convert_rule xs (l, r) = (convert_term xs l, convert_term xs r)

let convert_rules (xs, rs) = List.map (convert_rule xs) rs

let syntax_error msg =
  let p = symbol_start_pos () in
  Format.eprintf "File %S at line %d, character %d:@.%s@." 
    p.pos_fname p.pos_lnum (p.pos_cnum - p.pos_bol + 1) msg;
  exit 1

%}

%token <string> IDENT
%token LPAREN RPAREN 
%token ARROW ARROWEQ COMMA EOF 
%token VAR RULES OTHER STRATEGY
%token INNERMOST CONTEXTSENSITIVE

%type <(Term.t * Term.t) list> toplevel
%start toplevel

%%

toplevel:
  | decl EOF { convert_rules $1 }

decl:
  | LPAREN VAR      vars      RPAREN decl { add $3 [] $5 }
  | LPAREN RULES    rules     RPAREN decl { add [] $3 $5 }
  | LPAREN STRATEGY INNERMOST RPAREN decl { $5 }
  | LPAREN IDENT    anylist   RPAREN decl { $5 }
  |                                       { ([], []) }
  | error { syntax_error "Syntax error." }

anylist:
  | any anylist { () }
  |             { () }

any:
  | LPAREN anylist RPAREN { () }
  | IDENT { () } 
  | ARROW { () }
  | COMMA { () }
  | OTHER { () }

vars:
  | IDENT vars { $1 :: $2 }
  |            { [] }

rules:
  | rule rules { $1 :: $2 }
  | { [] }

rule:
  | term ARROW term { ($1, $3) }
  | error      { syntax_error "Syntax error." }

term:
  | IDENT LPAREN terms RPAREN { F ($1, $3) }
  | IDENT                     { F ($1, []) }
  | error { syntax_error "Syntax error." }

terms:
  | term COMMA terms { $1 :: $3 }
  | term             { [$1] }
  |                  { [] }
