type opt =
  | B of bool ref
  | I of int  ref

let show = function
  | B b -> string_of_bool !b
  | I x -> string_of_int !x

let fsts xs =
  let choice = function
    | B x,_ -> x
    | I _,_ -> invalid_arg "Ref.fsts.choice" in
  List.map choice xs

(* refs for command line option *)
let no_proof      = ref false
let no_decompose  = ref false
let no_ll         = ref false
let no_comm       = ref false
let no_red        = ref false
let k             = ref 7 (* lucky seven *)

let dic_options =
  [ B no_proof    , "no_proof"
  ; B no_decompose, "no_decompose"
  ; B no_ll       , "no_ll"
  ; B no_comm     , "no_comm"
  ; B no_red      , "no_red"
  ; I k           , "k"
  ]

let jk    = ref false (* including jka, jkc, jkac and jkacc *)
let kb    = ref false
let jka   = ref false (* please use carefully *)
let jkc   = ref false (* please use carefully *)
let jkac  = ref false (* please use carefully *)
let dc    = ref false
let sc    = ref false
let rl    = ref false
let tcap  = ref false

let dic_jks =
  [ B jka , "jka"
  ; B jkc , "jkc"
  ; B jkac, "jkac"
  ]

let dic_base_thms =
  [ B dc  , "dc"
  ; B rl  , "rl"
  ; B kb  , "kb"
  ; B jk  , "jk"
  ; B tcap, "tcap"
  ]
let dic_all_thms = dic_base_thms @ dic_jks

let flag = ref true

let jks       = fsts dic_jks
let base_thms = fsts dic_base_thms
let all_thms  = fsts dic_all_thms

let print_options () =
  List.iter
    (fun (b,s) -> Format.printf "%s = %s@." s (show b))
    dic_options
let print_flags () =
  List.iter
    (fun (b,s) -> Format.printf "%s = %s@." s (show b))
    dic_all_thms

let config_jks () =
  if !jk then
    (jkac := true; jka := true; jkc := true)
  else if not !jk && List.exists (fun b -> !b) jks then
    (jk := true; kb := true)
  else
    ()

let flag_off () =
  List.iter (fun f -> f := false) all_thms

let flag_on () =
  if not !flag then
      flag_off ()
  else
    let flagA () =
      if List.for_all (fun b -> not !b) all_thms then
        List.iter (fun b -> b := true) base_thms
      else
        () in
    (* if all flags are disabled then enable them *)
    flagA ();
    (* flag jk enable other sub flags [jka;jkc;jkac] *)
    config_jks ()

let debug     = ref false (* show cover *)
let show_time = ref false (* associate to Console.watcher *)
let dump      = ref (None : string option) (* output dir for debug information *)
let test      = ref false

let set_dump path = dump := Some path
