open Form

(* solve formula by Yices *)
val sat    : 'a form list -> (string * string list) list option
val maxsat : 'a max_form list -> ((string * string list) list * int list * int) option (* evidence, unsat cores, cost *)

(* generate Yices format strings *)
val yices    : 'a form list -> string list (* use Ref.yices_version *)
val yices1   : 'a form list -> string list
val yices2   : 'a form list -> string list

(* for MAX SMT *)
val max_yices : 'a max_form list -> string list

(* generator *)
val form_to_string  : string form -> string
val def_nat         : int -> string list -> ('a form) list
val def_bool        : string list -> ('a form) list
val def_int         : string list -> ('a form) list
val gen_definition  : 'a form list -> string list
val gen_assert      : 'a form list -> string list
val gen_instruction : int -> string list
val gen_assert_plus : 'a max_form list -> string list

(* debug *)
val align : 'a form list -> (string list * 'b) list -> (string * 'b) list
