{
open Yices_parser
open Lexing
open Parsing
open Format

(* exception Error of (int * int * string) *)
let unsupport lexbuf =
  let curr = lexbuf.Lexing.lex_curr_p in
  let line = curr.Lexing.pos_lnum in
  let cnum = curr.Lexing.pos_cnum - curr.Lexing.pos_bol in
  let tok = Lexing.lexeme lexbuf in
  Format.eprintf "ignore line: %d line, %d column, token \"%s\"@." line cnum tok

let exit' () = Format.eprintf "Yices is killed"; exit 1
}
(* restrict to *)
(* let num = '-' * ([ '0'-'9' ] + ) *)
let name = ['A'-'Z' 'a'-'z' '0'-'9' '-' '+' '*' '#' '_' '\'' ':'] +
let datatype = "mk-tuple" | "select"

rule evidence = parse
  | [' ' '\t']  { evidence lexbuf }
  | '\n'        { new_line lexbuf; evidence lexbuf }
  | "sat"       { SAT }
  | "unsat"     { UNSAT }
  | "unknown"   { exit' () }
  | datatype    { TUPLE }
(*  | num as n    { NUM (int_of_string n) } *)
  | name as v   { WORD v }
  | "="         { EQ }
  | "cost: "    { COST }
  | "("         { LPAREN }
  | ")"         { RPAREN }
  | eof         { EOF }
  | "unsatisfied assertion ids:" { CORE }
  | "Logical context is inconsistent. Use (reset) to reset." { EOF }
  | _ { unsupport lexbuf; new_line lexbuf; evidence lexbuf }
