open Term
open Format

let count = ref 0

let fresh () = incr count; sprintf "___ac_cps_x%d" !count

let rename (l, r) =  
  let s = [ x, V (fresh ()) | x <- vars l ] in
  (subst s l, subst s r)

(* AC Overlaps *)
let overlap_aux ac rule1 rule2 =
  let l1, r1 = rename rule1
  and l2, r2 = rename rule2 in
  [ (l1, r1), p, (l2, r2),  u
  | p <- poss_fun l2; 
    ac_unifs <- [Ac_subst.unify ac ((subterm_at l2 p),l1)];
    ac_unifs <> []
    (* exclusion of variant rules is unsound for AC-critical pairs *)
    (* && (p <> [] || not (Match.variant_rule (l1, r1) (l2, r2))); *)
    ;
    u <- ac_unifs ] 

let overlap2 ac rules1 rules2 = 
  Ls.uniq
    [ x | rule1 <- rules1; rule2 <- rules2; 
          x <- overlap_aux ac rule1 rule2 ]

let overlap ac rules = overlap2 ac rules rules

(* AC critical pairs *)

let cp_of_overlap ((l1, r1), p, (l2, r2), mu) =
  (subst mu (replace l2 r1 p), subst mu r2)

let cp2 ac rules1 rules2 = 
  [ cp_of_overlap o | o <- overlap2 ac rules1 rules2 ]

let cp ac rules = cp2 ac rules rules
