(* Associative unification based on akin of Plotkin's algorithm.

   Remark:
   This algorithm correctly works only if an input equation
   consists of linear terms that share no variables.
 *)

type subst = (string * Term.t) list

val unify : string list -> Term.t -> Term.t -> subst list 

val matcher : string list -> Term.t -> Term.t -> subst list

val nf : string list -> Term.trs -> Term.t -> Term.t

val equal : string list -> Term.t -> Term.t -> bool
