open Term
open Result

(* theorems *)
type theorem =
  | KB of (trs*trs)
  | JK of (trs*trs)
  | RL of (trs*trs)
  | DC of (trs*trs)
  | NC of unit
  | SC of (trs*trs)
  | COM of (theorem list)
type peak = t*t*t

val commute : trs -> trs -> (theorem,peak) result
val cr      : trs -> (theorem,peak) result

val thm_description : theorem -> string
val show_proof      : theorem -> unit

(* Knuth and Bendix 1964 *)
val kb1    : trs -> (theorem,peak) result
val kb2    : trs -> trs -> (theorem,peak) result
(* Jouannaud and Kirchner 1986 *)
val thm_JK : trs -> trs -> (theorem,peak) result
(* Development Closedness: Yoshida Aoto Toyama 2009 *)
val thm_DC : trs -> trs -> (theorem,peak) result
(* weighted Rule Labeling: V Oostrom 2008, Aoto 2010 *)
val thm_RL : trs -> trs -> (theorem,peak) result
(* strictly commuting: Gaser 90 *)
val thm_SC : trs -> trs -> (theorem,peak) result
(* check non commutation *)
val noncomm: trs -> trs -> (theorem,peak) result
(* apply each theorems directly *)
val direct0: trs -> trs -> (theorem,peak) result
(* apply each theorems directly (cached) *)
val direct : trs -> trs -> (theorem,peak) result
(* locally commutation *)
val wcomm  : trs -> trs -> (theorem,peak) result
val kwcomm : int -> trs -> trs -> (theorem,peak) result

val wcr   : trs -> (theorem,peak) result
val kwcr  : int -> trs -> (theorem,peak) result

(* caching *)
val cache_on  : unit -> unit
val cache_off : unit -> unit
