open Term
open Step
open Result

(* NOTE: pair is joinable by ->1st and 2nd<- *)
val join    : int -> trs -> trs -> t * t -> bool
val join_by : stepS list -> stepS list -> t * t -> bool
val goto    : int -> (t -> t list) -> t -> t -> bool
val unjoin     : trs -> trs -> t * t -> bool

(* complex *)
val jj    : trs list -> trs list -> t * t
  -> (rewrite list * rewrite list) list
val jj_ex : stepS list -> stepS list -> t * t
  -> (rewrite list * rewrite list) list

val k_join : int -> trs -> trs -> t * t -> (rewrite list * rewrite list) list
val is_k_join : int -> trs -> trs -> t * t -> bool

val joinable   : trs list -> trs list -> t * t -> (unit,t*t) result
val k_joinable : int -> trs -> trs -> t * t -> (unit,t*t) result

(* light weight *)
val jj_light   : int -> trs -> trs -> t * t -> (unit,t*t) result

(* utility *)
val rules_from     : rewrite list -> rule list
val rules_pos_from : rewrite list -> (rule * pos) list
val rules_From     : rewrite list * rewrite list -> rule list * rule list
val rules_pos_From : rewrite list * rewrite list -> (rule * pos) list * (rule * pos) list

val show_seq   : string -> rewrite list -> unit
val show_joins : (rewrite list * rewrite list) list -> unit

(* for jj *)
val cache_on     : unit -> unit
val cache_off    : unit -> unit
(* for jj_light *)
val light_on     : unit -> unit
val light_off    : unit -> unit

(* table opration for jj *)
val reset_table : unit -> unit
val show        : unit -> unit
