(****** for List ******)
(* mapping *)
val map_tail : ('a -> 'b) -> 'a list -> 'b list 
val concat_map : ('a -> 'b list) -> 'a list -> 'b list 

(* taking *)
val take       : int -> 'a list -> 'a list
val take_while : ('a -> bool) -> 'a list -> 'a list

val drop       : int -> 'a list -> 'a list
val drop_while : ('a -> bool) -> 'a list -> 'a list

(* uniq *)
val uniq_by : ('a -> 'a -> bool) -> 'a list -> 'a list
val uniq    : 'a list -> 'a list (* raise Stack_overflow *)

(* removing *)
val remove    : ?eq:('a -> 'a -> bool) -> 'a -> 'a list -> 'a list
val del       : ?eq:('a -> 'a -> bool) -> 'a list -> 'a list -> 'a list
val remove_by : ('a -> 'a -> bool) -> 'a -> 'a list -> 'a list
val del_by    : ('a -> 'a -> bool) -> 'a list -> 'a list -> 'a list
val (\\)      : 'a list -> 'a list -> 'a list

(* diff *)
val diff : 'a list -> 'a list -> 'a list * 'a list 

(* range *)
val range    : int -> int -> int list
val range_of : int -> 'a list -> int list
(* index start at 1 by default *)
val indexing : ?n:int -> 'a list -> (int * 'a) list
val count    : 'a list -> ('a * int) list

(* repeat *)
val rep : int -> 'a -> 'a list 

(* replace: can be change start index *)
val replace_at : ?n:int -> int -> 'a -> 'a list -> 'a list

(* prefixx *)
val prefix   : 'a list -> 'a list list
val suffix   : 'a list -> 'a list list
val triangle : 'a list -> ('a * 'a) list
val diagonal : 'a list -> 'a list list


(****** for Set ******)
(* basic operator *)
val setminus  : 'a list -> 'a list -> 'a list
val (-\\)     : 'a list -> 'a list -> 'a list

val cup       : 'a list -> 'a list -> 'a list
val (@+)      : 'a list -> 'a list -> 'a list

val cap       : 'a list -> 'a list -> 'a list
val (@^)      : 'a list -> 'a list -> 'a list

val union     : 'a list list -> 'a list
val intersect : 'a list list -> 'a list

(* subset *)
val subset   : 'a list -> 'a list -> bool
val supset   : 'a list -> 'a list -> bool
val subseteq : 'a list -> 'a list -> bool
val supseteq : 'a list -> 'a list -> bool

val seteq    : 'a list -> 'a list -> bool
val (===)  : 'a list -> 'a list -> bool

(* element *)
val minimal : ('a -> 'a -> bool) -> 'a list -> 'a list 
val maximal : ('a -> 'a -> bool) -> 'a list -> 'a list 
val minimum : ('a -> 'a -> bool) -> 'a list -> 'a 
val maximum : ('a -> 'a -> bool) -> 'a list -> 'a 

(* set to set of set *)
val pset    : 'a list list -> 'a list -> 'a list list
val powset  : 'a list -> 'a list list
val product : 'a list list -> 'a list list

(* grouping *)
val dj_split : 'a list -> ('a list * 'a list) list
val eq_class : 'a -> ('a -> 'b -> bool) -> 'b list -> 'b list
val quotset  : ('a -> 'a -> bool) -> 'a list -> 'a list list
val group_by : ('a -> 'a -> bool) -> 'a list -> 'a list list
