open Term

(* single simple step *)
type step    = t -> t list
(* full step *)
type rewrite = t * (rule * pos) option * t
type stepS   = t -> rewrite list list

val rewrite_a   : trs -> t -> t
val rewrite     : trs -> step
val multi_step  : trs -> step
(* special *)
val stepS       : trs -> stepS
val multi_stepS : trs -> stepS
(* limited by k *)
val k_stepS     : int -> trs -> stepS
val k_step      : int -> trs -> step
(* and including zero step (i.e. '=')*)
val k_stepSs    : int -> trs -> stepS
val k_steps     : int -> trs -> step

(* elimination *)
val reduce     : int -> trs -> trs
val reduce_by  : int -> (trs -> step) -> trs -> trs
val if_reduced : trs -> trs -> unit

(* predicate *)
val is_NF       : trs -> t -> bool

(* need terminating TRS *)
val normalform  : trs -> t -> t
val normalforms : trs -> t -> t list

(* utilities *)
val last         : rewrite list -> rewrite
val last_term    : rewrite list -> t
val nontrivials  : rewrite list -> rewrite list
val shrink       : stepS -> step
val show_rewrite : rewrite -> unit
val show_stepS   : rewrite list list -> unit
val cache_on     : unit -> unit
val cache_off    : unit -> unit
