open Term

(* initialize to standard variable name *)
val init : trs -> trs

(* symbols *)
val vars  : trs -> string list
val funs  : trs -> string list

val def   : rule -> string
val cons  : rule -> string list
val defs  : trs -> string list
val conss : trs -> string list

(* subterms *)
val subterms : trs -> t list

(* predicate *)
val linear      : trs -> bool
val left_linear : trs -> bool
val non_erase   : trs -> bool

(* substitution *)
val subst          : (string * t) list -> trs -> trs
val replace_symbol : (string * string) list -> trs -> trs
val rename         : trs -> trs

(* util *)
val sort : trs -> trs

(* printer *)
val sprint_rule     : rule -> string

val sprint_rules    : trs -> string
val print_rules     : trs -> unit

val sprint_overlaps : (rule * pos * rule) list -> string
val print_overlaps  : (rule * pos * rule) list -> unit

val sprint_cp       : (t * pos * t * t) -> string
val print_cp        : (t * pos * t * t) -> unit
