(* like Arrow *)
let (>>>) f g = fun a -> g (f a)

let curry f x y = f (x,y)
let uncurry f (x,y) = f x y

(* monad combinator *)
let (>=>) a b = fun t ->
  [v | u <- a t; v <- b u]

let swap (a,b) = b,a

let rec sequence = function
  | []           -> Some []
  | None::_      -> None
  | (Some x)::xs -> match sequence xs with
    | Some ys -> Some (x::ys)
    | None    -> None

(** String **)
open Format

let sprint_int_list xs =
  sprintf "[%s]" (String.concat ";" [ string_of_int x | x <- xs])

let print_int_list xs = printf "%s" (sprint_int_list xs)

(* decompose to string list *)
let rec str_to_list n str =
  if n >= String.length str then
    []
  else
    str.[n] :: str_to_list (n+1) str
