open Term
open Format

let count = ref 0

let fresh () = incr count; sprintf "___ac_cps_x%d" !count

let rename (l, r) =  
  let s = [ x, V (fresh ()) | x <- vars l ] in
  (subst s l, subst s r)

(* AC Overlaps *)
let overlap_aux ac rule1 rule2 =
  let l1, r1 = rename rule1
  and l2, r2 = rename rule2 in
  [ (l1, r1), p, (l2, r2),  u
  | p <- poss_fun l2; 
    ac_unifs <- [Ac_subst.matcher ac ((subterm_at l2 p),l1)];
    ac_unifs <> []
    (* exclusion of variant rules is unsound for AC-critical pairs *)
    (* && (p <> [] || not (Match.variant_rule (l1, r1) (l2, r2))); *)
    ;
    u <- ac_unifs ] 

let overlap2 ac rules1 rules2 = 
  Ls.uniq
    [ x | rule1 <- rules1; rule2 <- rules2; 
          x <- overlap_aux ac rule1 rule2 ]

let overlap ac rules = overlap2 ac rules rules

(* AC critical pairs *)
let critical_peak_aux ((l1, r1), p, (l2, r2), mu) =
  (subst mu (replace l2 r1 p),
   subst mu l2,
   subst mu r2)
  
let critical_peak2 ac rules1 rules2 =
  List.map critical_peak_aux (overlap2 ac rules1 rules2)

let critical_peak ac rule1 = critical_peak2 ac rule1 rule1

let cp2 ac rules1 rules2 = 
  List.map
    (fun (s,_,t) -> (s,t))
    (critical_peak2 ac rules1 rules2)

let cp ac rules = cp2 ac rules rules

(*
let [rl1;rl2;e1;e2] = Read.read_trs "../nonCR_CSI-new-evidence.trs"
let r = [rl1;rl2]
let [c;a1;a2] = [(F ("+", [V "x"; V "y"]), F ("+", [V "y"; V "x"]));
              (F ("+", [F ("+", [V "x"; V "y"]); V "z"]),
               F ("+", [V "x"; F ("+", [V "y"; V "z"])]));
              (F ("+", [V "x"; F ("+", [V "y"; V "z"])]),
               F ("+", [F ("+", [V "x"; V "y"]); V "z"]))]
let acs = ["+"]
let _ = List.filter (fun (s,u,t) -> s <> t)
          @@ critical_peak2 acs [rl1] [a2]
*)
