open Term

(* term comparison *)
val compare : t -> t -> int

(**** Unification ****)
val matcher      : t -> t -> (string * t) list
val matchers     : trs -> t -> (rule * ((string * t) list)) list

val instance_of  : t -> t -> bool
val variant      : t -> t -> bool
val variant_rule : rule -> rule -> bool

val mgu          : (t * t) list -> (string * t) list
val unifiable    : (t * t) list -> bool

(** tcap function **)
val tcap         : trs -> t -> t

(**** Critical Pair ****)
val simple_cp  : (t * t) list -> (t * t) list

val is_overlap : (rule * pos * rule) -> bool
(* rename second trs *)
val overlaps   : trs -> trs -> (rule * pos * rule) list

(* b <-p a -> c *)
val cp_overlap : (rule * pos * rule) list -> (t * pos * t * t) list

(* critical peaks *)
val cpp         : trs -> (t * t * t) list
val cpp2        : trs -> trs -> (t * t * t) list (* rhs is rewrited by root redex *)
val cpp2r       : trs -> trs -> (t * t * t) list (* lhs is rewrited by root redex *)
val cpp2_all    : trs -> trs -> (t * t * t) list
val cpp_in      : trs -> trs -> (t * t * t) list
val cpp_out     : trs -> trs -> (t * t * t) list

(* critical pairs *)
val cp2        : trs -> trs -> (t * t) list (* rhs is rewrited by root redex *)
val cp2r       : trs -> trs -> (t * t) list (* lhs is rewrited by root redex *)
val cp2_all    : trs -> trs -> (t * t) list
val cp_in      : trs -> trs -> (t * t) list
val cp_out     : trs -> trs -> (t * t) list

(* sorted critical pairs *)
val cp_        : trs -> (t * t) list
val cp2_       : trs -> trs -> (t * t) list (* rhs is rewrited by root redex *)
val cp2r_      : trs -> trs -> (t * t) list (* lhs is rewrited by root redex *)
val cp2_all_   : trs -> trs -> (t * t) list
val cp_in_     : trs -> trs -> (t * t) list
val cp_out_    : trs -> trs -> (t * t) list

(* Property about Critical Pair *)
val is_OH  : trs -> bool
val is_WMO : trs -> trs -> bool
