open Format
open Lexing

let finally x f g =
  let r = try f x with e -> g x; raise e in 
  g x; r

let syntax_error p =
  eprintf "File %S at line %d, character %d:@.Syntax error.@." 
    p.pos_fname p.pos_lnum (p.pos_cnum - p.pos_bol)

let read_trs filename =
  let f ch = 
    let lexbuf = from_channel ch in
    let lex_curr_p = { lexbuf.lex_curr_p with pos_fname = filename } in
    try
      Parser.system Lexer.token { lexbuf with lex_curr_p = lex_curr_p }
    with Parsing.Parse_error -> 
      (syntax_error lexbuf.lex_curr_p; exit 1)
  in
  finally (open_in filename) f close_in

let read_problem filename =
  let f ch = 
    let lexbuf = from_channel ch in
    let lex_curr_p = { lexbuf.lex_curr_p with pos_fname = filename } in
    try
      Parser.toplevel Lexer.token { lexbuf with lex_curr_p = lex_curr_p }
    with Parsing.Parse_error -> 
      (syntax_error lexbuf.lex_curr_p; exit 1)
  in
  finally (open_in filename) f close_in
