type opt =
  | B of bool ref
  | I of int  ref

let show = function
  | B b -> string_of_bool !b
  | I x -> string_of_int !x

let getB = function
  | B x -> x
  | I _ -> invalid_arg "Ref.getB"

(* refs for command line option *)
let no_proof      = ref false
let no_decompose  = ref false
let no_ll         = ref false
let no_comm       = ref false
let no_red        = ref false
let k             = ref 7 (* lucky seven *)

let dic_options =
  [ B no_proof    , "no_proof"
  ; B no_decompose, "no_decompose"
  ; B no_ll       , "no_ll"
  ; B no_comm     , "no_comm"
  ; B no_red      , "no_red"
  ; I k           , "k"
  ]

let jk    = ref false (* including jka, jkc, jkac and jkacc *)
let kb    = ref false
let jka   = ref false (* buggy, please use carefully *)
let jkc   = ref false (* buggy, please use carefully *)
let jkac  = ref false (* buggy, please use carefully *)
let dc    = ref false
let mo    = ref false
let sc    = ref false
let rl    = ref false
let tcap  = ref false

let dic_jks =
  [ B jka , "jka"
  ; B jkc , "jkc"
  ; B jkac, "jkac"
  ]

let dic_base_thms =
  [ B dc  , "dc"
  ; B mo  , "mo"
  ; B rl  , "rl"
  ; B kb  , "kb"
  ; B jk  , "jk"
  ; B tcap, "tcap"
  ]
let dic_all_thms = dic_base_thms @ dic_jks

let flag = ref true

let print_options () =
  List.iter
    (fun (b,s) -> Format.printf "%s = %s@." s (show b))
    dic_options
let print_flags () =
  List.iter
    (fun (b,s) -> Format.printf "%s = %s@." s (show b))
    dic_all_thms

let config_jks () =
  if !jk then
    (jkac := true; jka := true; jkc := true)
  else if not !jk && List.exists (fun (opt,s) -> !(getB opt)) dic_jks then
    (jk := true; kb := true)
  else
    ()

let flag_off () =
  List.iter (fun (opt, s) -> (getB opt) := false) dic_all_thms

(* buggy (see http://dx.doi.org/10.1007/978-3-319-63046-5_24) *)
(* let deprecated_common  = ["jk"; "jka"; "jkc"; "jkac"] *)
let deprecated_common  = []
(* not work in commutation *)
let deprecated_commute = ["tcap"]

let flag_on flags =
  if List.for_all (fun (opt, s) -> not !(getB opt)) flags then
    List.iter (fun (opt,s) -> (getB opt) := true) flags
  else
    ()

let confluence_flag_on () =
  if not !flag then
      flag_off ()
  else
    (* if all flags are disabled then enable them *)
    flag_on [opt,s | opt,s <- dic_all_thms;
                     not (List.mem s deprecated_common)];
    (* flag jk enable other sub flags [jka;jkc;jkac] *)
    config_jks ()

let commute_flag_check () =
  match [s | opt,s <- dic_all_thms;
             List.mem s (deprecated_common @ deprecated_commute);
             !(getB opt)] with
  | [] -> ()
  | unsupported_flags ->
      begin
        Format.printf
          "unsupported flags are given:\n%s@."
          (String.concat "," unsupported_flags);
        exit 1;
      end

let commute_flag_on () =
  if not !flag then
      flag_off ()
  else
    (* if all flags are disabled then enable them *)
    let deprecated_flags = deprecated_common @ deprecated_commute in
    flag_on [opt,s | opt,s <- dic_all_thms;
                     not (List.mem s deprecated_flags)]

let debug     = ref false (* show cover *)
let show_time = ref false (* associate to Console.watcher *)
let dump      = ref (None : string option) (* output dir for debug information *)
let test      = ref false

let set_dump path = dump := Some path
