open Format

type t = 
  | V of string
  | F of string * t list

type rule = (t * t)
type trs  = rule list

type pos = int list

(* symbols *)
val vars_raw : t -> string list
val vars     : t -> string list
val funs_raw : t -> string list
val funs     : t -> string list
val symbols  : t -> string list
val root     : t -> string
val root_f   : t -> string option

(* substitution *)
val subst          : (string * t) list -> t -> t
val replace_symbol : (string * string) list -> t -> t
val rename         : t -> t
val renames        : t list -> t list

(* subterm *)
val p_subterms       : t -> t list
val subterms         : t -> t list
val subterm_with_pos : t -> (t * pos) list

(* position *)
val poss       : t -> pos list
val poss_fun   : t -> pos list
val pos_in     : t -> t -> pos list (* position of s in t *)
val subterm_at : t -> pos -> t
val replace    : t -> t -> pos -> t (* replace s t p = s[t]p *)

(* syntactic predicate *)
val is_var     : t -> bool
val is_const   : t -> bool
val top_is     : string -> t -> bool
val linear     : t -> bool
val consist    : (string * t) list -> bool
val subterm_of : t -> t -> bool

(* printer *)
val ppf_stdout : unit -> formatter
val print      : formatter -> t -> unit
val sprint     : t -> string

val sprint_pos : pos -> string
val print_pos  : pos -> unit

val sprint_    : unit -> t -> string

(* special *)
(* return fresh [var,cons] corresponded input *)
val fresh_var   : string -> t
val fresh_const : string -> t
val new_var     : unit -> t
val new_const   : unit -> t
