exception Timeout
exception Failed

let finally handler f x =
  let r = try f x with e -> handler (); raise e in 
  handler (); r

let task sleep n =
  Unix.sleep sleep; n

let rec loop n = loop n

let set_exception () = 
  Sys.set_signal Sys.sigvtalrm
    (Sys.Signal_handle (fun _ -> raise Timeout))

let off () =
  ignore
    (Unix.setitimer 
       Unix.ITIMER_VIRTUAL 
       { Unix.it_value = 0.; Unix.it_interval = 0. })


let try_with_timeout ?timeout f_timeout f x = 
  match timeout with
  | None -> f x
  | Some 0. -> f_timeout ()
  | Some t ->
    begin
      set_exception ();
      ignore 
	(Unix.setitimer Unix.ITIMER_VIRTUAL 
	   { Unix.it_interval = 0.; Unix.it_value = t });
      try
	finally off f x
      with
	Timeout -> f_timeout ()
    end
