%{
open Num
open Lexing
open Term
open Parsing

let add xs rs (xs', rs') = (xs @ xs', rs @ rs')

let rec convert_term xs = function
  | V _ as t -> t
  | F (x, []) when List.mem x xs -> V x
  | F (f, ts) -> F (f, List.map (convert_term xs) ts)

let convert_rule xs (l, r) = (convert_term xs l, convert_term xs r)

let convert_rules (xs, rs) = List.map (convert_rule xs) rs

let syntax_error msg =
  let p = symbol_start_pos () in
  Format.eprintf "File %S at line %d, character %d:@.%s@." 
    p.pos_fname p.pos_lnum (p.pos_cnum - p.pos_bol + 1) msg;
  exit 1

let type_check = function
  | "COMMUTATION" -> ()
  | s             -> syntax_error ("Incorrect PROBLEM: " ^ s)

%}

%token <string> IDENT
%token LPAREN RPAREN 
%token ARROW COMMA EOF 
%token PROBLEM VAR RULES SIG COMMENT OTHER

%type <Trs.t list> toplevel
%type <Trs.t> system
%start toplevel system

%%

toplevel:
  | LPAREN PROBLEM IDENT RPAREN systems EOF
      { type_check $3; $5 }

systems:
  | comment_decl systems { $2 }
  | system systems       { $1 :: $2 }
  |                      { [] }
  | error { syntax_error "Syntax error." }

system:
  | var_decl sig_decl rules_decl { convert_rules ($1,$3) }
  |          sig_decl rules_decl { convert_rules ([],$2) }
  | var_decl rules_decl { convert_rules ($1,$2) }
  |          rules_decl { convert_rules ([],$1) }
  | error               { syntax_error "Syntax error." }

var_decl:
  | LPAREN VAR vars RPAREN { $3 }
  | error { syntax_error "Syntax error." }

rules_decl:
  | LPAREN RULES rules RPAREN { $3 }
  | error { syntax_error "Syntax error." }

sig_decl:
  | LPAREN SIG aritylist RPAREN { () }

comment_decl:
  | LPAREN COMMENT anylist RPAREN { () }

// any_decl:
//  | LPAREN IDENT anylist RPAREN any_decl { () }
//  | error { syntax_error "Syntax error." }

anylist:
  | any anylist { () }
  |             { () }

any:
  | LPAREN anylist RPAREN { () }
  | IDENT { () } 
  | ARROW { () }
  | COMMA { () }
  | OTHER { () }

vars:
  | IDENT vars { $1 :: $2 }
  |            { [] }

rules:
  | rule rules { $1 :: $2 }
  | { [] }

rule:
  | term ARROW term { ($1, $3) }
  | error      { syntax_error "Syntax error." }

term:
  | IDENT LPAREN terms RPAREN { F ($1, $3) }
  | IDENT                     { F ($1, []) }
  | error { syntax_error "Syntax error." }

terms:
  | term COMMA terms { $1 :: $3 }
  | term             { [$1] }
  |                  { [] }

aritylist:
  | arity aritylist { $1 :: $2 }
  | { [] }

arity:
  | LPAREN IDENT IDENT RPAREN { ($2, $3) }
  | error { syntax_error "Syntax error." }
