open Format
open Lexing

let finally x f g =
  let r = try f x with e -> g x; raise e in 
  g x; r

let syntax_error p =
  eprintf "File %S at line %d, character %d:@.Syntax error.@." 
    p.pos_fname p.pos_lnum (p.pos_cnum - p.pos_bol)


(* read_trs *)
let read_trs_aux lexbuf p =
    let lex_curr_p = { lexbuf.lex_curr_p with pos_fname = p } in
    try
      Coll_parser.system Coll_lexer.token { lexbuf with lex_curr_p = lex_curr_p }
    with Parsing.Parse_error -> 
      (syntax_error lexbuf.lex_curr_p; exit 1)

let read_trs_from_string s = read_trs_aux (from_string s) "string"

let read_trs filename =
  let f ch = 
    read_trs_aux (from_channel ch) filename
  in
  finally (open_in filename) f close_in

  
(* read_problem *)
let read_problem_aux lexbuf p =
    let lex_curr_p = { lexbuf.lex_curr_p with pos_fname = p } in
    try
      Coll_parser.toplevel Coll_lexer.token { lexbuf with lex_curr_p = lex_curr_p }
    with Parsing.Parse_error -> 
      (syntax_error lexbuf.lex_curr_p; exit 1)

let read_problem_from_string s = read_problem_aux (from_string s) "string"

let read_problem filename =
  let f ch = 
    read_problem_aux (from_channel ch) filename
  in
  finally (open_in filename) f close_in
